/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.MouseInputAdapter;

public class DasEventsIndicator
extends DasCanvasComponent
implements DataSetUpdateListener {
    DasAxis axis;
    DataSetDescriptor dsd;
    VectorDataSet vds;
    String planeId;
    int[] eventMap;

    public DasEventsIndicator(DataSetDescriptor dataSetDescriptor, DasAxis dasAxis, String string) {
        if (!dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("Axis must be horizontal");
        }
        this.axis = dasAxis;
        this.dsd = dataSetDescriptor;
        dataSetDescriptor.addDataSetUpdateListener(this);
        dasAxis.addPropertyChangeListener("dataMinimum", this.getPropertyChangeListener());
        dasAxis.addPropertyChangeListener("dataMaximum", this.getPropertyChangeListener());
        dasAxis.addPropertyChangeListener("log", this.getPropertyChangeListener());
        MyMouseAdapter myMouseAdapter = new MyMouseAdapter(this, string);
        this.addMouseListener(myMouseAdapter);
        this.addMouseMotionListener(myMouseAdapter);
    }

    private PropertyChangeListener getPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DasEventsIndicator.this.markDirty();
                DasEventsIndicator.this.update();
            }
        };
    }

    public void paint(Graphics graphics) {
        block14: {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(-this.getX(), -this.getY());
            graphics2D.setColor(Color.white);
            graphics2D.fill(this.getBounds());
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.draw(new Rectangle(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1));
            graphics2D.setColor(new Color(100, 100, 100, 180));
            this.eventMap = new int[this.getWidth()];
            try {
                int n;
                int n2;
                int n3;
                int n4;
                this.vds = (VectorDataSet)this.dsd.getDataSet(this.axis.getDataMinimum(), this.axis.getDataMaximum(), null, null);
                if (this.vds.getPlanarView("xTagWidth") == null) {
                    throw new IllegalArgumentException("no xTagWidth plane found.");
                }
                VectorDataSet vectorDataSet = (VectorDataSet)this.vds.getPlanarView("xTagWidth");
                int n5 = 0;
                while (n5 < this.eventMap.length) {
                    this.eventMap[n5] = -1;
                    ++n5;
                }
                if (this.vds.getXLength() <= 0) break block14;
                UnitsConverter unitsConverter = UnitsConverter.getConverter(vectorDataSet.getYUnits(), this.axis.getUnits().getOffsetUnits());
                int n6 = 0;
                int n7 = this.vds.getXLength();
                int n8 = n6;
                while (n8 < n7) {
                    Datum datum = this.vds.getXTagDatum(n8);
                    n4 = this.axis.transform(datum);
                    if (unitsConverter != null) {
                        Datum datum2 = vectorDataSet.getDatum(n8);
                        n3 = this.axis.transform(datum.add(datum2)) - n4;
                    } else {
                        n3 = 1;
                    }
                    if (n3 == 0) {
                        n3 = 1;
                    }
                    graphics2D.fill(new Rectangle(n4, this.getY(), n3, this.getHeight()));
                    n2 = n4 - this.getX();
                    n = n2 - 1;
                    int n9 = n2 + n3 + 1;
                    int n10 = n;
                    while (n10 < n9) {
                        if (n10 >= 0 && n10 < this.eventMap.length) {
                            this.eventMap[n10] = n8;
                        }
                        ++n10;
                    }
                    ++n8;
                }
                int n11 = 1;
                while (n11 <= 2) {
                    n4 = -1;
                    while (n4 <= 1) {
                        n3 = n4 == 1 ? 0 : this.eventMap.length - 1;
                        n2 = n4 == 1 ? this.eventMap.length - n11 : n11;
                        n = n3;
                        while (n != n2) {
                            if (this.eventMap[n] == -1) {
                                this.eventMap[n] = this.eventMap[n + n4];
                            }
                            n += n4;
                        }
                        n4 += 2;
                    }
                    ++n11;
                }
            }
            catch (DasException dasException) {
                graphics2D.drawString("exception: " + dasException.getMessage(), this.getX(), this.getY() + this.getHeight());
            }
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.dsd = dataSetDescriptor;
        this.markDirty();
        this.update();
    }

    public void dataSetUpdated(DataSetUpdateEvent dataSetUpdateEvent) {
        this.markDirty();
        this.update();
    }

    class MyMouseAdapter
    extends MouseInputAdapter {
        DasEventsIndicator parent;
        String planeId;

        MyMouseAdapter(DasEventsIndicator dasEventsIndicator2, String string) {
            this.parent = dasEventsIndicator2;
            this.planeId = string;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.parent.vds == null) {
                return;
            }
            if (this.parent.vds.getXLength() == 0) {
                return;
            }
            int n = mouseEvent.getX() + this.parent.getX();
            Datum datum = this.parent.axis.invTransform(n);
            int n2 = DasEventsIndicator.this.eventMap[mouseEvent.getX()];
            if (n2 >= 0) {
                Datum datum2 = this.parent.vds.getXTagDatum(n2);
                Datum datum3 = this.parent.vds.getDatum(n2);
                VectorDataSet vectorDataSet = (VectorDataSet)DasEventsIndicator.this.vds.getPlanarView("xTagWidth");
                Datum datum4 = vectorDataSet.getDatum(n2);
                this.parent.setToolTipText("" + datum2 + " " + datum4 + " " + datum3);
            } else {
                this.parent.setToolTipText(null);
            }
        }
    }
}

