/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DasZAxisPlot;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.text.ParseException;
import java.util.Collections;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasSpectrogramPlot
extends DasPlot
implements DasZAxisPlot {
    private TableDataSet rebinData;
    private SpectrogramRenderer renderer;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasRow;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColumn;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasAxis;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColorBar;

    public static DasSpectrogramPlot create(DasCanvas dasCanvas, TableDataSet tableDataSet) {
        DasRow dasRow = new DasRow(dasCanvas, 0.05, 0.85);
        DasColumn dasColumn = new DasColumn(dasCanvas, 0.15, 0.8);
        int n = tableDataSet.getXLength();
        int n2 = tableDataSet.getYLength(0);
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = tableDataSet.getXTagDouble(n3, tableDataSet.getXUnits());
            ++n3;
        }
        double[] dArray2 = new double[n2];
        int n4 = 0;
        while (n4 < n2) {
            dArray2[n4] = tableDataSet.getYTagDouble(0, n4, tableDataSet.getYUnits());
            ++n4;
        }
        double d = Double.NaN;
        double[] dArray3 = new double[n * n2];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            int n7 = 0;
            while (n7 < n2) {
                double d2 = tableDataSet.getDouble(n6, n7, tableDataSet.getZUnits());
                if (!Double.isNaN(d2)) {
                    dArray3[n5++] = d2;
                }
                ++n7;
            }
            ++n6;
        }
        double[] dArray4 = new double[n5];
        System.arraycopy(dArray3, 0, dArray4, 0, n5);
        DasColorBar dasColorBar = new DasColorBar(Datum.create(0, tableDataSet.getZUnits()), Datum.create(0, tableDataSet.getZUnits()), false);
        dasColorBar.setColumn(DasColorBar.getColorBarColumn(dasColumn));
        dasColorBar.setDataRange(dArray4);
        DasAxis dasAxis = new DasAxis(Datum.create(0, tableDataSet.getXUnits()), Datum.create(0, tableDataSet.getXUnits()), 2, false);
        dasAxis.setDataRange(dArray);
        DasAxis dasAxis2 = new DasAxis(Datum.create(0, tableDataSet.getYUnits()), Datum.create(0, tableDataSet.getYUnits()), 3, false);
        dasAxis.setDataRange(dArray);
        DasSpectrogramPlot dasSpectrogramPlot = new DasSpectrogramPlot(tableDataSet, dasAxis, dasAxis2, dasRow, dasColumn, dasColorBar);
        return dasSpectrogramPlot;
    }

    public DasSpectrogramPlot() {
        this(null, null, null, null);
    }

    public DasSpectrogramPlot(TableDataSet tableDataSet, DasAxis dasAxis, DasAxis dasAxis2, DasRow dasRow, DasColumn dasColumn, DasColorBar dasColorBar) {
        this(tableDataSet == null ? null : new ConstantDataSetDescriptor(tableDataSet), dasAxis, dasAxis2, dasColorBar);
    }

    public DasSpectrogramPlot(DataSetDescriptor dataSetDescriptor, DasAxis dasAxis, DasAxis dasAxis2, DasColorBar dasColorBar) {
        super(dasAxis, dasAxis2);
        this.renderer = new SpectrogramRenderer(this, dataSetDescriptor, dasColorBar);
        this.addRenderer(this.renderer);
    }

    public TableDataSet getRebinData() {
        return this.rebinData;
    }

    public DasColorBar getColorBar() {
        return this.renderer.getColorBar();
    }

    public void setColorBar(DasColorBar dasColorBar) {
    }

    public void setDataSetID(String string) throws DasException {
        this.renderer.setDataSetID(string);
        this.markDirty();
        this.update();
    }

    public String getDataSetID() {
        return this.renderer.getDataSetID();
    }

    private static TableDataSet createEmptyDataSet() {
        double[] dArray;
        Units units;
        Units units2 = units = Units.dimensionless;
        Units units3 = units;
        double[] dArray2 = dArray = new double[0];
        double[][] dArrayArray = new double[][]{};
        DefaultTableDataSet defaultTableDataSet = new DefaultTableDataSet(dArray2, units3, dArray, units2, dArrayArray, units, Collections.EMPTY_MAP);
        return defaultTableDataSet;
    }

    public SpectrogramRenderer getRenderer() {
        return this.renderer;
    }

    public void setZAxis(DasAxis dasAxis) {
    }

    public DasAxis getZAxis() {
        return this.renderer.getColorBar();
    }

    protected void installComponent() {
        super.installComponent();
    }

    static DasSpectrogramPlot processSpectrogramElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        String string = element.getAttribute("name");
        DasRow dasRow = (DasRow)formBase.checkValue(element.getAttribute("row"), class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
        DasColumn dasColumn = (DasColumn)formBase.checkValue(element.getAttribute("column"), class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
        DasAxis dasAxis = null;
        DasAxis dasAxis2 = null;
        DasColorBar dasColorBar = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object instanceof Element) {
                if (object.getNodeName().equals("xAxis")) {
                    dasAxis = DasSpectrogramPlot.processXAxisElement((Element)object, formBase);
                } else if (object.getNodeName().equals("yAxis")) {
                    dasAxis2 = DasSpectrogramPlot.processYAxisElement((Element)object, formBase);
                } else if (object.getNodeName().equals("zAxis")) {
                    dasColorBar = DasSpectrogramPlot.processZAxisElement((Element)object, formBase);
                }
            }
            ++n;
        }
        if (dasAxis == null) {
            dasAxis = (DasAxis)formBase.checkValue(element.getAttribute("xAxis"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<axis> or <timeaxis>");
        }
        if (dasAxis2 == null) {
            dasAxis2 = (DasAxis)formBase.checkValue(element.getAttribute("yAxis"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<axis> or <timeaxis>");
        }
        if (dasColorBar == null) {
            dasColorBar = (DasColorBar)formBase.checkValue(element.getAttribute("colorbar"), class$edu$uiowa$physics$pw$das$graph$DasColorBar == null ? (class$edu$uiowa$physics$pw$das$graph$DasColorBar = DasSpectrogramPlot.class$("edu.uiowa.physics.pw.das.graph.DasColorBar")) : class$edu$uiowa$physics$pw$das$graph$DasColorBar, "<colorbar>");
        }
        object = new DasSpectrogramPlot(null, dasAxis, dasAxis2, dasColorBar);
        ((DasPlot)object).setTitle(element.getAttribute("title"));
        try {
            ((DasSpectrogramPlot)object).setDataSetID(element.getAttribute("dataPath"));
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        try {
            ((DasCanvasComponent)object).setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return object;
    }

    private static DasAxis processXAxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (node.getNodeName().equals("axis")) {
                    element2.setAttribute("orientation", "horizontal");
                    return DasAxis.processAxisElement(element2, formBase);
                }
                if (node.getNodeName().equals("timeaxis")) {
                    element2.setAttribute("orientation", "horizontal");
                    return DasAxis.processTimeaxisElement(element2, formBase);
                }
                if (node.getNodeName().equals("attachedaxis")) {
                    element2.setAttribute("orientation", "horizontal");
                    return DasAxis.processAttachedaxisElement(element2, formBase);
                }
            }
            ++n;
        }
        return null;
    }

    private static DasAxis processYAxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (node.getNodeName().equals("axis")) {
                    element2.setAttribute("orientation", "vertical");
                    return DasAxis.processAxisElement(element2, formBase);
                }
                if (node.getNodeName().equals("timeaxis")) {
                    element2.setAttribute("orientation", "vertical");
                    return DasAxis.processTimeaxisElement(element2, formBase);
                }
                if (node.getNodeName().equals("attachedaxis")) {
                    element2.setAttribute("orientation", "vertical");
                    return DasAxis.processAttachedaxisElement(element2, formBase);
                }
            }
            ++n;
        }
        return null;
    }

    private static DasColorBar processZAxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element && node.getNodeName().equals("colorbar")) {
                return DasColorBar.processColorbarElement((Element)node, formBase);
            }
            ++n;
        }
        return null;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("spectrogram");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("title", this.getTitle());
        element.setAttribute("dataPath", this.getDataSetID());
        Element element2 = document.createElement("xAxis");
        Element element3 = this.getXAxis().getDOMElement(document);
        element3.removeAttribute("orientation");
        if (element3.getAttribute("row").equals(this.getRow().getDasName())) {
            element3.removeAttribute("row");
        }
        if (element3.getAttribute("column").equals(this.getColumn().getDasName())) {
            element3.removeAttribute("column");
        }
        element2.appendChild(element3);
        element.appendChild(element2);
        Element element4 = document.createElement("yAxis");
        Element element5 = this.getYAxis().getDOMElement(document);
        element5.removeAttribute("orientation");
        if (element5.getAttribute("row").equals(this.getRow().getDasName())) {
            element5.removeAttribute("row");
        }
        if (element5.getAttribute("column").equals(this.getColumn().getDasName())) {
            element5.removeAttribute("column");
        }
        element4.appendChild(element5);
        element.appendChild(element4);
        Element element6 = document.createElement("zAxis");
        Element element7 = this.getColorBar().getDOMElement(document);
        if (element7.getAttribute("row").equals(this.getRow().getDasName())) {
            element7.removeAttribute("row");
        }
        if (element7.getAttribute("column").equals(this.getColumn().getDasName())) {
            element7.removeAttribute("column");
        }
        element6.appendChild(element7);
        element.appendChild(element6);
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

