/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Stack;
import javax.swing.event.EventListenerList;

public class DataRange
implements Cloneable {
    private DasAxis parent;
    private Units units;
    private double minimum;
    private double maximum;
    private boolean log;
    private EventListenerList listenerList = new EventListenerList();
    private Stack history;
    private Stack forwardHistory;
    private PropertyChangeSupport propertyChangeDelegate;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener;

    public DataRange(DasAxis dasAxis, Datum datum, Datum datum2, boolean bl) {
        if (datum.gt(datum2)) {
            throw new IllegalArgumentException("data min on axis is greater than data max");
        }
        if (!datum.isValid()) {
            throw new IllegalArgumentException("data_minimum on axis is NaN");
        }
        if (!datum2.isValid()) {
            throw new IllegalArgumentException("data_maximum on axis is NaN");
        }
        if (datum.getUnits() != datum2.getUnits()) {
            throw new IllegalArgumentException("units don't match on range");
        }
        this.parent = dasAxis;
        this.units = datum.getUnits();
        this.minimum = datum.doubleValue(this.units);
        this.maximum = datum2.doubleValue(this.units);
        this.log = bl;
        this.history = new Stack();
        this.forwardHistory = new Stack();
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean bl) {
        if (this.log == bl) {
            return;
        }
        boolean bl2 = this.log;
        if (bl && (this.minimum <= 0.0 || this.maximum <= 0.0)) {
            return;
        }
        this.log = bl;
        this.firePropertyChange("log", bl2, bl);
        this.fireUpdate();
    }

    public DasAxis getCreator() {
        return this.parent;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        if (this.units.equals(units)) {
            return;
        }
        try {
            this.minimum = this.units.convertDoubleTo(units, this.minimum);
            this.maximum = this.units.convertDoubleTo(units, this.maximum);
            this.units = units;
        }
        catch (Exception exception) {
            this.units = units;
            this.minimum = 1.0;
            this.maximum = 10.0;
        }
        this.forwardHistory.clear();
        this.history.clear();
    }

    public void setMinimum(double d) {
        if (d > this.maximum) {
            if (this.isLog()) {
                this.setRange(d, d * 10.0);
            } else {
                this.setRange(d, d + 1.0);
            }
        } else {
            this.setRange(d, this.maximum);
        }
    }

    public void setMaximum(double d) {
        if (d < this.minimum) {
            if (this.isLog()) {
                this.setRange(d / 10.0, d);
            } else {
                this.setRange(d - 1.0, d);
            }
        } else {
            this.setRange(this.minimum, d);
        }
    }

    public void setRange(double d, double d2) {
        boolean bl = true;
        if (d > d2) {
            DasDie.println("min>max in DasAxis.DataRange.setRange");
            d2 = this.isLog() ? d * 10.0 : d + 1.0;
        }
        if (this.isLog()) {
            if (d < 0.0) {
                d = this.minimum;
            }
            if (d2 < 0.0) {
                d2 = this.maximum;
            }
        }
        if (bl) {
            Datum[] datumArray = new Datum[2];
            if (this.minimum != this.maximum) {
                datumArray[0] = Datum.create(this.minimum, this.units);
                datumArray[1] = Datum.create(this.maximum, this.units);
                this.history.push(datumArray);
            }
            this.forwardHistory.removeAllElements();
        }
        double d3 = this.minimum;
        double d4 = this.maximum;
        this.minimum = d;
        this.maximum = d2;
        this.fireUpdate();
        if (this.minimum != d3) {
            this.firePropertyChange("minimum", d3, this.minimum);
        }
        if (this.maximum != d4) {
            this.firePropertyChange("maximum", d4, this.maximum);
        }
    }

    public void setRangePrev() {
        double d = this.minimum;
        double d2 = this.maximum;
        DasDie.println("history: " + this.history.size());
        DasDie.println("forwardHistory: " + this.forwardHistory.size());
        if (!this.history.isEmpty()) {
            this.forwardHistory.push(new Datum[]{Datum.create(this.minimum, this.units), Datum.create(this.maximum, this.units)});
            Datum[] datumArray = (Datum[])this.history.pop();
            if (datumArray[0].getUnits() != this.units) {
                datumArray[0] = datumArray[0].convertTo(this.units);
                datumArray[1] = datumArray[1].convertTo(this.units);
            }
            this.minimum = datumArray[0].doubleValue(this.units);
            this.maximum = datumArray[1].doubleValue(this.units);
            this.fireUpdate();
        }
        if (this.minimum != d) {
            this.firePropertyChange("minimum", d, this.minimum);
        }
        if (this.maximum != d2) {
            this.firePropertyChange("maximum", d2, this.maximum);
        }
        DasDie.println("history: " + this.history.size());
        DasDie.println("forwardHistory: " + this.forwardHistory.size());
        DasDie.println("-------------");
    }

    public void setRangeForward() {
        double d = this.minimum;
        double d2 = this.maximum;
        DasDie.println("history: " + this.history.size());
        DasDie.println("forwardHistory: " + this.forwardHistory.size());
        if (!this.forwardHistory.isEmpty()) {
            this.history.push(new Datum[]{Datum.create(this.minimum, this.units), Datum.create(this.maximum, this.units)});
            Datum[] datumArray = (Datum[])this.forwardHistory.pop();
            if (datumArray[0].getUnits() != this.units) {
                datumArray[0] = datumArray[0].convertTo(this.units);
                datumArray[1] = datumArray[1].convertTo(this.units);
            }
            this.minimum = datumArray[0].doubleValue(this.units);
            this.maximum = datumArray[1].doubleValue(this.units);
            this.fireUpdate();
        }
        DasDie.println("history: " + this.history.size());
        DasDie.println("forwardHistory: " + this.forwardHistory.size());
        if (this.minimum != d) {
            this.firePropertyChange("minimum", d, this.minimum);
        }
        if (this.maximum != d2) {
            this.firePropertyChange("maximum", d2, this.maximum);
        }
        DasDie.println("history: " + this.history.size());
        DasDie.println("forwardHistory: " + this.forwardHistory.size());
        DasDie.println("-------------");
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, double d, double d2) {
        this.firePropertyChange(string, new Double(d), new Double(d2));
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeDelegate.firePropertyChange(string, object, object2);
    }

    public void addpwUpdateListener(DasUpdateListener dasUpdateListener) {
        this.listenerList.add(class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener = DataRange.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener")) : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener, dasUpdateListener);
    }

    public void removepwUpdateListener(DasUpdateListener dasUpdateListener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener = DataRange.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener")) : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener, dasUpdateListener);
    }

    protected void fireUpdate() {
        Object[] objectArray = this.listenerList.getListenerList();
        DasUpdateEvent dasUpdateEvent = new DasUpdateEvent(this);
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? DataRange.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener") : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener)) {
                ((DasUpdateListener)objectArray[n + 1]).update(dasUpdateEvent);
            }
            n -= 2;
        }
    }

    public void popHistory() {
        if (!this.history.empty()) {
            this.history.pop();
        }
    }

    public DataRange getAnimationDataRange() {
        Datum datum = Datum.create(this.getMinimum(), this.getUnits());
        Datum datum2 = Datum.create(this.getMaximum(), this.getUnits());
        return new DataRange(this.parent, datum, datum2, this.isLog()){

            protected void fireUpdate() {
            }

            public void setRange(double d, double d2) {
                if (d > d2) {
                    DasDie.println("min>max in DasAxis.DataRange.setRange");
                    d2 = this.isLog() ? d * 10.0 : d + 1.0;
                }
                if (this.isLog()) {
                    if (d < 0.0) {
                        d = DataRange.this.minimum;
                    }
                    if (d2 < 0.0) {
                        d2 = DataRange.this.maximum;
                    }
                }
                DataRange.this.minimum = d;
                DataRange.this.maximum = d2;
            }

            public double getMinimum() {
                return DataRange.this.minimum;
            }

            public double getMaximum() {
                return DataRange.this.maximum;
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

