/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class PsymConnector
implements Enumeration {
    String name;
    Icon imageIcon;
    BasicStroke stroke;
    BasicStroke cacheStroke;
    float cacheWidth;
    Line2D line = new Line2D.Double();
    public static final PsymConnector NONE = new PsymConnector("None", null);
    public static final PsymConnector SOLID = new PsymConnector("Solid", new BasicStroke(1.0f));
    public static final PsymConnector DOTFINE = new PsymConnector("DotFine", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.5f, 2.0f}, 0.0f));
    public static final PsymConnector DASHFINE = new PsymConnector("DashFine", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 2.0f}, 0.0f));
    public static final PsymConnector PSYM10 = new PsymConnector("Psym10", new BasicStroke(1.0f)){

        public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f) {
            graphics2D.setStroke(this.getStroke(f));
            int n5 = (n + n3) / 2;
            Line2D line2D = !SwingUtilities.isEventDispatchThread() ? new Line2D.Double() : this.line;
            line2D.setLine(n, n2, n5, n2);
            graphics2D.draw(line2D);
            line2D.setLine(n5, n2, n5, n4);
            graphics2D.draw(line2D);
            line2D.setLine(n5, n4, n3, n4);
            graphics2D.draw(line2D);
        }
    };

    private PsymConnector(String string, BasicStroke basicStroke) {
        this.name = string;
        this.stroke = basicStroke;
        this.cacheStroke = basicStroke;
        if (basicStroke != null) {
            this.cacheWidth = this.cacheStroke.getLineWidth();
        }
        BufferedImage bufferedImage = new BufferedImage(15, 10, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, 0, 15, 10);
        graphics2D.setColor(Color.black);
        this.drawLine(graphics2D, 2, 3, 13, 7, 2.0f);
        this.imageIcon = new ImageIcon(bufferedImage);
    }

    protected Stroke getStroke(float f) {
        if (f != this.cacheWidth) {
            float[] fArray = this.stroke.getDashArray();
            float[] fArray2 = null;
            if (fArray != null) {
                fArray2 = new float[fArray.length];
                int n = 0;
                while (n < fArray.length) {
                    fArray2[n] = fArray[n] * f;
                    ++n;
                }
            }
            this.cacheStroke = new BasicStroke(f, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), fArray2, this.stroke.getDashPhase() * f);
            this.cacheWidth = f;
        }
        return this.cacheStroke;
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f) {
        if (this.stroke == null) {
            return;
        }
        Line2D line2D = !SwingUtilities.isEventDispatchThread() ? new Line2D.Double() : this.line;
        line2D.setLine(n, n2, n3, n4);
        graphics2D.setStroke(this.getStroke(f));
        graphics2D.draw(line2D);
    }

    public Icon getListIcon() {
        return this.imageIcon;
    }

    public String toString() {
        return this.name;
    }
}

