/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.util.FixedWidthFormatter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataTransferType {
    private static final int I_SUN_REAL4 = 0;
    private static final int I_SUN_REAL8 = 1;
    private static final int I_ASCII = 2;
    private static final Map map = new HashMap();
    public static final DataTransferType SUN_REAL4 = new DataTransferType("sun_real4", 0, 4, false);
    public static final DataTransferType SUN_REAL8 = new DataTransferType("sun_real8", 1, 8, false);
    private static final Pattern ASCII_PATTERN = Pattern.compile("ascii([1-9][0-9]?)");
    private final String name;
    private final int sizeBytes;
    private final boolean ascii;
    private final int id;
    private DecimalFormat doubleFormatter;
    private static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;

    private DataTransferType(String string, int n, int n2, boolean bl) {
        this.name = string;
        this.id = n;
        this.sizeBytes = n2;
        this.ascii = bl;
        map.put(string, this);
        if (bl) {
            this.doubleFormatter = new DecimalFormat(DataTransferType.getFormat(n2 - 1));
        }
    }

    public String toString() {
        return this.name;
    }

    public int getSizeBytes() {
        return this.sizeBytes;
    }

    public static DataTransferType getByName(String string) {
        DataTransferType dataTransferType = (DataTransferType)map.get(string);
        if (dataTransferType == null) {
            Matcher matcher = ASCII_PATTERN.matcher(string);
            if (matcher.matches()) {
                int n = Integer.parseInt(matcher.group(1));
                dataTransferType = new DataTransferType(string, 2, n, true);
                map.put(string, dataTransferType);
            } else {
                throw new RuntimeException("Unsupported type: " + string);
            }
        }
        return dataTransferType;
    }

    public boolean isAscii() {
        return this.ascii;
    }

    public double read(ByteBuffer byteBuffer) {
        double d;
        ByteOrder byteOrder = byteBuffer.order();
        try {
            double d2;
            switch (this.id) {
                case 0: {
                    byteBuffer.order(BIG_ENDIAN);
                    d2 = byteBuffer.getFloat();
                    break;
                }
                case 1: {
                    byteBuffer.order(BIG_ENDIAN);
                    d2 = byteBuffer.getDouble();
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[this.sizeBytes];
                    byteBuffer.get(byArray);
                    String string = new String(byArray, "ASCII").trim();
                    d2 = Double.parseDouble(string);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid id: " + this.id);
                }
            }
            d = d2;
            Object var8_8 = null;
            byteBuffer.order(byteOrder);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                throw new RuntimeException(unsupportedEncodingException);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                byteBuffer.order(byteOrder);
                throw throwable;
            }
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    public void write(double var1_1, ByteBuffer var3_2) {
        var4_3 = var3_2.order();
        try {
            try {
                switch (this.id) {
                    case 0: {
                        var3_2.order(DataTransferType.BIG_ENDIAN);
                        var3_2.putFloat((float)var1_1);
                        ** break;
                    }
                    case 1: {
                        var3_2.order(DataTransferType.BIG_ENDIAN);
                        var3_2.putDouble(var1_1);
                        ** break;
                    }
                    case 2: {
                        var5_4 = this.doubleFormatter.format(var1_1) + " ";
                        if (this.sizeBytes < 10) {
                            var5_4 = FixedWidthFormatter.format(var5_4, this.sizeBytes - 1);
                        }
                        var6_6 = var5_4.getBytes("US-ASCII");
                        var3_2.put(var6_6);
                        ** break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid id: " + this.id);
lbl27:
                        // 3 sources

                    }
                }
            }
            catch (UnsupportedEncodingException var5_5) {
                throw new RuntimeException(var5_5);
            }
            var8_7 = null;
            var3_2.order(var4_3);
        }
        catch (Throwable var7_9) {
            var8_8 = null;
            var3_2.order(var4_3);
            throw var7_9;
        }
    }

    private static String getFormat(int n) {
        if (n < 9) {
            return "0.#";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("+0.");
        int n2 = 0;
        while (n2 < n - 7) {
            stringBuffer.append('0');
            ++n2;
        }
        stringBuffer.append("E00;-#");
        return stringBuffer.toString();
    }
}

