/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamProcessor;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GZipStreamProcessor
extends StreamProcessor {
    public void process(InputStream inputStream, OutputStream outputStream) throws IOException {
        Object object;
        int n;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        byte[] byArray = new byte[4];
        boolean bl = false;
        int n2 = n = pushbackInputStream.read(byArray, 0, 4);
        while (n != -1 && n2 < 4) {
            n = pushbackInputStream.read(byArray, n2, 4 - n2);
            n2 += n;
        }
        if (!Arrays.equals(byArray, "[00]".getBytes())) {
            throw new IOException("Expected [00], got " + new String(byArray));
        }
        byte[] byArray2 = StreamTool.readXML(pushbackInputStream);
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray2));
            object = StreamDescriptor.parseHeader(inputStreamReader);
            Element element = object.getDocumentElement();
            if (!element.getAttribute("compression").equals("") && !(bl = (string = element.getAttribute("compression")).equals("gzip"))) {
                throw new IOException("unsupported compression used: " + string);
            }
            element.setAttribute("compression", "gzip");
            byArray2 = StreamDescriptor.createHeader((Document)object).getBytes();
            outputStream.write("[00]".getBytes());
            outputStream.write(byArray2);
        }
        catch (DasException dasException) {
            outputStream.write(this.getDasExceptionStream(dasException));
        }
        if (!bl) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        int n3 = 0;
        object = new byte[2048];
        while (n3 != -1) {
            n3 = pushbackInputStream.read((byte[])object);
            if (n3 <= -1) continue;
            outputStream.write((byte[])object, 0, n3);
        }
        if (!bl) {
            ((GZIPOutputStream)outputStream).finish();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        if (stringArray.length > 0) {
            try {
                inputStream = new FileInputStream(stringArray[0]);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Input file not found");
                System.err.println("  file=" + stringArray[0]);
                System.exit(-1);
            }
        } else {
            inputStream = System.in;
        }
        if (stringArray.length > 1) {
            try {
                outputStream = new FileOutputStream(stringArray[1]);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            outputStream = System.out;
        }
        new GZipStreamProcessor().process(inputStream, outputStream);
    }
}

