/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream;

import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.DasStreamFormatException;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.IDLParser;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StreamDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Map properties = new HashMap();
    private StreamXDescriptor xDescriptor;
    private ArrayList yDescriptors = new ArrayList();
    private String compression;

    public StreamDescriptor(Element element) throws StreamException {
        if (element.getTagName().equals("stream")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) throws StreamException {
        this.compression = element.getAttribute("compression");
        NodeList nodeList = element.getElementsByTagName("properties");
        if (nodeList.getLength() != 0) {
            Element element2 = (Element)nodeList.item(0);
            Map map = StreamTool.processPropertiesElement(element2);
            this.properties.putAll(map);
        }
    }

    private void processLegacyElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                SkeletonDescriptor skeletonDescriptor;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("X")) {
                    this.xDescriptor = new StreamXDescriptor(element2);
                } else if (string.equals("YScan")) {
                    skeletonDescriptor = new StreamYScanDescriptor(element2);
                    this.yDescriptors.add(skeletonDescriptor);
                } else if (string.equals("MultiY")) {
                    skeletonDescriptor = new StreamMultiYDescriptor(element2);
                    this.yDescriptors.add(skeletonDescriptor);
                }
            }
            ++n;
        }
    }

    public StreamDescriptor() {
    }

    public StreamXDescriptor getXDescriptor() {
        return this.xDescriptor;
    }

    public void setXDescriptor(StreamXDescriptor streamXDescriptor) {
        this.xDescriptor = streamXDescriptor;
    }

    public void addYScan(StreamYScanDescriptor streamYScanDescriptor) {
        this.yDescriptors.add(streamYScanDescriptor);
    }

    public void addYMulti(StreamMultiYDescriptor streamMultiYDescriptor) {
        this.yDescriptors.add(streamMultiYDescriptor);
    }

    public List getYDescriptors() {
        return Collections.unmodifiableList(this.yDescriptors);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public static Document parseHeader(Reader reader) throws DasIOException, DasStreamFormatException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(reader);
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new DasIOException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }

    public int getSizeBytes() {
        return -1;
    }

    public DatumVector read(ByteBuffer byteBuffer) {
        return null;
    }

    public void write(DatumVector datumVector, ByteBuffer byteBuffer) {
    }

    public static StreamDescriptor createLegacyDescriptor(BufferedReader bufferedReader) throws IOException {
        IDLParser iDLParser = new IDLParser();
        int n = 1;
        Pattern pattern = Pattern.compile("\\s*label\\((\\d+)\\)\\s*");
        StreamDescriptor streamDescriptor = new StreamDescriptor();
        String string = bufferedReader.readLine();
        while (string != null) {
            int n2 = string.trim().indexOf(59);
            if (n2 == 0) {
                ++n;
            } else {
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
                n2 = string.indexOf(61);
                String string2 = string.substring(0, n2).trim();
                String string3 = string.substring(n2 + 1).trim();
                if (string2.equals("description")) {
                    String string4 = string3.substring(1, string3.length() - 1);
                    streamDescriptor.properties.put(string2, string4);
                } else if (string2.equals("groupAccess")) {
                    streamDescriptor.properties.put(string2, string3.substring(1, string3.length() - 1));
                } else if (string2.equals("form")) {
                    streamDescriptor.properties.put(string2, string3);
                } else if (string2.equals("reader")) {
                    String string5 = string3.substring(1, string3.length() - 1);
                    streamDescriptor.properties.put(string2, string5);
                } else if (string2.equals("x_parameter")) {
                    String string6 = string3.substring(1, string3.length() - 1);
                    streamDescriptor.properties.put(string2, string6);
                } else if (string2.equals("x_unit")) {
                    String string7 = string3.substring(1, string3.length() - 1);
                    streamDescriptor.properties.put(string2, string7);
                } else if (string2.equals("y_parameter")) {
                    String string8 = string3.substring(1, string3.length() - 1);
                    streamDescriptor.properties.put(string2, string8);
                } else if (string2.equals("y_unit")) {
                    String string9 = string3.substring(1, string3.length() - 1);
                    streamDescriptor.properties.put(string2, string9);
                } else if (string2.equals("z_parameter")) {
                    String string10 = string3.substring(1, string3.length() - 1);
                    streamDescriptor.properties.put(string2, string10);
                } else if (string2.equals("z_unit")) {
                    String string11 = string3.substring(1, string3.length() - 1);
                    streamDescriptor.properties.put(string2, string11);
                } else if (string2.equals("x_sample_width")) {
                    double d = iDLParser.parseIDLScalar(string3);
                    if (d == Double.NaN) {
                        throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string2, new Double(d));
                } else if (string2.equals("y_fill")) {
                    double d = iDLParser.parseIDLScalar(string3);
                    if (d == Double.NaN) {
                        throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string2, new Double(d));
                } else if (string2.equals("z_fill")) {
                    double d = (float)iDLParser.parseIDLScalar(string3);
                    if (d == Double.NaN) {
                        throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string2, new Float(d));
                } else if (string2.equals("y_coordinate")) {
                    double[] dArray = iDLParser.parseIDLArray(string3);
                    if (dArray == null) {
                        throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string2, dArray);
                } else if (string2.equals("ny")) {
                    int n3;
                    try {
                        n3 = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string2, new Integer(n3));
                } else if (string2.equals("items")) {
                    int n4;
                    try {
                        n4 = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                    }
                    streamDescriptor.properties.put(string2, new Integer(n4));
                } else {
                    Matcher matcher = pattern.matcher(string2);
                    if (matcher.matches()) {
                        int n5 = Integer.parseInt(matcher.group(1));
                        string3 = string3.substring(1, string3.length() - 1);
                        if (n5 == 0) {
                            streamDescriptor.properties.put("label", string3);
                        } else {
                            String[] stringArray = StreamDescriptor.ensureCapacity((String[])streamDescriptor.properties.get("plane-list"), n5);
                            stringArray[n5 - 1] = string3;
                            streamDescriptor.properties.put("plane-list", stringArray);
                            streamDescriptor.properties.put(string3 + ".label", string3);
                        }
                    } else if (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'') {
                        streamDescriptor.properties.put(string2, string3.substring(1, string3.length() - 1));
                    } else if (string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                        streamDescriptor.properties.put(string2, string3.substring(1, string3.length() - 1));
                    } else {
                        streamDescriptor.properties.put(string2, string3);
                    }
                }
                ++n;
            }
            string = bufferedReader.readLine();
        }
        String[] stringArray = (String[])streamDescriptor.properties.get("plane-list");
        if (stringArray != null) {
            streamDescriptor.properties.put("plane-list", Collections.unmodifiableList(Arrays.asList(stringArray)));
        }
        streamDescriptor.properties.put("legacy", "true");
        return streamDescriptor;
    }

    public static String createHeader(Document document) throws DasIOException {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setOmitXMLDeclaration(true);
        outputFormat.setEncoding("UTF-8");
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        try {
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
        String string = stringWriter.toString();
        return string;
    }

    private static String[] ensureCapacity(String[] stringArray, int n) {
        if (stringArray == null) {
            return new String[n];
        }
        if (stringArray.length >= n) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String string) {
        this.compression = string;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("stream");
        if (this.compression != null && !this.compression.equals("")) {
            element.setAttribute("compression", this.compression);
        }
        if (!this.properties.isEmpty()) {
            Element element2 = document.createElement("properties");
            Iterator iterator = this.properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                element2.setAttribute(string, v.toString());
            }
            element.appendChild(element2);
        }
        return element;
    }

    public Object clone() {
        try {
            StreamDescriptor streamDescriptor = (StreamDescriptor)super.clone();
            streamDescriptor.properties = new HashMap(this.properties);
            return streamDescriptor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

