/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.stream.test;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamProducer;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;

public class SineWaveStream {
    private double frequency = 0.1;
    private boolean compress;

    public SineWaveStream(boolean bl) {
        this.compress = bl;
    }

    public void produceSineWaveStream(WritableByteChannel writableByteChannel) {
        try {
            StreamProducer streamProducer = new StreamProducer(writableByteChannel);
            StreamDescriptor streamDescriptor = new StreamDescriptor();
            if (this.compress) {
                streamDescriptor.setCompression("deflate");
            }
            streamProducer.streamDescriptor(streamDescriptor);
            int n = 3600;
            StreamXDescriptor streamXDescriptor = new StreamXDescriptor();
            streamXDescriptor.setDataTransferType(DataTransferType.getByName("ascii24"));
            streamXDescriptor.setUnits(Units.seconds);
            streamXDescriptor.setBase(TimeUtil.createValid("2000-001"));
            StreamMultiYDescriptor streamMultiYDescriptor = new StreamMultiYDescriptor();
            streamMultiYDescriptor.setDataTransferType(DataTransferType.getByName("ascii10"));
            PacketDescriptor packetDescriptor = new PacketDescriptor();
            packetDescriptor.setXDescriptor(streamXDescriptor);
            packetDescriptor.addYDescriptor(streamMultiYDescriptor);
            streamProducer.packetDescriptor(packetDescriptor);
            double[] dArray = new double[1];
            DatumVector[] datumVectorArray = new DatumVector[1];
            int n2 = 0;
            while (n2 < n) {
                Datum datum = Datum.create((double)n2, Units.seconds);
                dArray[0] = Math.sin(Math.PI * this.frequency * (double)n2);
                datumVectorArray[0] = DatumVector.newDatumVector(dArray, Units.dimensionless);
                streamProducer.packet(packetDescriptor, datum, datumVectorArray);
                ++n2;
            }
            streamProducer.streamClosed(streamDescriptor);
        }
        catch (StreamException streamException) {
            streamException.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        List<String> list = Arrays.asList(stringArray);
        boolean bl = list.contains("-c");
        WritableByteChannel writableByteChannel = Channels.newChannel(System.out);
        SineWaveStream sineWaveStream = new SineWaveStream(bl);
        sineWaveStream.produceSineWaveStream(writableByteChannel);
    }
}

