/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.system;

import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.util.LinkedList;
import java.util.WeakHashMap;

public final class RequestProcessor {
    private static final BlockingRequestQueue queue = new BlockingRequestQueue();
    private static final WeakHashMap runnableQueueMap = new WeakHashMap();
    private static final Runner runner = new Runner();
    private static int maxThreadCount = 5;
    private static int threadCount = 0;
    private static final Object THREAD_COUNT_LOCK = new Object();
    private static int threadOrdinal = 0;

    private RequestProcessor() {
    }

    private static void newThread() {
        String string = "RequestProcessor[" + threadOrdinal++ + "]";
        new Thread((Runnable)runner, string).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable runnable) {
        Object object = THREAD_COUNT_LOCK;
        synchronized (object) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        queue.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(Runnable runnable, Object object) {
        Object object2 = THREAD_COUNT_LOCK;
        synchronized (object2) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        WeakHashMap weakHashMap = runnableQueueMap;
        synchronized (weakHashMap) {
            RunnableQueue runnableQueue = (RunnableQueue)runnableQueueMap.get(object);
            if (runnableQueue == null) {
                runnableQueue = new RunnableQueue();
                runnableQueueMap.put(object, runnableQueue);
            }
            runnableQueue.add(runnable, false);
            queue.add(runnableQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAfter(Runnable runnable, Object object) {
        Object object2 = THREAD_COUNT_LOCK;
        synchronized (object2) {
            if (threadCount < maxThreadCount) {
                RequestProcessor.newThread();
            }
        }
        WeakHashMap weakHashMap = runnableQueueMap;
        synchronized (weakHashMap) {
            RunnableQueue runnableQueue = (RunnableQueue)runnableQueueMap.get(object);
            if (runnableQueue == null) {
                runnableQueue = new RunnableQueue();
                runnableQueueMap.put(object, runnableQueue);
            }
            runnableQueue.add(runnable, true);
            queue.add(runnableQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(Object object) throws InterruptedException {
        WaitTask waitTask;
        WaitTask waitTask2 = waitTask = new WaitTask();
        synchronized (waitTask2) {
            RequestProcessor.invokeLater(waitTask, object);
            waitTask.wait();
            return;
        }
    }

    private static class BlockingRequestQueue {
        private LinkedList list = new LinkedList();

        BlockingRequestQueue() {
        }

        synchronized void add(Runnable runnable) {
            this.list.add(runnable);
            this.notify();
        }

        synchronized Runnable remove() {
            while (this.list.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return (Runnable)this.list.removeFirst();
        }
    }

    private static class RequestEntry {
        Runnable run;
        boolean async;

        private RequestEntry() {
        }
    }

    private static class RunnableQueue
    implements Runnable {
        private LinkedList list = new LinkedList();
        private int readCount = 0;
        private Object writer;

        private RunnableQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunnableQueue runnableQueue;
            Runnable runnable = null;
            RequestEntry requestEntry = null;
            while (runnable == null) {
                runnableQueue = this;
                synchronized (runnableQueue) {
                    requestEntry = (RequestEntry)this.list.removeFirst();
                    if (requestEntry.async && this.readCount == 0 && this.writer == null) {
                        this.writer = requestEntry;
                        runnable = requestEntry.run;
                    } else if (!requestEntry.async && this.writer == null) {
                        ++this.readCount;
                        runnable = requestEntry.run;
                    } else {
                        this.list.addFirst(requestEntry);
                    }
                }
            }
            runnable.run();
            runnableQueue = this;
            synchronized (runnableQueue) {
                if (requestEntry.async) {
                    this.writer = null;
                } else {
                    --this.readCount;
                }
                this.notifyAll();
            }
        }

        synchronized void add(Runnable runnable, boolean bl) {
            RequestEntry requestEntry = new RequestEntry();
            requestEntry.run = runnable;
            requestEntry.async = bl;
            this.list.add(requestEntry);
        }
    }

    private static class WaitTask
    implements Runnable {
        private WaitTask() {
        }

        public synchronized void run() {
            this.notifyAll();
        }
    }

    private static class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object = THREAD_COUNT_LOCK;
            synchronized (object) {
                threadCount++;
            }
            try {
                while (true) {
                    try {}
                    catch (Throwable throwable) {
                        DasExceptionHandler.handleUncaught(throwable);
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Object object2 = THREAD_COUNT_LOCK;
                synchronized (object2) {
                    threadCount--;
                    throw throwable;
                }
            }
            while (true) {
                Runnable runnable;
                if ((runnable = queue.remove()) != null) {
                    runnable.run();
                }
                Object object3 = THREAD_COUNT_LOCK;
                synchronized (object3) {
                    if (threadCount > maxThreadCount) {
                        break;
                    }
                }
            }
            Object var6_5 = null;
            Object object4 = THREAD_COUNT_LOCK;
            synchronized (object4) {
                threadCount--;
                return;
            }
        }
    }
}

