/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ArgumentList {
    int nposition;
    String programName;
    String[] positionKeys;
    HashMap values;
    HashMap descriptions;
    HashMap names;
    HashMap reverseNames;
    HashMap formUsed;
    HashMap abbrevs;
    HashMap isBoolean;
    private String UNSPECIFIED = new String("__unspecified__");
    private String REFERENCEWITHOUTVALUE = new String("__referencewithoutvalue__");
    private String UNDEFINED_SWITCH = new String("__undefinedSwitch__");
    private String FALSE = new String("__false__");
    private String TRUE = new String("__true__");

    public ArgumentList(String string) {
        this.programName = string;
        this.positionKeys = new String[10];
        this.values = new HashMap();
        this.descriptions = new HashMap();
        this.names = new HashMap();
        this.reverseNames = new HashMap();
        this.abbrevs = new HashMap();
        this.formUsed = new HashMap();
    }

    public String getValue(String string) {
        if (this.values.containsKey(string)) {
            return (String)this.values.get(string);
        }
        throw new IllegalArgumentException("No such key: " + string);
    }

    public boolean getBooleanValue(String string) {
        return this.values.get(string) == this.TRUE;
    }

    public void addPositionArgument(int n, String string, String string2) {
        if (n > this.nposition) {
            throw new IllegalArgumentException("Position arguments must be specified 0,1,2,3: position=" + n);
        }
        if (n > this.positionKeys.length) {
            throw new IllegalArgumentException("Position too big: position=" + n);
        }
        this.nposition = n + 1;
        this.positionKeys[n] = string;
        this.descriptions.put(string, string2);
        this.values.put(string, this.UNSPECIFIED);
    }

    public void addOptionalPositionArgument(int n, String string, String string2, String string3) {
        this.addPositionArgument(n, string, string3);
        this.values.put(string, string2);
    }

    public void addSwitchArgument(String string, String string2, String string3, String string4) {
        if (string2 != null && string2.length() > 1) {
            throw new IllegalArgumentException("abbrev can only be one character for " + string3 + ": " + string2);
        }
        if (string2 == null && string == null) {
            throw new IllegalArgumentException("both abbrev and name are null, one must be specified");
        }
        this.descriptions.put(string3, string4);
        if (string2 != null) {
            this.abbrevs.put(string2, string3);
        }
        if (string != null) {
            this.names.put(string, string3);
            this.reverseNames.put(string3, string);
        }
        this.values.put(string3, this.UNSPECIFIED);
    }

    public void addOptionalSwitchArgument(String string, String string2, String string3, String string4, String string5) {
        this.addSwitchArgument(string, string2, string3, string5);
        this.values.put(string3, string4);
    }

    public void addBooleanSwitchArgument(String string, String string2, String string3, String string4) {
        this.addOptionalSwitchArgument(string, string2, string3, this.FALSE, string4);
    }

    public void printUsage() {
        Object v;
        Object v2;
        Object object;
        Object object2;
        String string = "Usage: " + this.programName + " ";
        int n = 0;
        while (n < this.nposition) {
            object2 = this.positionKeys[n];
            string = this.values.get(object2) != this.UNSPECIFIED ? string + "[" + this.descriptions.get(object2) + "] " : string + "<" + this.descriptions.get(object2) + "> ";
            ++n;
        }
        System.err.println(string);
        object2 = this.names.keySet();
        Iterator<Object> iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            v2 = this.names.get(object);
            string = "  ";
            v = this.descriptions.get(v2);
            string = this.values.get(v2) != this.UNSPECIFIED ? (this.values.get(v2) == this.FALSE || this.values.get(v2) == this.TRUE ? string + "--" + object + "   " + v : string + "--" + object + "=" + v + " ") : string + "--" + object + "=" + v + " (required)";
            System.err.println(string);
        }
        object2 = this.abbrevs.keySet();
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            v2 = this.abbrevs.get(object);
            string = "  ";
            v = this.descriptions.get(v2);
            string = this.values.get(v2) != this.UNSPECIFIED ? (this.values.get(v2) == this.FALSE || this.values.get(v2) == this.TRUE ? string + "-" + object + "   \t" + v : string + "-" + object + "=" + v + " ") : string + "-" + object + "=" + v + " (required)";
            System.err.println(string);
        }
    }

    private void checkArgs() {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.nposition) {
            if (this.values.get(this.positionKeys[n]) == this.UNSPECIFIED) {
                arrayList.add("Expected more positional arguments, only got " + n);
                bl = true;
            }
            ++n;
        }
        Iterator iterator = this.values.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k.equals("help")) {
                this.printUsage();
                System.exit(-1);
            }
            if (this.values.get(k) == this.UNSPECIFIED) {
                arrayList.add("Argument needed: --" + this.reverseNames.get(k));
            }
            if (this.values.get(k) == this.REFERENCEWITHOUTVALUE) {
                arrayList.add("Switch requires argument: " + this.formUsed.get(k));
            }
            if (this.values.get(k) != this.UNDEFINED_SWITCH) continue;
            arrayList.add("Not a valid switch: " + this.formUsed.get(k));
        }
        if (arrayList.size() > 0) {
            this.printUsage();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                System.err.println(arrayList.get(n2));
                ++n2;
            }
            System.exit(-1);
        }
    }

    public void process(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string;
            if (stringArray[n2].startsWith("-")) {
                String string2;
                if (stringArray[n2].startsWith("--")) {
                    string2 = stringArray[n2].substring(2);
                    if (string2.indexOf(61) != -1) {
                        string2 = string2.substring(0, string2.indexOf(61));
                    }
                    string = (String)this.names.get(string2);
                } else {
                    string2 = stringArray[n2].substring(1);
                    if (string2.indexOf(61) != -1) {
                        string2 = string2.substring(0, string2.indexOf(61));
                    }
                    string = (String)this.abbrevs.get(string2);
                }
                if (string == null) {
                    string = stringArray[n2];
                    this.values.put(string, this.UNDEFINED_SWITCH);
                    this.formUsed.put(string, stringArray[n2]);
                } else {
                    this.formUsed.put(string, stringArray[n2]);
                    if (this.values.get(string) == this.FALSE || this.values.get(string) == this.TRUE) {
                        this.values.put(string, this.TRUE);
                    } else {
                        String string3;
                        if (stringArray[n2].indexOf(61) != -1) {
                            string3 = stringArray[n2].substring(stringArray[n2].indexOf(61) + 1);
                        } else if (n2 + 1 < stringArray.length && !stringArray[n2 + 1].startsWith("-")) {
                            string3 = stringArray[n2 + 1];
                            ++n2;
                        } else {
                            string3 = this.REFERENCEWITHOUTVALUE;
                        }
                        this.values.put(string, string3);
                    }
                }
            } else {
                string = this.positionKeys[n];
                this.values.put(string, stringArray[n2]);
                ++n;
                this.formUsed.put(string, stringArray[n2]);
            }
            ++n2;
        }
        this.checkArgs();
    }
}

