/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

public final class DasExceptionHandler {
    private static final String UNCAUGHT = "An unexpected error has occurred.  The system may not be able to recover properly.  Please report this error to the Das2 bug database at http://bugs-pw.physics.uiowa.edu/.  Please include all error information and a description of how you encountered the error.  For your convenience, you may click the \"Show Details\" button then click the \"Save to file\" button to save all the relevant error messages to a file.\n";

    private DasExceptionHandler() {
    }

    public static void handle(Throwable throwable) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            DasDie.println(DasDie.CRITICAL, throwable.toString());
        } else {
            DasExceptionHandler.showExceptionDialog(throwable, "");
        }
    }

    public static void handleUncaught(Throwable throwable) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            throwable.printStackTrace();
        } else {
            DasExceptionHandler.showExceptionDialog(throwable, UNCAUGHT);
        }
    }

    private static void showExceptionDialog(Throwable throwable, String string) {
        String string2 = string + throwable.getClass().getName() + "\n" + (throwable.getMessage() == null ? "" : throwable.getMessage());
        final JDialog jDialog = new JDialog();
        jDialog.setTitle("Error");
        jDialog.setModal(false);
        jDialog.setResizable(false);
        jDialog.setDefaultCloseOperation(2);
        JTextArea jTextArea = new JTextArea(10, 40);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setText(string2);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("Ok");
        final JToggleButton jToggleButton = new JToggleButton("Show Details");
        jPanel2.add(jButton);
        jPanel2.add(jToggleButton);
        jPanel.add((Component)jPanel2, "South");
        jDialog.getContentPane().add((Component)jPanel, "Center");
        final JTextArea jTextArea2 = new JTextArea(10, 40);
        jTextArea2.setLineWrap(false);
        jTextArea2.setEditable(false);
        jTextArea2.setTabSize(4);
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        jTextArea2.setText(stringWriter.toString());
        final JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JScrollPane(jTextArea2), "North");
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        jPanel4.setBorder(new EmptyBorder(10, 0, 0, 0));
        JButton jButton2 = new JButton("Dump to STDERR");
        jPanel4.add(jButton2);
        jPanel3.add((Component)jButton2, "South");
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = jPanel3.getPreferredSize().width;
        jScrollPane.setPreferredSize(dimension);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jToggleButton.isSelected()) {
                    jToggleButton.setText("Less Details");
                    jDialog.getContentPane().add((Component)jPanel3, "South");
                    jDialog.pack();
                } else {
                    jToggleButton.setText("More Details");
                    jDialog.getContentPane().remove(jPanel3);
                    jDialog.pack();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextArea2.getText();
                System.err.print(string);
            }
        });
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }
}

