/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.util.DasPNGConstants;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class DasPNGEncoder
extends DasPNGConstants {
    public void addText(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)this.textMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.textMap.put(string, arrayList);
        }
        arrayList.add(string2);
    }

    public void removeText(String string, String string2) {
        List list = (List)this.textMap.get(string);
        if (list != null) {
            list.remove(string2);
        }
    }

    public void removeAllText(String string) {
        this.textMap.remove(string);
    }

    public void setGamma(int n) {
        this.gamma = n;
    }

    public void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n = 0;
        linkedList.add(this.getHeaderBytes());
        linkedList.add(this.getIHDRBytes(bufferedImage));
        this.gettEXtBytes(linkedList);
        linkedList.add(this.getgAMABytes());
        linkedList.add(this.getPLTEBytes(bufferedImage));
        linkedList.add(this.getIDATBytes(bufferedImage));
        linkedList.add(this.getIENDBytes());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            n += ((byte[])iterator.next()).length;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            byteBuffer.put((byte[])iterator.next());
        }
        outputStream.write(byteBuffer.array());
    }

    private byte[] getHeaderBytes() {
        return new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    }

    private byte[] getIHDRBytes(BufferedImage bufferedImage) {
        byte by;
        byte by2;
        int n = bufferedImage.getType();
        switch (n) {
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                by2 = 8;
                by = 2;
                break;
            }
            case 2: 
            case 6: {
                by2 = 8;
                by = 6;
                break;
            }
            case 13: {
                by2 = 8;
                by = 3;
                break;
            }
            case 10: {
                by2 = 8;
                by = 0;
                break;
            }
            case 11: {
                by2 = 16;
                by = 0;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported image type");
            }
        }
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte[] byArray = new byte[25];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(13);
        byteBuffer.put(DasPNGConstants.getISO8859_1Bytes("IHDR"));
        byteBuffer.putInt(bufferedImage.getWidth());
        byteBuffer.putInt(bufferedImage.getHeight());
        byteBuffer.put(by2);
        byteBuffer.put(by);
        byteBuffer.put(by3);
        byteBuffer.put(by4);
        byteBuffer.put(by5);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 4, 17);
        byteBuffer.putInt((int)cRC32.getValue());
        return byArray;
    }

    private byte[] getgAMABytes() {
        byte[] byArray = new byte[16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(4);
        byteBuffer.put(DasPNGConstants.getISO8859_1Bytes("gAMA"));
        byteBuffer.putInt(this.gamma);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 4, 8);
        byteBuffer.putInt((int)cRC32.getValue());
        return byArray;
    }

    private byte[] getPLTEBytes(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 13) {
            return new byte[0];
        }
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        int n = indexColorModel.getMapSize();
        throw new UnsupportedOperationException();
    }

    private byte[] getIDATBytes(BufferedImage bufferedImage) {
        byte[] byArray;
        int n = bufferedImage.getType();
        switch (n) {
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                byArray = this.getRGBBytes(bufferedImage);
                break;
            }
            case 6: {
                byArray = this.getABGRBytes(bufferedImage);
                break;
            }
            case 2: {
                byArray = this.getARGBBytes(bufferedImage);
                break;
            }
            case 10: 
            case 13: {
                byArray = this.get8BitSampleBytes(bufferedImage);
                break;
            }
            case 11: {
                byArray = this.get16BitSampleBytes(bufferedImage);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported image type");
            }
        }
        byte[] byArray2 = new byte[byArray.length];
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        int n2 = deflater.deflate(byArray2);
        byte[] byArray3 = new byte[n2 + 12];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        byteBuffer.putInt(n2);
        byteBuffer.put(DasPNGConstants.getISO8859_1Bytes("IDAT"));
        byteBuffer.put(byArray2, 0, n2);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray3, 4, n2 + 4);
        byteBuffer.putInt((int)cRC32.getValue());
        return byArray3;
    }

    private byte[] getRGBBytes(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        byte[] byArray = new byte[nArray.length * 3 + n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n * 3 + 1) * n3;
            byArray[n4] = 0;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n3 * n + n5;
                int n7 = n4 + (n5 * 3 + 1);
                byArray[n7] = (byte)((0xFF0000 & nArray[n6]) >> 16);
                byArray[n7 + 1] = (byte)((0xFF00 & nArray[n6]) >> 8);
                byArray[n7 + 2] = (byte)(0xFF & nArray[n6]);
                ++n5;
            }
            ++n3;
        }
        return byArray;
    }

    private byte[] getARGBBytes(BufferedImage bufferedImage) {
        throw new UnsupportedOperationException();
    }

    private byte[] getABGRBytes(BufferedImage bufferedImage) {
        throw new UnsupportedOperationException();
    }

    private byte[] get8BitSampleBytes(BufferedImage bufferedImage) {
        throw new UnsupportedOperationException();
    }

    private byte[] get16BitSampleBytes(BufferedImage bufferedImage) {
        throw new UnsupportedOperationException();
    }

    private byte[] getIENDBytes() {
        byte[] byArray = new byte[12];
        byte[] byArray2 = DasPNGConstants.getISO8859_1Bytes("IEND");
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(0);
        byteBuffer.put(byArray2);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray2);
        byteBuffer.putInt((int)cRC32.getValue());
        return byArray;
    }

    private void gettEXtBytes(List list) {
        Iterator iterator = this.textMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List list2 = (List)entry.getValue();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                list.add(this.gettEXtBytes((String)entry.getKey(), (String)iterator2.next()));
            }
        }
    }

    private byte[] gettEXtBytes(String string, String string2) {
        byte[] byArray = DasPNGConstants.getISO8859_1Bytes(string);
        byte[] byArray2 = DasPNGConstants.getISO8859_1Bytes(string2);
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 13];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        byteBuffer.putInt(byArray.length + byArray2.length + 1);
        byteBuffer.put(DasPNGConstants.getISO8859_1Bytes("tEXt"));
        byteBuffer.put(byArray);
        byteBuffer.put((byte)0);
        byteBuffer.put(byArray2);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray3, 4, byArray.length + byArray2.length + 5);
        byteBuffer.putInt((int)cRC32.getValue());
        return byArray3;
    }
}

