/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.IDLValue;
import java.util.StringTokenizer;
import java.util.Vector;

public class IDLParser {
    public static int EXPR = 1;
    public static int EXPR_LIST = 2;
    public static int FACTOR = 3;
    public static int TERM = 4;
    public static int NUMBER = 5;
    public static int NOPARSER = 6;

    public String[] IDLTokenizer(String string) {
        String string2 = " \t[,]()^*/+-";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (stringArray[n4].equals(" ") || stringArray[n4].equals("\t")) {
                stringArray[n4] = null;
                ++n3;
            } else if ((stringArray[n4].endsWith("e") || stringArray[n4].endsWith("E")) && stringArray[n4 + 1].endsWith("-")) {
                stringArray[n4] = stringArray[n4] + stringArray[n4 + 1] + stringArray[n4 + 2];
                stringArray[n4 + 1] = null;
                stringArray[n4 + 2] = null;
                n4 += 2;
                n3 += 2;
            }
            ++n4;
        }
        if (n3 > 0) {
            String[] stringArray2 = new String[stringArray.length - n3];
            int n5 = 0;
            int n6 = 0;
            while (n6 < stringArray.length) {
                if (stringArray[n6] != null) {
                    stringArray2[n5] = stringArray[n6];
                    ++n5;
                }
                ++n6;
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public double parseIDLScalar(String string) {
        String[] stringArray = this.IDLTokenizer(string);
        IDLValue iDLValue = this.parseIDLArrayTokens(stringArray, EXPR);
        if (iDLValue == null) {
            return Double.NaN;
        }
        return iDLValue.toScalar();
    }

    public double[] parseIDLArray(String string) {
        String[] stringArray = this.IDLTokenizer(string);
        IDLValue iDLValue = this.parseIDLArrayTokens(stringArray, EXPR);
        if (iDLValue == null) {
            return null;
        }
        return iDLValue.toArray();
    }

    private IDLValue parseIDLExprList(String[] stringArray) {
        String[] stringArray2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Vector<IDLValue> vector = new Vector<IDLValue>();
        n = 1;
        int n4 = 1;
        while (n4 < stringArray.length) {
            if (stringArray[n4].equals(",") && n2 == 0 || stringArray[n4].equals("]") && n2 == 0) {
                n3 = n4 - 1;
                stringArray2 = new String[n3 - n + 1];
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    stringArray2[n5] = stringArray[n5 + n];
                    ++n5;
                }
                IDLValue iDLValue = this.parseIDLArrayTokens(stringArray2, EXPR);
                vector.add(iDLValue);
                n = n4 + 1;
            } else if (stringArray[n4].equals("(")) {
                ++n2;
            } else if (stringArray[n4].equals(")")) {
                --n2;
            } else if (stringArray[n4].equals("[")) {
                ++n2;
            } else if (stringArray[n4].equals("]")) {
                --n2;
            }
            ++n4;
        }
        stringArray2 = new IDLValue();
        stringArray2.type = IDLValue.ARRAY;
        Vector<Double> vector2 = new Vector<Double>();
        int n6 = 0;
        while (n6 < vector.size()) {
            IDLValue iDLValue = (IDLValue)vector.get(n6);
            if (iDLValue.type == IDLValue.SCALAR) {
                vector2.add(new Double(iDLValue.sValue));
            } else {
                int n7 = 0;
                while (n7 < iDLValue.aValue.length) {
                    vector2.add(new Double(iDLValue.aValue[n7]));
                    ++n7;
                }
            }
            ++n6;
        }
        stringArray2.aValue = new double[vector2.size()];
        int n8 = 0;
        while (n8 < vector2.size()) {
            stringArray2.aValue[n8] = (Double)vector2.get(n8);
            ++n8;
        }
        return stringArray2;
    }

    public IDLValue parseIDLArrayTokens(String[] stringArray, int n) {
        int n2;
        IDLValue iDLValue = null;
        IDLValue iDLValue2 = null;
        if (stringArray.length == 0) {
            return null;
        }
        if (stringArray.length == 1) {
            iDLValue = new IDLValue(Double.parseDouble(stringArray[0]));
            return iDLValue;
        }
        String[] stringArray2 = null;
        if (n == EXPR) {
            stringArray2 = new String[]{"+", "-"};
            n2 = TERM;
        } else if (n == TERM) {
            stringArray2 = new String[]{"*", "/"};
            n2 = FACTOR;
        } else if (n == FACTOR) {
            stringArray2 = new String[]{"^"};
            n2 = NUMBER;
            if (stringArray[0].equals("-")) {
                String[] stringArray3 = new String[stringArray.length - 1];
                int n3 = 0;
                while (n3 < stringArray3.length) {
                    stringArray3[n3] = stringArray[n3 + 1];
                    ++n3;
                }
                iDLValue = this.parseIDLArrayTokens(stringArray3, FACTOR);
                iDLValue2 = iDLValue.IDLmultiply(new IDLValue(-1.0));
                return iDLValue2;
            }
        } else {
            int n4 = NOPARSER;
            if (stringArray[0].equals("(") && stringArray[stringArray.length - 1].equals(")")) {
                int n5 = 1;
                int n6 = stringArray.length - 2;
                String[] stringArray4 = new String[n6 - n5 + 1];
                int n7 = 0;
                while (n7 < stringArray4.length) {
                    stringArray4[n7] = stringArray[n7 + n5];
                    ++n7;
                }
                iDLValue = this.parseIDLArrayTokens(stringArray4, EXPR);
                return iDLValue;
            }
            if (stringArray[0].equals("[") && stringArray[stringArray.length - 1].equals("]")) {
                iDLValue = this.parseIDLExprList(stringArray);
                return iDLValue;
            }
            if (stringArray[0].equalsIgnoreCase("findgen") || stringArray[0].equalsIgnoreCase("dindgen")) {
                String[] stringArray5 = new String[stringArray.length - 3];
                int n8 = 0;
                while (n8 < stringArray5.length) {
                    stringArray5[n8] = stringArray[n8 + 2];
                    ++n8;
                }
                iDLValue = this.parseIDLArrayTokens(stringArray5, EXPR);
                if (iDLValue.type != IDLValue.SCALAR) {
                    DasDie.println("Syntax error in findgen argument");
                    System.exit(-1);
                } else {
                    iDLValue = IDLValue.findgen((int)iDLValue.sValue);
                }
            } else if (stringArray[0].equalsIgnoreCase("alog10")) {
                String[] stringArray6 = new String[stringArray.length - 3];
                int n9 = 0;
                while (n9 < stringArray6.length) {
                    stringArray6[n9] = stringArray[n9 + 2];
                    ++n9;
                }
                iDLValue = this.parseIDLArrayTokens(stringArray6, EXPR);
                iDLValue = IDLValue.alog10(iDLValue);
            } else {
                return null;
            }
            return iDLValue;
        }
        int n10 = 9999;
        String string = "";
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n13 < stringArray2.length) {
            int n14 = 0;
            while (n14 < stringArray.length) {
                if (stringArray[n14].equals("[")) {
                    ++n12;
                }
                if (stringArray[n14].equals("(")) {
                    ++n11;
                }
                if (stringArray[n14].equals("]")) {
                    --n12;
                }
                if (stringArray[n14].equals(")")) {
                    --n11;
                }
                if (stringArray[n14].equals(stringArray2[n13]) && n14 != 0 && n13 < n10 && n11 == 0 && n12 == 0) {
                    n10 = n14;
                    string = stringArray2[n13];
                }
                ++n14;
            }
            ++n13;
        }
        if (n10 == 9999) {
            iDLValue2 = this.parseIDLArrayTokens(stringArray, n2);
        } else {
            String[] stringArray7 = new String[n10];
            int n15 = 0;
            while (n15 < n10) {
                stringArray7[n15] = stringArray[n15];
                ++n15;
            }
            iDLValue = this.parseIDLArrayTokens(stringArray7, n2);
            stringArray7 = new String[stringArray.length - n10 - 1];
            int n16 = 0;
            while (n16 < stringArray7.length) {
                stringArray7[n16] = stringArray[n16 + n10 + 1];
                ++n16;
            }
            IDLValue iDLValue3 = this.parseIDLArrayTokens(stringArray7, n);
            if (iDLValue == null || iDLValue3 == null) {
                iDLValue2 = n2 == NOPARSER ? null : this.parseIDLArrayTokens(stringArray, n2);
            } else if (string.equals("+")) {
                iDLValue2 = iDLValue.IDLadd(iDLValue3);
            } else if (string.equals("-")) {
                iDLValue2 = iDLValue.IDLsubtract(iDLValue3);
            } else if (string.equals("*")) {
                iDLValue2 = iDLValue.IDLmultiply(iDLValue3);
            } else if (string.equals("/")) {
                iDLValue2 = iDLValue.IDLdivide(iDLValue3);
            } else if (string.equals("^")) {
                iDLValue2 = iDLValue.IDLexponeniate(iDLValue3);
            }
        }
        return iDLValue2;
    }

    public static void main(String[] stringArray) {
        IDLParser iDLParser = new IDLParser();
        String string = "( findgen(152)/151 * 6.01145  )";
        double[] dArray = iDLParser.parseIDLArray(string);
        System.out.println("Note the parser gets this wrong:");
        string = "10^(findgen(320)/319.0*4.47966+1.42765)";
        dArray = iDLParser.parseIDLArray(string);
        System.out.println("first d= " + dArray[0] + " last d=" + dArray[dArray.length - 1]);
        string = "10^((findgen(320)/319.0)*4.47966+1.42765)";
        dArray = iDLParser.parseIDLArray(string);
        System.out.println("first d= " + dArray[0] + " last d=" + dArray[dArray.length - 1]);
    }
}

