/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.PropertyType;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.util.ByteBufferInputStream;
import edu.uiowa.physics.pw.das.util.InflaterChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StreamTool {
    public static byte[] advanceTo(InputStream inputStream, byte[] byArray) throws IOException, DelimeterNotFoundException {
        byte[] byArray2 = new byte[4096];
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = true;
        int n3 = -99999;
        int n4 = -99999;
        int n5 = 0;
        int n6 = 0;
        while (bl3) {
            int n7 = inputStream.read();
            ++n5;
            if (n7 == -1) {
                bl3 = false;
            } else {
                byArray2[n6] = (byte)n7;
                n = byArray[n] == n7 ? ++n : 0;
                if (n == byArray.length) {
                    bl3 = false;
                    n2 = n5 - byArray.length;
                }
            }
            if (!bl3 || ++n6 != 4096) continue;
            arrayList.add(byArray2);
            n6 = 0;
            byArray2 = new byte[4096];
        }
        if (n != byArray.length) {
            throw new DelimeterNotFoundException();
        }
        byte[] byArray3 = new byte[n2];
        int n8 = 0;
        while (n8 < arrayList.size()) {
            System.arraycopy(arrayList.get(n8), 0, byArray3, n8 * 4096, 4096);
            ++n8;
        }
        System.arraycopy(byArray2, 0, byArray3, arrayList.size() * 4096, n2 - arrayList.size() * 4096);
        return byArray3;
    }

    public static byte[] readXML(PushbackInputStream pushbackInputStream) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(pushbackInputStream);
        byte[] byArray = new byte[4096];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        readableByteChannel.read(byteBuffer);
        byteBuffer.flip();
        ByteBuffer byteBuffer2 = StreamTool.readXML(byteBuffer);
        byte[] byArray2 = new byte[byteBuffer2.remaining()];
        byteBuffer2.get(byArray2);
        return byArray2;
    }

    private static void eatWhiteSpace(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            char c = (char)(0xFF & byteBuffer.get());
            if (Character.isWhitespace(c)) continue;
            byteBuffer.position(byteBuffer.position() - 1);
            return;
        }
    }

    public static ByteBuffer readXML(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.mark();
        StreamTool.eatWhiteSpace(byteBuffer2);
        int n3 = 0xFF & byteBuffer2.get();
        if ((char)n3 != '<') {
            throw new IOException("found '" + (char)n3 + "', expected '<' at offset=" + byteBuffer2.position() + ".\n");
        }
        ++n;
        bl4 = false;
        while (byteBuffer2.hasRemaining() && (n > 0 || n2 > 0)) {
            char c = (char)n3;
            n3 = 0xFF & byteBuffer2.get();
            if (bl2 && (char)n3 == '\"' && c != '\\') {
                bl2 = false;
                continue;
            }
            if ((char)n3 == '<') {
                ++n;
                bl3 = true;
                bl4 = false;
                continue;
            }
            if (n3 == 62) {
                --n;
                bl3 = false;
                if (c == '/') continue;
                if (bl4) {
                    --n2;
                    continue;
                }
                ++n2;
                continue;
            }
            if (n3 == 47) {
                if (c != '<') continue;
                bl4 = true;
                continue;
            }
            if ((char)n3 != '\"' || !bl3) continue;
            bl2 = true;
        }
        if (n3 == -1) {
            throw new IOException("unexpected end of file before xml termination\n");
        }
        StreamTool.eatWhiteSpace(byteBuffer2);
        int n4 = byteBuffer2.limit();
        byteBuffer2.limit(byteBuffer2.position());
        byteBuffer2.reset();
        ByteBuffer byteBuffer3 = byteBuffer2.slice();
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer2.limit(n4);
        return byteBuffer3;
    }

    public static void readStream(ReadableByteChannel readableByteChannel, StreamHandler streamHandler) throws StreamException {
        ReadStreamStructure readStreamStructure = new ReadStreamStructure(readableByteChannel, streamHandler);
        try {
            StreamDescriptor streamDescriptor = StreamTool.getStreamDescriptor(readStreamStructure);
            if ("deflate".equals(streamDescriptor.getCompression())) {
                readableByteChannel = StreamTool.getInflaterChannel(readableByteChannel);
            }
            streamHandler.streamDescriptor(streamDescriptor);
            while (readableByteChannel.read(readStreamStructure.bigBuffer) != -1) {
                readStreamStructure.bigBuffer.flip();
                while (StreamTool.getChunk(readStreamStructure)) {
                }
                readStreamStructure.bigBuffer.compact();
            }
            streamHandler.streamClosed(streamDescriptor);
        }
        catch (StreamException streamException) {
            streamHandler.streamException(streamException);
            throw streamException;
        }
        catch (IOException iOException) {
            StreamException streamException = new StreamException(iOException);
            streamHandler.streamException(streamException);
            throw streamException;
        }
    }

    private static StreamDescriptor getStreamDescriptor(ReadStreamStructure readStreamStructure) throws StreamException, IOException {
        readStreamStructure.bigBuffer.clear().limit(10);
        while (readStreamStructure.bigBuffer.hasRemaining() && readStreamStructure.stream.read(readStreamStructure.bigBuffer) != -1) {
        }
        if (readStreamStructure.bigBuffer.hasRemaining()) {
            throw new StreamException("Reached end of stream before encountering stream descriptor");
        }
        readStreamStructure.bigBuffer.flip();
        readStreamStructure.bigBuffer.get(readStreamStructure.four);
        if (StreamTool.isStreamDescriptorHeader(readStreamStructure.four)) {
            int n = StreamTool.getContentLength(readStreamStructure.bigBuffer);
            readStreamStructure.bigBuffer.clear().limit(n);
            while (readStreamStructure.bigBuffer.hasRemaining() && readStreamStructure.stream.read(readStreamStructure.bigBuffer) != -1) {
            }
            if (readStreamStructure.bigBuffer.hasRemaining()) {
                throw new StreamException("Reached end of stream before encountering stream descriptor");
            }
            readStreamStructure.bigBuffer.flip();
            Document document = StreamTool.getXMLDocument(readStreamStructure.bigBuffer, n);
            Element element = document.getDocumentElement();
            if (element.getTagName().equals("stream")) {
                StreamDescriptor streamDescriptor = new StreamDescriptor(document.getDocumentElement());
                readStreamStructure.bigBuffer.clear();
                return streamDescriptor;
            }
            if (element.getTagName().equals("exception")) {
                throw StreamTool.exception(element);
            }
            throw new StreamException("Unexpected xml header, expecting stream or exception, received: " + element.getTagName());
        }
        throw new StreamException("Expecting stream descriptor header, found: '" + StreamTool.asciiBytesToString(readStreamStructure.four, 0, 4) + "'");
    }

    private static final StreamException exception(Element element) {
        String string = element.getAttribute("type");
        return new StreamException(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean getChunk(ReadStreamStructure readStreamStructure) throws StreamException, IOException {
        readStreamStructure.bigBuffer.mark();
        if (readStreamStructure.bigBuffer.remaining() < 4) {
            return false;
        }
        readStreamStructure.bigBuffer.get(readStreamStructure.four);
        if (StreamTool.isPacketDescriptorHeader(readStreamStructure.four)) {
            if (readStreamStructure.bigBuffer.remaining() < 6) {
                readStreamStructure.bigBuffer.reset();
                return false;
            }
            int n = StreamTool.getContentLength(readStreamStructure.bigBuffer);
            if (readStreamStructure.bigBuffer.capacity() < n) {
                readStreamStructure.bigBuffer.reset();
                ByteBuffer byteBuffer = ByteBuffer.allocate(8 + n + n / 10);
                byteBuffer.put(readStreamStructure.bigBuffer);
                byteBuffer.flip();
                readStreamStructure.bigBuffer = byteBuffer;
                return false;
            }
            if (readStreamStructure.bigBuffer.remaining() < n) {
                readStreamStructure.bigBuffer.reset();
                return false;
            }
            Document document = StreamTool.getXMLDocument(readStreamStructure.bigBuffer, n);
            Element element = document.getDocumentElement();
            if (element.getTagName().equals("packet")) {
                PacketDescriptor packetDescriptor = new PacketDescriptor(document.getDocumentElement());
                readStreamStructure.handler.packetDescriptor(packetDescriptor);
                readStreamStructure.descriptors.put(StreamTool.asciiBytesToString(readStreamStructure.four, 1, 2), packetDescriptor);
                return true;
            }
            if (!element.getTagName().equals("exception")) throw new StreamException("Unexpected xml header, expecting stream or exception, received: " + element.getTagName());
            throw StreamTool.exception(element);
        }
        if (!StreamTool.isPacketHeader(readStreamStructure.four)) throw new StreamException("Expected four byte header, found '" + new String(readStreamStructure.four) + "'");
        String string = StreamTool.asciiBytesToString(readStreamStructure.four, 1, 2);
        PacketDescriptor packetDescriptor = (PacketDescriptor)readStreamStructure.descriptors.get(string);
        int n = packetDescriptor.getSizeBytes();
        if (readStreamStructure.bigBuffer.remaining() < n) {
            readStreamStructure.bigBuffer.reset();
            return false;
        }
        int n2 = packetDescriptor.getYCount();
        Datum datum = packetDescriptor.getXDescriptor().readDatum(readStreamStructure.bigBuffer);
        DatumVector[] datumVectorArray = new DatumVector[n2];
        int n3 = 0;
        while (n3 < n2) {
            datumVectorArray[n3] = packetDescriptor.getYDescriptor(n3).read(readStreamStructure.bigBuffer);
            ++n3;
        }
        readStreamStructure.handler.packet(packetDescriptor, datum, datumVectorArray);
        return true;
    }

    private static ByteBuffer sliceBuffer(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.limit(byteBuffer2.position() + n);
        return byteBuffer2.slice();
    }

    private static String asciiBytesToString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static boolean isStreamDescriptorHeader(byte[] byArray) {
        return byArray[0] == 91 && byArray[1] == 48 && byArray[2] == 48 && byArray[3] == 93;
    }

    private static boolean isPacketDescriptorHeader(byte[] byArray) {
        return byArray[0] == 91 && byArray[3] == 93 && Character.isDigit((char)byArray[1]) && Character.isDigit((char)byArray[2]);
    }

    private static boolean isPacketHeader(byte[] byArray) {
        return byArray[0] == 58 && byArray[3] == 58 && Character.isDigit((char)byArray[1]) && Character.isDigit((char)byArray[2]);
    }

    private static Document getXMLDocument(ByteBuffer byteBuffer, int n) throws StreamException, IOException {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.limit(byteBuffer2.position() + n);
        byteBuffer.position(byteBuffer.position() + n);
        ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(byteBuffer2);
        InputStreamReader inputStreamReader = new InputStreamReader(byteBufferInputStream);
        return StreamTool.parseHeader(inputStreamReader);
    }

    private static int getContentLength(ByteBuffer byteBuffer) throws StreamException {
        int n = 0;
        int n2 = 0;
        while (n2 < 6) {
            char c = (char)(0xFF & byteBuffer.get());
            if (c != ' ') {
                if (!Character.isDigit(c)) {
                    throw new StreamException("Invalid character in contentLength: '" + c + "'");
                }
                int n3 = Character.digit(c, 10);
                n = n * 10 + n3;
            }
            ++n2;
        }
        return n;
    }

    public static Document parseHeader(Reader reader) throws StreamException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(reader);
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new StreamException(sAXException);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public static void formatHeader(Document document, Writer writer) throws StreamException {
        try {
            OutputFormat outputFormat = new OutputFormat("xml", "US-ASCII", true);
            XMLSerializer xMLSerializer = new XMLSerializer(writer, outputFormat);
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            throw new StreamException(iOException);
        }
    }

    public static Map processPropertiesElement(Element element) throws StreamException {
        try {
            if (!element.getTagName().equals("properties")) {
                throw new StreamException("expecting 'properties' element, encountered '" + element.getTagName() + "'");
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string = attr.getName();
                String[] stringArray = string.split(":");
                if (stringArray.length == 1) {
                    hashMap.put(string, attr.getValue());
                } else if (stringArray.length == 2) {
                    PropertyType propertyType = PropertyType.getByName(stringArray[0]);
                    Object object = propertyType.parse(attr.getValue());
                    hashMap.put(stringArray[1], object);
                } else {
                    throw new IllegalArgumentException("Invalid typed name: " + string);
                }
                ++n;
            }
            return hashMap;
        }
        catch (ParseException parseException) {
            StreamException streamException = new StreamException(parseException.getMessage());
            streamException.initCause(parseException);
            throw streamException;
        }
    }

    private static ReadableByteChannel getInflaterChannel(ReadableByteChannel readableByteChannel) throws IOException {
        return new InflaterChannel(readableByteChannel);
    }

    private static class ReadStreamStructure {
        private ReadableByteChannel stream;
        private ByteBuffer bigBuffer = ByteBuffer.allocate(4096);
        private byte[] four = new byte[4];
        private StreamHandler handler;
        private Map descriptors = new HashMap();

        private ReadStreamStructure(ReadableByteChannel readableByteChannel, StreamHandler streamHandler) {
            this.stream = readableByteChannel;
            this.handler = streamHandler;
        }
    }

    public static class DelimeterNotFoundException
    extends Exception {
    }
}

