/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.HttpFileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.LocalFileSystem;
import java.io.IOException;
import java.net.URL;

public abstract class FileSystem {
    public static FileSystem create(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            return new LocalFileSystem(uRL);
        }
        if ("http".equals(uRL.getProtocol())) {
            return HttpFileSystem.createHttpFileSystem(uRL);
        }
        throw new IllegalArgumentException("unsupported protocol: " + uRL);
    }

    public static String getRegexFromGlob(String string) {
        String string2 = string.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.");
        return string2;
    }

    protected void handleException(Exception exception) {
        DasExceptionHandler.handle(exception);
    }

    protected static String toCanonicalFilename(String string) {
        if ((string = string.replaceAll("\\\\", "/")).length() == 0 || string.charAt(0) != '/') {
            string = "/" + string;
        }
        return string;
    }

    public abstract FileObject getFile(String var1);

    public abstract boolean isDirectory(String var1);

    public abstract String[] listDirectory(String var1);

    public abstract String[] listDirectory(String var1, String var2);
}

