/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.HtmlUtil;
import edu.uiowa.physics.pw.das.util.fileSystem.HttpFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class HttpFileObject
implements FileObject {
    HttpFileSystem wfs;
    String pathname;
    File localFile;
    Date modifiedDate;
    boolean isRoot;
    boolean isFolder;

    public boolean canRead() {
        return true;
    }

    public FileObject[] getChildren() {
        if (!this.isFolder) {
            throw new IllegalArgumentException(this.toString() + "is not a folder");
        }
        try {
            URL[] uRLArray = HtmlUtil.getDirectoryListing(new URL(this.wfs.getRoot().toString() + this.pathname));
            FileObject[] fileObjectArray = new FileObject[uRLArray.length];
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                String string = this.wfs.getLocalName(uRL);
                fileObjectArray[n] = new HttpFileObject(this.wfs, string, new Date(System.currentTimeMillis()));
                ++n;
            }
            return fileObjectArray;
        }
        catch (MalformedURLException malformedURLException) {
            this.wfs.handleException(malformedURLException);
            return new FileObject[0];
        }
        catch (IOException iOException) {
            this.wfs.handleException(iOException);
            return new FileObject[0];
        }
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (!this.localFile.exists()) {
            try {
                this.wfs.transferFile(this.pathname, this.localFile);
            }
            catch (IOException iOException) {
                this.wfs.handleException(iOException);
            }
        }
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        return new HttpFileObject(this.wfs, this.wfs.getLocalName(this.localFile.getParentFile()), new Date(System.currentTimeMillis()));
    }

    public long getSize() {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        return this.localFile.length();
    }

    public boolean isData() {
        return !this.isFolder;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Date lastModified() {
        return new Date(System.currentTimeMillis());
    }

    protected File getLocalFile() {
        return this.localFile;
    }

    public boolean exists() {
        if (this.localFile.exists()) {
            return true;
        }
        try {
            this.wfs.transferFile(this.pathname, this.localFile);
            return this.localFile.exists();
        }
        catch (IOException iOException) {
            this.wfs.handleException(iOException);
            return false;
        }
    }

    protected HttpFileObject(HttpFileSystem httpFileSystem, String string, Date date) {
        this.localFile = new File(httpFileSystem.getLocalRoot(), string);
        this.wfs = httpFileSystem;
        this.pathname = string;
        if (!this.localFile.canRead()) {
            if (httpFileSystem.isDirectory(string)) {
                this.localFile.mkdirs();
                this.isFolder = true;
                if ("".equals(string)) {
                    this.isRoot = true;
                }
            } else {
                this.isFolder = false;
            }
        } else {
            this.isFolder = this.localFile.isDirectory();
        }
    }

    public String toString() {
        return "[wfs]" + this.getNameExt();
    }

    public String getNameExt() {
        return this.pathname;
    }
}

