/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.util.fileSystem;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.util.fileSystem.FileObject;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import edu.uiowa.physics.pw.das.util.fileSystem.HtmlUtil;
import edu.uiowa.physics.pw.das.util.fileSystem.HttpFileObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;

public class HttpFileSystem
extends FileSystem {
    final File localRoot;
    final URL root;

    private HttpFileSystem(URL uRL, File file) {
        Object object;
        try {
            object = HtmlUtil.getDirectoryListing(uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("URL doesn't appear to exist: " + uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (!uRL.toString().endsWith("/")) {
            object = uRL.toString();
            try {
                uRL = new URL((String)object + "/");
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        this.root = uRL;
        this.localRoot = file;
    }

    public static HttpFileSystem createHttpFileSystem(URL uRL) throws IOException {
        File file = File.createTempFile("WebFileSystem", "~~~");
        File file2 = file.getParentFile();
        file2 = new File(file2, "das2/WebFileSystem/");
        file2 = new File(file2, uRL.getHost());
        file2 = new File(file2, uRL.getFile());
        file2.mkdirs();
        return new HttpFileSystem(uRL, file2);
    }

    protected void transferFile(String string, File file) throws IOException {
        DasApplication.getDefaultApplication().getLogger().info("create file " + string);
        URL uRL = new URL(this.root.toString() + string);
        InputStream inputStream = uRL.openStream();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.createNewFile()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[2048];
            int n = inputStream.read(byArray);
            DasApplication.getDefaultApplication().getLogger().info("transferring file " + string);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            fileOutputStream.close();
        } else {
            this.handleException(new RuntimeException("couldn't create local file: " + file));
        }
        inputStream.close();
    }

    protected File getLocalRoot() {
        return this.localRoot;
    }

    protected URL getRoot() {
        return this.root;
    }

    public boolean isDirectory(String string) {
        File file = new File(this.localRoot, string);
        if (file.exists()) {
            return file.isDirectory();
        }
        if (string.endsWith("/")) {
            return true;
        }
        try {
            File file2 = file.getParentFile();
            URL[] uRLArray = HtmlUtil.getDirectoryListing(this.getURL(this.getLocalName(file2)));
            URL uRL = string.startsWith("/") ? new URL(this.root + string.substring(1) + "/") : new URL(this.root + string + "/");
            int n = 0;
            while (n < uRLArray.length) {
                if (uRLArray[n].equals(uRL)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return false;
        }
    }

    public String[] listDirectory(String string) {
        if (!this.isDirectory(string)) {
            throw new IllegalArgumentException("is not a directory: " + string);
        }
        try {
            URL[] uRLArray = HtmlUtil.getDirectoryListing(this.getURL(string));
            if (uRLArray.length > 100) {
                throw new IllegalStateException("URL list is very long, refusing to transfer");
            }
            String[] stringArray = new String[uRLArray.length];
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                stringArray[n] = this.getLocalName(uRL);
                ++n;
            }
            return stringArray;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return new String[0];
        }
    }

    public String[] listDirectory(String string, String string2) {
        if (!this.isDirectory(string = FileSystem.toCanonicalFilename(string))) {
            throw new IllegalArgumentException("is not a directory: " + string);
        }
        try {
            Pattern pattern = Pattern.compile(string2);
            URL[] uRLArray = HtmlUtil.getDirectoryListing(this.getURL(string));
            if (uRLArray.length > 100) {
                throw new IllegalStateException("URL list is very long, refusing to transfer");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                String string3 = this.getLocalName(uRL).substring(string.length());
                if (pattern.matcher(string3).matches()) {
                    arrayList.add(string3);
                }
                ++n;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return new String[0];
        }
    }

    public URL getURL(String string) {
        try {
            string = FileSystem.toCanonicalFilename(string);
            return new URL(this.root + string.substring(1));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String string = file.toString().substring(this.localRoot.toString().length());
        string = string.replaceAll("\\\\", "/");
        return string;
    }

    public String getLocalName(URL uRL) {
        if (!uRL.toString().startsWith(this.root.toString())) {
            throw new IllegalArgumentException("url \"" + uRL + "\"is not of this web file system");
        }
        String string = FileSystem.toCanonicalFilename(uRL.toString().substring(this.root.toString().length()));
        return string;
    }

    public FileObject getFile(String string) {
        HttpFileObject httpFileObject = new HttpFileObject(this, string, new Date(System.currentTimeMillis()));
        if (httpFileObject.canRead()) {
            return httpFileObject;
        }
        try {
            this.transferFile(string, httpFileObject.getLocalFile());
            return httpFileObject;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return "wfs: " + this.root;
    }
}

