/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.NameContext;
import java.beans.Introspector;
import java.util.logging.Logger;

public class DasApplication {
    private static final DasApplication DEFAULT = new DasApplication();
    private NameContext nameContext = new NameContext();
    private Logger debugLogger;
    private boolean headless = false;

    private DasApplication() {
    }

    public NameContext getNameContext() {
        return this.nameContext;
    }

    public static DasApplication getDefaultApplication() {
        return DEFAULT;
    }

    private static boolean isApplet() {
        return false;
    }

    private static boolean isX11() {
        String string = System.getProperty("os.name");
        return "SunOS".equals(string) || "Linux".equals(string);
    }

    public static boolean isHeadAvailable() {
        return true;
    }

    public boolean isHeadless() {
        return "true".equals(System.getProperty("java.awt.headless"));
    }

    public void setHeadless(boolean bl) {
        if (bl) {
            System.setProperty("java.awt.headless", "true");
        } else {
            if (!DasApplication.isHeadAvailable()) {
                throw new IllegalArgumentException("attempt to unset headless when environment is headless.");
            }
            System.setProperty("java.awt.headless", "false");
        }
    }

    public Logger getLogger() {
        return DasProperties.getLogger();
    }

    public synchronized Logger getDebugLogger() {
        return Logger.getLogger("debug");
    }

    static {
        String[] stringArray = new String[]{"edu.uiowa.physics.pw.das.beans"};
        Introspector.setBeanInfoSearchPath(stringArray);
    }
}

