/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das;

import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.dasml.ParsedExpression;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameContext {
    private static final String SIMPLE_NAME_STRING = "[A-Za-z][A-Za-z0-9_]*";
    private static final String INDEX_STRING = "0|[1-9][0-9]*";
    private static final String INDEXED_NAME_STRING = "([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\]";
    private static final String QUALIFIED_NAME_STRING = "[A-Za-z][A-Za-z0-9_]*(\\.[A-Za-z][A-Za-z0-9_]*|\\.([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\])*";
    public static final Pattern SIMPLE_NAME = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    public static final Pattern INDEXED_NAME = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\]");
    public static final Pattern QUALIFIED_NAME = Pattern.compile("[A-Za-z][A-Za-z0-9_]*(\\.[A-Za-z][A-Za-z0-9_]*|\\.([A-Za-z][A-Za-z0-9_]*)\\[(0|[1-9][0-9]*)\\])*");
    public static final Pattern refPattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
    public static final Pattern intPattern = Pattern.compile("-?(0|[1-9][0-9]*)");
    public static final Pattern floatPattern = Pattern.compile("-?[0-9]*(\\.[0-9]*)?([eE]-?[0-9]+)?");
    private HashMap nameMap = new HashMap();
    private HashMap propertyMap = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$datum$Datum;

    NameContext() {
    }

    public void put(String string, Object object) throws DasNameException {
        Matcher matcher = SIMPLE_NAME.matcher(string);
        if (!matcher.matches()) {
            throw new DasNameException(string + " must match " + SIMPLE_NAME_STRING);
        }
        this.nameMap.put(string, object);
    }

    public Object get(String string) throws DasPropertyException, InvocationTargetException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        Matcher matcher = SIMPLE_NAME.matcher(string);
        if (matcher.matches()) {
            return this.nameMap.get(string);
        }
        int n = string.lastIndexOf(46);
        Object object = this.get(string.substring(0, n));
        String string2 = string.substring(n + 1);
        matcher = INDEXED_NAME.matcher(string2);
        if (matcher.matches()) {
            string2 = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
            return this.getIndexedPropertyValue(object, string2, n);
        }
        return this.getPropertyValue(object, string2);
    }

    public void set(String string, Object object) throws InvocationTargetException, ParsedExpressionException, DasPropertyException, DasNameException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        Matcher matcher = SIMPLE_NAME.matcher(string);
        if (matcher.matches()) {
            this.put(string, object);
        }
        int n = string.lastIndexOf(46);
        Object object2 = this.get(string.substring(0, n));
        String string2 = string.substring(n + 1);
        matcher = INDEXED_NAME.matcher(string2);
        if (matcher.matches()) {
            string2 = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
            this.setIndexedPropertyValue(object2, string2, n, object);
        } else {
            this.setPropertyValue(object2, string2, object);
        }
    }

    public Object getPropertyValue(Object object, String string) throws DasPropertyException, InvocationTargetException {
        try {
            Class<?> clazz = object.getClass();
            this.maybeLoadPropertiesForClass(clazz);
            Map map = (Map)this.propertyMap.get(clazz);
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(string);
            if (propertyDescriptor == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, string);
            }
            Method method = propertyDescriptor.getReadMethod();
            return method.invoke(object, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public Object getIndexedPropertyValue(Object object, String string, int n) throws DasPropertyException, InvocationTargetException {
        try {
            Class<?> clazz = object.getClass();
            this.maybeLoadPropertiesForClass(clazz);
            Map map = (Map)this.propertyMap.get(clazz);
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(string);
            if (propertyDescriptor == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, string);
            }
            if (!(propertyDescriptor instanceof IndexedPropertyDescriptor)) {
                throw new DasPropertyException(DasPropertyException.NOT_INDEXED, null, string);
            }
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            Method method = indexedPropertyDescriptor.getIndexedReadMethod();
            return method.invoke(object, new Integer(n));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public void setPropertyValue(Object object, String string, Object object2) throws InvocationTargetException, ParsedExpressionException, DasPropertyException {
        try {
            Class<?> clazz = object.getClass();
            this.maybeLoadPropertiesForClass(clazz);
            Map map = (Map)this.propertyMap.get(clazz);
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(string);
            if (propertyDescriptor == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, string);
            }
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                throw new DasPropertyException(DasPropertyException.READ_ONLY, null, string);
            }
            Class<?> clazz2 = propertyDescriptor.getPropertyType();
            if (object2 instanceof String) {
                object2 = this.parseValue((String)object2, clazz2);
            }
            if (!(clazz2.isInstance(object2) || clazz2 == Boolean.TYPE && object2 instanceof Boolean || clazz2 == Character.TYPE && object2 instanceof Character || clazz2 == Double.TYPE && object2 instanceof Double || clazz2 == Short.TYPE && object2 instanceof Short || clazz2 == Integer.TYPE && object2 instanceof Integer || clazz2 == Float.TYPE && object2 instanceof Float || clazz2 == Byte.TYPE && object2 instanceof Byte || clazz2 == Long.TYPE && object2 instanceof Long)) {
                throw new DasPropertyException(DasPropertyException.TYPE_MISMATCH, null, string);
            }
            method.invoke(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public void setIndexedPropertyValue(Object object, String string, int n, Object object2) throws InvocationTargetException, ParsedExpressionException, DasPropertyException {
        try {
            Class<?> clazz = object.getClass();
            this.maybeLoadPropertiesForClass(clazz);
            Map map = (Map)this.propertyMap.get(clazz);
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(string);
            if (propertyDescriptor == null) {
                throw new DasPropertyException(DasPropertyException.NOT_DEFINED, null, string);
            }
            if (!(propertyDescriptor instanceof IndexedPropertyDescriptor)) {
                throw new DasPropertyException(DasPropertyException.NOT_INDEXED, null, string);
            }
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            Method method = indexedPropertyDescriptor.getIndexedWriteMethod();
            if (method == null) {
                throw new DasPropertyException(DasPropertyException.READ_ONLY, null, string);
            }
            Class<?> clazz2 = propertyDescriptor.getPropertyType();
            if (object2 instanceof String) {
                object2 = this.parseValue((String)object2, clazz2);
            }
            if (!(clazz2.isInstance(object2) || clazz2 == Boolean.TYPE && object2 instanceof Boolean || clazz2 == Character.TYPE && object2 instanceof Character || clazz2 == Double.TYPE && object2 instanceof Double || clazz2 == Short.TYPE && object2 instanceof Short || clazz2 == Integer.TYPE && object2 instanceof Integer || clazz2 == Float.TYPE && object2 instanceof Float || clazz2 == Byte.TYPE && object2 instanceof Byte || clazz2 == Long.TYPE && object2 instanceof Long)) {
                throw new DasPropertyException(DasPropertyException.TYPE_MISMATCH, null, string);
            }
            method.invoke(object, new Integer(n), object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private void maybeLoadPropertiesForClass(Class clazz) {
        try {
            if (this.propertyMap.get(clazz) == null) {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                int n = 0;
                while (n < propertyDescriptorArray.length) {
                    IndexedPropertyDescriptor indexedPropertyDescriptor;
                    if (!(propertyDescriptorArray[n].getReadMethod() == null || propertyDescriptorArray[n] instanceof IndexedPropertyDescriptor && (indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptorArray[n]).getIndexedReadMethod() == null)) {
                        hashMap.put(propertyDescriptorArray[n].getName(), propertyDescriptorArray[n]);
                    }
                    ++n;
                }
                this.propertyMap.put(clazz, hashMap);
            }
        }
        catch (IntrospectionException introspectionException) {}
    }

    public void remove(String string) {
        this.nameMap.remove(string);
    }

    public Object parseValue(String string, Class clazz) throws ParsedExpressionException, InvocationTargetException, DasPropertyException {
        string = this.replaceReferences(string);
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = NameContext.class$("java.lang.String")) : class$java$lang$String)) {
            return string;
        }
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = NameContext.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            if (string.equals("true")) {
                return Boolean.TRUE;
            }
            if (string.equals("false")) {
                return Boolean.FALSE;
            }
            ParsedExpression parsedExpression = new ParsedExpression(string);
            Object object = parsedExpression.evaluate(this);
            if (!(object instanceof Boolean)) {
                throw new ParsedExpressionException("'" + string + "' does not evaluate to a boolean value");
            }
            return object;
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NameContext.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            if (intPattern.matcher(string).matches()) {
                return new Integer(string);
            }
            ParsedExpression parsedExpression = new ParsedExpression(string);
            Object object = parsedExpression.evaluate(this);
            if (!(object instanceof Number)) {
                throw new ParsedExpressionException("'" + string + "' does not evaluate to a numeric value");
            }
            return object instanceof Integer ? (Integer)object : new Integer(((Number)object).intValue());
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NameContext.class$("java.lang.Long")) : class$java$lang$Long)) {
            ParsedExpression parsedExpression;
            Object object;
            if (intPattern.matcher(string).matches()) {
                Long l = new Long(string);
            }
            if (!((object = (parsedExpression = new ParsedExpression(string)).evaluate(this)) instanceof Number)) {
                throw new ParsedExpressionException("'" + string + "' does not evaluate to a numeric value");
            }
            return new Long(((Number)object).longValue());
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NameContext.class$("java.lang.Float")) : class$java$lang$Float)) {
            ParsedExpression parsedExpression;
            Object object;
            if (floatPattern.matcher(string).matches()) {
                Float f = new Float(string);
            }
            if (!((object = (parsedExpression = new ParsedExpression(string)).evaluate(this)) instanceof Number)) {
                throw new ParsedExpressionException("'" + string + "' does not evaluate to a numeric value");
            }
            return new Float(((Number)object).floatValue());
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NameContext.class$("java.lang.Double")) : class$java$lang$Double)) {
            ParsedExpression parsedExpression;
            Object object;
            if (floatPattern.matcher(string).matches()) {
                Double d = new Double(string);
            }
            if (!((object = (parsedExpression = new ParsedExpression(string)).evaluate(this)) instanceof Number)) {
                throw new ParsedExpressionException("'" + string + "' does not evaluate to a numeric value");
            }
            return object instanceof Double ? (Double)object : new Double(((Number)object).doubleValue());
        }
        if (clazz == (class$edu$uiowa$physics$pw$das$datum$Datum == null ? (class$edu$uiowa$physics$pw$das$datum$Datum = NameContext.class$("edu.uiowa.physics.pw.das.datum.Datum")) : class$edu$uiowa$physics$pw$das$datum$Datum)) {
            try {
                return TimeUtil.create(string);
            }
            catch (ParseException parseException) {
                try {
                    return Datum.create(Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParsedExpressionException(string + " cannot be parsed as a Datum");
                }
            }
        }
        throw new IllegalStateException(clazz.getName() + " is not a recognized type");
    }

    protected String replaceReferences(String string) throws DasPropertyException, InvocationTargetException {
        Matcher matcher = refPattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1).trim();
            Object object = this.get(string2);
            string = matcher.replaceFirst(object.toString());
            matcher.reset(string);
        }
        return string;
    }

    public String toString() {
        return this.getClass().getName() + this.nameMap.keySet().toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

