/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.client.StandardDataStreamSource;
import edu.uiowa.physics.pw.das.client.StreamDataSetDescriptor;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class FakeStandardDataStreamSource
implements StandardDataStreamSource {
    public InputStream getInputStream(StreamDataSetDescriptor streamDataSetDescriptor, Datum datum, Datum datum2) throws DasException {
        double d = 8.333333333333334E-6;
        int n = (int)(datum2.subtract(datum).doubleValue(Units.seconds) * d);
        int n2 = 12;
        FakeInputStream fakeInputStream = new FakeInputStream(n, d, n2);
        return fakeInputStream;
    }

    public InputStream getReducedInputStream(StreamDataSetDescriptor streamDataSetDescriptor, Datum datum, Datum datum2, Datum datum3) throws DasException {
        return this.getInputStream(streamDataSetDescriptor, datum, datum2);
    }

    public void reset() {
    }

    class FakeInputStream
    extends InputStream {
        int nitems;
        long nRecs;
        double recsPerSecond;
        long floatCount;
        long byteCount;
        long recCount;
        long recSize;
        float currentFloat;
        byte[] iCurrentFloat;
        ByteBuffer buff;
        FloatBuffer fbuff;
        double transferRateBps;
        long transferBirthMilli;

        FakeInputStream(long l, double d, int n) {
            this.nitems = n;
            this.nRecs = l;
            this.recsPerSecond = d;
            this.buff = ByteBuffer.allocate(4 * (n + 1));
            this.fbuff = this.buff.asFloatBuffer();
            this.buff.position(this.buff.limit());
            this.floatCount = 0L;
            this.byteCount = 0L;
            this.recCount = 0L;
            this.recSize = (n + 1) * 4;
            this.iCurrentFloat = new byte[4];
            this.transferRateBps = 210000.0;
            this.transferBirthMilli = System.currentTimeMillis();
        }

        public int read() throws IOException {
            try {
                while ((double)(this.byteCount * 1000L / (1L + (System.currentTimeMillis() - this.transferBirthMilli))) > this.transferRateBps) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.buff.hasRemaining()) {
                this.buff.position(0);
                this.fbuff.put(0, (float)((double)this.recCount / this.recsPerSecond));
                int n = 1;
                while (n <= this.nitems) {
                    float f = (float)Math.random();
                    this.fbuff.put(n, f);
                    ++n;
                }
                ++this.recCount;
            }
            if (this.recCount > this.nRecs) {
                return -1;
            }
            int n = this.buff.get() & 0xFF;
            ++this.byteCount;
            return n;
        }
    }
}

