/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DasProgressPanel
extends JPanel
implements DasProgressMonitor {
    private long taskStartedTime;
    private long currentTaskPosition;
    private long maximumTaskPosition;
    private DecimalFormat transferRateFormat;
    private String transferRateString;
    private JLabel messageLabel;
    private JLabel kbLabel;
    private JProgressBar progressBar;
    private JFrame jframe;
    private boolean isCancelled = false;
    private String label;
    private static final int hideInitiallyMilliSeconds = 1500;
    private long lastTaskTime;
    private boolean running = false;

    public DasProgressPanel(String string) {
        this.label = string;
        this.setOpaque(false);
        this.initComponents();
        this.transferRateFormat = new DecimalFormat();
        this.transferRateFormat.setMaximumFractionDigits(2);
        this.maximumTaskPosition = -1L;
        this.transferRateString = "";
        this.lastTaskTime = Integer.MAX_VALUE;
    }

    public static DasProgressPanel createComponentPanel(DasCanvasComponent dasCanvasComponent, String string) {
        DasProgressPanel dasProgressPanel = new DasProgressPanel(string);
        dasProgressPanel.setSize(dasProgressPanel.getPreferredSize());
        int n = dasCanvasComponent.getColumn().getDMiddle();
        int n2 = dasCanvasComponent.getRow().getDMiddle();
        dasProgressPanel.setLocation(n - dasProgressPanel.getWidth() / 2, n2 - dasProgressPanel.getHeight() / 2);
        ((Container)dasCanvasComponent.getCanvas().getGlassPane()).add(dasProgressPanel);
        return dasProgressPanel;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public static DasProgressPanel createFramed(String string) {
        DasProgressPanel dasProgressPanel = new DasProgressPanel(string);
        dasProgressPanel.jframe = new JFrame("Das Progress Monitor");
        dasProgressPanel.jframe.getContentPane().add(dasProgressPanel);
        dasProgressPanel.jframe.pack();
        dasProgressPanel.jframe.setVisible(true);
        dasProgressPanel.jframe.setDefaultCloseOperation(2);
        return dasProgressPanel;
    }

    public void setLabel(String string) {
        this.messageLabel.setText(string);
        this.label = string;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.messageLabel.setOpaque(false);
        this.messageLabel.setFont(new Font("Dialog", 1, 18));
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setText(this.label);
        this.messageLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar();
        this.progressBar.setOpaque(false);
        this.progressBar.setMaximumSize(this.progressBar.getPreferredSize());
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.progressBar.setAlignmentX(0.5f);
        this.kbLabel = new JLabel();
        this.kbLabel.setOpaque(false);
        this.kbLabel.setHorizontalAlignment(0);
        this.kbLabel.setText("0 kb");
        this.kbLabel.setAlignmentX(0.5f);
        this.kbLabel.setMaximumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setMinimumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.kbLabel.setAlignmentX(0.5f);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.messageLabel);
        jPanel.add(this.progressBar);
        jPanel.add(this.kbLabel);
        LineBorder lineBorder = new LineBorder(Color.BLACK, 2);
        EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
        CompoundBorder compoundBorder = new CompoundBorder(lineBorder, emptyBorder);
        JButton jButton = new JButton("cancel");
        jButton.setOpaque(false);
        jButton.setBorder(compoundBorder);
        jButton.setFocusPainted(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DasProgressPanel.this.cancel();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setOpaque(false);
        jPanel2.add(jButton);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
    }

    public void finished() {
        this.running = false;
        this.lastTaskTime = System.currentTimeMillis() - this.taskStartedTime;
        if (this.jframe == null) {
            this.setVisible(false);
        } else {
            this.jframe.dispose();
        }
    }

    public void setTaskProgress(long l) throws IllegalStateException {
        if (this.isCancelled) {
            DasApplication.getDefaultApplication().getLogger().info("setTaskProgress called when isCancelled true, check isCancelled before calling setTaskProgress?");
            throw new IllegalStateException("Operation cancelled: developers: check isCancelled before calling setTaskProgress");
        }
        long l2 = System.currentTimeMillis() - this.taskStartedTime;
        if (l2 > 1500L && !this.isVisible()) {
            this.setVisible(true);
        }
        long l3 = this.currentTaskPosition = l;
        if (this.maximumTaskPosition > 0L) {
            this.progressBar.setValue((int)(l3 * 100L / this.maximumTaskPosition));
        } else {
            this.progressBar.setValue((int)l3 % 100);
        }
        String string = this.maximumTaskPosition > 0L ? "" + l3 + "/" + this.maximumTaskPosition + "" : "" + l3 + "";
        this.kbLabel.setText(string + " " + this.transferRateString);
        Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.repaint();
        }
    }

    public void setAdditionalInfo(String string) {
        this.transferRateString = string;
    }

    public long getTaskProgress() {
        return this.currentTaskPosition;
    }

    public void setTaskSize(long l) {
        if (l == -1L) {
            this.progressBar.setIndeterminate(true);
        } else {
            if (l < 1L) {
                throw new IllegalArgumentException("taskSize must be positive, or -1");
            }
            this.progressBar.setIndeterminate(false);
        }
        this.maximumTaskPosition = l;
    }

    public void started() {
        this.taskStartedTime = System.currentTimeMillis();
        this.currentTaskPosition = 0L;
        this.isCancelled = false;
        this.running = true;
        DasApplication.getDefaultApplication().getLogger().info("lastTaskTime=" + this.lastTaskTime);
        if ((double)this.lastTaskTime > 3000.0) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (DasProgressPanel.this.running) {
                        DasApplication.getDefaultApplication().getLogger().info("hide time=" + (System.currentTimeMillis() - DasProgressPanel.this.taskStartedTime));
                        DasProgressPanel.this.setTaskProgress(DasProgressPanel.this.getTaskProgress());
                    }
                }
            }).start();
        }
    }

    public void cancel() {
        this.isCancelled = true;
        this.finished();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        graphics2D.setColor(new Color(-587202561, true));
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        super.paintComponent(graphics);
    }
}

