/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;

public class DatumEditor
extends JComponent {
    private JTextField editor;
    private JButton unitsButton;
    private Units units = Units.dimensionless;
    private ActionListener actionListener;

    public DatumEditor() {
        this.initComponents();
        this.installListeners();
        this.initToolTips();
        this.setFocusable(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.editor = new JTextField(8);
        this.editor.setFocusable(false);
        this.add((Component)this.editor, "Center");
        this.unitsButton = new JButton();
        this.unitsButton.setFocusable(false);
        this.add((Component)this.unitsButton, "East");
    }

    private void installListeners() {
        UniversalListener universalListener = new UniversalListener();
        this.editor.addMouseListener(universalListener);
        this.unitsButton.addMouseListener(universalListener);
        this.addKeyListener(universalListener);
        this.addFocusListener(universalListener);
    }

    private void initToolTips() {
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setColumns(int n) {
        this.editor.setColumns(n);
    }

    public void setValue(Datum datum) {
        if (datum.getUnits() instanceof TimeLocationUnits) {
            this.editor.setText(TimeDatumFormatter.DEFAULT.format(datum));
        } else {
            this.editor.setText(datum.getFormatter().format(datum));
        }
        this.setUnits(datum.getUnits());
    }

    public Datum getValue() throws ParseException {
        return this.units.parse(this.editor.getText());
    }

    public void setUnits(Units units) {
        if (units instanceof TimeLocationUnits) {
            this.unitsButton.setVisible(false);
        } else {
            this.unitsButton.setVisible(true);
            this.unitsButton.setText(units.toString());
            this.unitsButton.setToolTipText(units.toString());
        }
        this.units = units;
    }

    public Units getUnits() {
        return this.units;
    }

    private void fireActionPerformed() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "DatumEditor"));
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public static void main(String[] stringArray) {
        DatumEditor datumEditor = new DatumEditor();
        datumEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("actionPerformed");
            }
        });
        datumEditor.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        datumEditor.setValue(TimeUtil.now());
        DatumEditor datumEditor2 = new DatumEditor();
        datumEditor2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("actionPerformed");
            }
        });
        datumEditor2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        datumEditor2.setValue(Datum.create(1.0, Units.celcius));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(datumEditor);
        jPanel.add(datumEditor2);
        JFrame jFrame = new JFrame("The Window");
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.unitsButton.getBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
            return this.unitsButton.getToolTipText();
        }
        return null;
    }

    private class UniversalListener
    implements MouseListener,
    KeyListener,
    FocusListener {
        private UniversalListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            DatumEditor.this.editor.getCaret().setVisible(true);
            DatumEditor.this.editor.getCaret().setSelectionVisible(true);
        }

        public void focusLost(FocusEvent focusEvent) {
            DatumEditor.this.editor.getCaret().setVisible(false);
            DatumEditor.this.editor.getCaret().setSelectionVisible(false);
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                DatumEditor.this.fireActionPerformed();
            } else {
                this.forwardKeyEvent(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.forwardKeyEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.forwardKeyEvent(keyEvent);
        }

        private void forwardKeyEvent(KeyEvent keyEvent) {
            keyEvent.setSource(DatumEditor.this.editor);
            DatumEditor.this.editor.dispatchEvent(keyEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DatumEditor.this.requestFocusInWindow();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

