/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.dasml.FormButton;
import edu.uiowa.physics.pw.das.dasml.FormCheckBox;
import edu.uiowa.physics.pw.das.dasml.FormChoice;
import edu.uiowa.physics.pw.das.dasml.FormList;
import edu.uiowa.physics.pw.das.dasml.FormPanel;
import edu.uiowa.physics.pw.das.dasml.FormRadioButton;
import edu.uiowa.physics.pw.das.dasml.FormRadioButtonGroup;
import edu.uiowa.physics.pw.das.dasml.FormTab;
import edu.uiowa.physics.pw.das.dasml.FormText;
import edu.uiowa.physics.pw.das.dasml.FormTextField;
import edu.uiowa.physics.pw.das.dasml.FormWindow;
import edu.uiowa.physics.pw.das.dasml.TransferableFormComponent;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvas;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvasComponent;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;

public class Toolbox
extends JTabbedPane {
    private static Image pointerOverlay;
    private static Component dummy;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$components$Toolbox$ToolComponent;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$components$Toolbox;

    public Toolbox() {
        this.initializeFormToolComponent();
        this.initializeGraphToolComponent();
    }

    private void initializeFormToolComponent() {
        String[] stringArray = new String[]{"form tab", "window", "panel", "static text", "text field", "button", "check box", "button group", "radio button", "choice", "list"};
        Class clazz = class$edu$uiowa$physics$pw$das$components$Toolbox == null ? (class$edu$uiowa$physics$pw$das$components$Toolbox = Toolbox.class$("edu.uiowa.physics.pw.das.components.Toolbox")) : class$edu$uiowa$physics$pw$das$components$Toolbox;
        Icon[] iconArray = new Icon[]{new ImageIcon(clazz.getResource("/images/toolbox/tab.gif")), new ImageIcon(clazz.getResource("/images/toolbox/window.gif")), new ImageIcon(clazz.getResource("/images/toolbox/panel.gif")), new ImageIcon(clazz.getResource("/images/toolbox/text.gif")), new ImageIcon(clazz.getResource("/images/toolbox/textfield.gif")), new ImageIcon(clazz.getResource("/images/toolbox/button.gif")), new ImageIcon(clazz.getResource("/images/toolbox/checkbox.gif")), new ImageIcon(clazz.getResource("/images/toolbox/buttongroup.gif")), new ImageIcon(clazz.getResource("/images/toolbox/radiobutton.gif")), new ImageIcon(clazz.getResource("/images/toolbox/choice.gif"))};
        ToolComponent toolComponent = new ToolComponent(stringArray, iconArray, 4);
        this.add("Form", toolComponent);
    }

    private void initializeGraphToolComponent() {
        String[] stringArray = new String[]{"canvas", "plot", "axis", "time axis", "spectrogram renderer", "line plot renderer", "spectrogram plot"};
        Class clazz = class$edu$uiowa$physics$pw$das$components$Toolbox == null ? (class$edu$uiowa$physics$pw$das$components$Toolbox = Toolbox.class$("edu.uiowa.physics.pw.das.components.Toolbox")) : class$edu$uiowa$physics$pw$das$components$Toolbox;
        Icon[] iconArray = new Icon[]{new ImageIcon(clazz.getResource("/images/toolbox/canvas.gif")), new ImageIcon(clazz.getResource("/images/toolbox/plot.gif")), new ImageIcon(clazz.getResource("/images/toolbox/axis.gif")), new ImageIcon(clazz.getResource("/images/toolbox/taxis.gif")), new ImageIcon(clazz.getResource("/images/toolbox/spectrogram.gif")), new ImageIcon(clazz.getResource("/images/toolbox/line.gif")), new ImageIcon(clazz.getResource("/images/toolbox/spectrogram_plot.gif"))};
        ToolComponent toolComponent = new ToolComponent(stringArray, iconArray, 4);
        this.add("Graph", toolComponent);
    }

    private static Transferable createTransferable(String string) {
        if (string.equals("form tab")) {
            return new TransferableFormComponent(new FormTab(null, "label"));
        }
        if (string.equals("window")) {
            return new TransferableFormComponent(new FormWindow(null, "title", 640, 480));
        }
        if (string.equals("panel")) {
            return new TransferableFormComponent(new FormPanel());
        }
        if (string.equals("static text")) {
            return new TransferableFormComponent(new FormText());
        }
        if (string.equals("text field")) {
            return new TransferableFormComponent(new FormTextField(null));
        }
        if (string.equals("button")) {
            return new TransferableFormComponent(new FormButton(null, "label"));
        }
        if (string.equals("check box")) {
            return new TransferableFormComponent(new FormCheckBox(null, "label"));
        }
        if (string.equals("button group")) {
            return new TransferableFormComponent(new FormRadioButtonGroup());
        }
        if (string.equals("radio button")) {
            return new TransferableFormComponent(new FormRadioButton(null, "label"));
        }
        if (string.equals("choice")) {
            return new TransferableFormComponent(new FormChoice(null));
        }
        if (string.equals("list")) {
            return new TransferableFormComponent(new FormList(null));
        }
        if (string.equals("canvas")) {
            return new TransferableCanvas(DasCanvas.createFormCanvas(null, 640, 480));
        }
        if (string.equals("plot")) {
            return new TransferableCanvasComponent(DasPlot.createNamedPlot(null));
        }
        if (string.equals("axis")) {
            return new TransferableCanvasComponent(DasAxis.createNamedAxis(null));
        }
        if (string.equals("time axis")) {
            return new TransferableCanvasComponent(DasAxis.createNamedAxis(null));
        }
        if (string.equals("spectrogram renderer")) {
            DasColorBar dasColorBar = DasColorBar.createNamedColorBar(null);
            return new TransferableRenderer(new SpectrogramRenderer(null, dasColorBar));
        }
        if (string.equals("line plot renderer")) {
            return new TransferableRenderer(new SymbolLineRenderer((DataSetDescriptor)null));
        }
        if (string.equals("spectrogram plot")) {
            DasPlot dasPlot = DasPlot.createNamedPlot(null);
            DasColorBar dasColorBar = DasColorBar.createNamedColorBar(dasPlot.getDasName() + "_colorbar");
            SpectrogramRenderer spectrogramRenderer = new SpectrogramRenderer(null, dasColorBar);
            dasPlot.addRenderer(spectrogramRenderer);
            return new TransferableCanvasComponent(dasPlot);
        }
        throw new IllegalArgumentException(string);
    }

    private static Cursor[] getCursors(String[] stringArray, Icon[] iconArray) {
        Cursor[] cursorArray = new Cursor[iconArray.length];
        Point point = new Point(0, 0);
        int n = 0;
        while (n < cursorArray.length) {
            int n2 = iconArray[n].getIconWidth();
            int n3 = iconArray[n].getIconHeight();
            BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
            Graphics graphics = bufferedImage.getGraphics();
            iconArray[n].paintIcon(dummy, graphics, 8, 8);
            graphics.drawImage(pointerOverlay, 0, 0, dummy);
            cursorArray[n] = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, point, stringArray[n]);
            ++n;
        }
        return cursorArray;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)new Toolbox(), "Center");
        jFrame.getContentPane().add((Component)new JTextArea(10, 10), "West");
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        dummy = new Component(){};
        Class clazz = class$edu$uiowa$physics$pw$das$components$Toolbox$ToolComponent == null ? (class$edu$uiowa$physics$pw$das$components$Toolbox$ToolComponent = Toolbox.class$("edu.uiowa.physics.pw.das.components.Toolbox$ToolComponent")) : class$edu$uiowa$physics$pw$das$components$Toolbox$ToolComponent;
        URL uRL = clazz.getResource("/images/toolbox/dragpointer.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(dummy);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        pointerOverlay = image;
    }

    private static class InputListener
    extends MouseInputAdapter {
        private InputListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ToolComponent toolComponent = (ToolComponent)mouseEvent.getComponent();
            toolComponent.selectedIndex = toolComponent.positionToIndex(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static class ToolComponent
    extends JComponent {
        private Icon[] icons;
        private String[] ids;
        private Cursor[] cursors;
        private int width;
        private int height;
        private int selectedIndex = -1;

        private ToolComponent(String[] stringArray, Icon[] iconArray, int n) {
            this.ids = stringArray;
            this.icons = iconArray;
            this.cursors = Toolbox.getCursors(stringArray, iconArray);
            this.width = n;
            this.height = (int)Math.ceil((double)iconArray.length / (double)n);
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.setTransferHandler(null);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 1, new ToolboxDragGestureListener());
            this.addMouseListener(new InputListener());
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        protected void paintComponent(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(this.getBackground());
            if (rectangle == null) {
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics.setColor(this.getForeground());
            int n = 0;
            while (n < this.icons.length) {
                int n2 = n % this.width;
                int n3 = n / this.width;
                int n4 = n2 * 32 + 7;
                int n5 = n3 * 32 + 7;
                this.icons[n].paintIcon(this, graphics, n4, n5);
                graphics.drawRect(n4 - 1, n5 - 1, 24, 24);
                ++n;
            }
        }

        public Dimension getPreferredSize() {
            int n = this.width * 32 + 6;
            int n2 = this.height * 32 + 6;
            return new Dimension(n, n2);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        private int positionToIndex(int n, int n2) {
            int n3 = 0;
            while (n3 < this.icons.length) {
                int n4 = n3 % this.width;
                int n5 = n3 / this.width;
                int n6 = n4 * 32 + 7;
                int n7 = n5 * 32 + 7;
                if (n >= n6 && n < n6 + 24 && n2 >= n7 && n2 < n7 + 24) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.positionToIndex(mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                return null;
            }
            return this.ids[n];
        }
    }

    private static class ToolboxDragGestureListener
    implements DragGestureListener,
    DragSourceListener {
        private ToolboxDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            ToolComponent toolComponent = (ToolComponent)dragGestureEvent.getComponent();
            int n = toolComponent.selectedIndex;
            if (n >= 0) {
                Cursor cursor = toolComponent.cursors[n];
                Transferable transferable = Toolbox.createTransferable(toolComponent.ids[n]);
                dragGestureEvent.startDrag(cursor, transferable, this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }
}

