/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.AverageTableRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VerticalSpectrogramAverager
extends DasPlot
implements DataRangeSelectionListener {
    private JDialog popupWindow;
    private Datum yValue;
    private DasPlot parentPlot;
    private SymbolLineRenderer renderer;

    private VerticalSpectrogramAverager(DasPlot dasPlot, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasAxis, dasAxis2);
        this.parentPlot = dasPlot;
        this.renderer = new SymbolLineRenderer((DataSetDescriptor)null);
        this.addRenderer(this.renderer);
    }

    public static VerticalSpectrogramAverager createAverager(DasPlot dasPlot, TableDataSetConsumer tableDataSetConsumer) {
        DasAxis dasAxis = dasPlot.getYAxis();
        DasAxis dasAxis2 = dasAxis.createAttachedAxis(2);
        DasAxis dasAxis3 = tableDataSetConsumer.getZAxis().createAttachedAxis(3);
        return new VerticalSpectrogramAverager(dasPlot, dasAxis2, dasAxis3);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    VerticalSpectrogramAverager.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int n = this.parentPlot.getCanvas().getWidth() / 2;
        int n2 = this.parentPlot.getCanvas().getHeight() / 2;
        DasCanvas dasCanvas = new DasCanvas(n, n2);
        DasRow dasRow = new DasRow(dasCanvas, 0.1, 0.9);
        DasColumn dasColumn = new DasColumn(dasCanvas, 0.1, 0.9);
        dasCanvas.add(this, dasRow, dasColumn);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        JButton jButton = new JButton("Hide Window");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VerticalSpectrogramAverager.this.popupWindow.setVisible(false);
            }
        });
        jPanel2.setLayout(boxLayout);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.add((Component)dasCanvas, "Center");
        jPanel.add((Component)jPanel2, "South");
        Window window = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = window instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog());
        this.popupWindow.setTitle("Vertical Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(jPanel);
        this.popupWindow.pack();
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, this.parentPlot.getCanvas());
        this.popupWindow.setLocation(point.x + this.parentPlot.getCanvas().getWidth(), point.y);
    }

    protected void drawContent(Graphics2D graphics2D) {
        super.drawContent(graphics2D);
    }

    public void DataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        DataSet dataSet = dataRangeSelectionEvent.getDataSet();
        if (dataSet == null || !(dataSet instanceof TableDataSet)) {
            return;
        }
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        Datum datum = dataRangeSelectionEvent.getMinimum();
        Datum datum2 = dataRangeSelectionEvent.getMaximum();
        this.setTitle("" + datum + " - " + datum2);
        if (datum2.equals(datum)) {
            return;
        }
        RebinDescriptor rebinDescriptor = new RebinDescriptor(datum, datum2, 1, false);
        AverageTableRebinner averageTableRebinner = new AverageTableRebinner();
        try {
            TableDataSet tableDataSet2 = (TableDataSet)averageTableRebinner.rebin(tableDataSet, rebinDescriptor, null);
            VectorDataSet vectorDataSet = tableDataSet2.getXSlice(0);
            this.renderer.setDataSet(vectorDataSet);
        }
        catch (DasException dasException) {
            // empty catch block
        }
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        } else {
            this.repaint();
        }
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    protected void installComponent() {
        super.installComponent();
        this.getCanvas().getGlassPane().setVisible(false);
    }
}

