/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.FloatingPointDocumentFilter;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DocumentFilter;

class FloatingPointFormatter
extends JFormattedTextField.AbstractFormatter {
    FloatingPointFormatter() {
    }

    public Object stringToValue(String string) throws ParseException {
        try {
            Double d = new Double(string);
            if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || d == Double.NaN) {
                throw new ParseException("+/-infinity and NaN are not allowed", 0);
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }

    public String valueToString(Object object) throws ParseException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return object.toString();
        }
        throw new ParseException("value must be of type Number", 0);
    }

    protected DocumentFilter getDocumentFilter() {
        return new FloatingPointDocumentFilter();
    }
}

