/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyCellEditor;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyCellRenderer;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNode;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableCellRenderer;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableModel;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;

public class PropertyEditor
extends JPanel {
    JTable table;
    JButton closeButton;
    JDialog dialog;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$awt$Window;

    public PropertyEditor(Editable editable) {
        super(new BorderLayout());
        PropertyTreeNode propertyTreeNode = new PropertyTreeNode(editable);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(propertyTreeNode, true);
        TreeTableCellRenderer treeTableCellRenderer = new TreeTableCellRenderer(defaultTreeModel);
        treeTableCellRenderer.setRootVisible(false);
        treeTableCellRenderer.setShowsRootHandles(false);
        TreeTableModel treeTableModel = new TreeTableModel(propertyTreeNode, treeTableCellRenderer);
        this.table = new JTable(treeTableModel);
        this.add((Component)new JScrollPane(this.table, 20, 30), "Center");
        this.initButtonPanel();
        PropertyCellRenderer propertyCellRenderer = new PropertyCellRenderer();
        PropertyCellEditor propertyCellEditor = new PropertyCellEditor(treeTableCellRenderer);
        Component component = propertyCellRenderer.getTableCellRendererComponent(null, "XXX", false, false, 0, 0);
        this.table.setRowHeight(component.getPreferredSize().height);
        treeTableCellRenderer.setRowHeight(component.getPreferredSize().height);
        treeTableCellRenderer.setCellRenderer(propertyCellRenderer);
        this.table.getColumnModel().getColumn(0).setCellRenderer(treeTableCellRenderer);
        this.table.getColumnModel().getColumn(1).setCellRenderer(propertyCellRenderer);
        this.table.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = PropertyEditor.class$("java.lang.Object")) : class$java$lang$Object, propertyCellEditor);
        this.table.addMouseListener(new PropertyTableMouseListener());
    }

    private void initButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        final JButton jButton = new JButton("Apply Changes");
        this.closeButton = new JButton("Dismiss");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton) {
                    PropertyEditor.this.globalApplyChanges();
                } else if (actionEvent.getSource() == PropertyEditor.this.closeButton) {
                    PropertyEditor.this.dismissDialog();
                }
            }
        };
        jButton.addActionListener(actionListener);
        this.closeButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jPanel.add(this.closeButton);
        this.add((Component)jPanel, "South");
    }

    private void globalApplyChanges() {
        TreeTableModel treeTableModel = (TreeTableModel)this.table.getModel();
        PropertyTreeNode propertyTreeNode = (PropertyTreeNode)treeTableModel.getRoot();
        try {
            propertyTreeNode.flush();
        }
        catch (InvocationTargetException invocationTargetException) {
            DasExceptionHandler.handle(invocationTargetException.getCause());
        }
    }

    private void dismissDialog() {
        PropertyTreeNode propertyTreeNode = (PropertyTreeNode)((TreeTableModel)this.table.getModel()).getRoot();
        if (propertyTreeNode.isDirty()) {
            String[] stringArray = new String[]{"You have unsaved changes", "Would you like to apply them?"};
            int n = JOptionPane.showConfirmDialog(this, stringArray, "", 1, 3);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.globalApplyChanges();
            }
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void showDialog(Component component) {
        if (this.dialog == null) {
            Container container;
            Container container2 = component == null ? null : (container = SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = PropertyEditor.class$("java.awt.Window")) : class$java$awt$Window, component));
            this.dialog = container instanceof JFrame ? new JDialog((JFrame)container) : (container instanceof JDialog ? new JDialog((JDialog)container) : new JDialog());
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PropertyEditor.this.dismissDialog();
                }
            });
            this.dialog.setContentPane(this);
            this.dialog.pack();
        }
        if (component != null) {
            this.dialog.setLocationRelativeTo(component);
        }
        this.dialog.setVisible(true);
    }

    public void doLayout() {
        if (SwingUtilities.isDescendingFrom(this, this.dialog)) {
            this.closeButton.setVisible(true);
        } else {
            this.closeButton.setVisible(false);
        }
        super.doLayout();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PropertyTableMouseListener
    extends MouseAdapter {
        PropertyTableMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = PropertyEditor.this.table.rowAtPoint(point);
            int n2 = PropertyEditor.this.table.columnAtPoint(point);
            TreeTableModel treeTableModel = (TreeTableModel)PropertyEditor.this.table.getModel();
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)treeTableModel.getNodeForRow(n);
            if (!propertyTreeNode.isLeaf()) {
                treeTableModel.toggleExpanded(n);
            }
        }
    }
}

