/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.treetable;

import edu.uiowa.physics.pw.das.components.treetable.TreeTableNode;
import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TreeTableModel
extends AbstractTableModel
implements TableModel {
    private TreeTableNode root;
    private JTree tree;

    public TreeTableModel(TreeTableNode treeTableNode, JTree jTree) {
        this.root = treeTableNode;
        this.tree = jTree;
        jTree.addTreeExpansionListener(new TreeTableTreeListener());
        jTree.getModel().addTreeModelListener(new TreeTableTreeModelListener());
    }

    public Class getColumnClass(int n) {
        return this.root.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.root.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.root.getColumnName(n);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public Object getValueAt(int n, int n2) {
        return this.getNodeForRow(n).getValueAt(n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getNodeForRow(n).isCellEditable(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.getNodeForRow(n).setValueAt(object, n2);
    }

    public void toggleExpanded(int n) {
        if (this.tree.isExpanded(n)) {
            this.tree.collapseRow(n);
        } else {
            this.tree.expandRow(n);
        }
    }

    public TreeTableNode getNodeForRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        return (TreeTableNode)treePath.getLastPathComponent();
    }

    public TreeTableNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeTableNode treeTableNode) {
        if (treeTableNode == null) {
            throw new NullPointerException("null root node not allowed");
        }
        this.tree.setModel(new DefaultTreeModel(treeTableNode, true));
    }

    private class TreeTableTreeListener
    implements TreeExpansionListener {
        private TreeTableTreeListener() {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = TreeTableModel.this.tree.getRowForPath(treePath);
            TreeTableNode treeTableNode = (TreeTableNode)treePath.getLastPathComponent();
            int n2 = treeTableNode.getChildCount();
            if (n2 != 0) {
                TreeTableModel.this.fireTableRowsDeleted(n + 1, n + n2);
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            int n = TreeTableModel.this.tree.getRowForPath(treePath);
            TreeTableNode treeTableNode = (TreeTableNode)treePath.getLastPathComponent();
            int n2 = treeTableNode.getChildCount();
            if (n2 != 0) {
                TreeTableModel.this.fireTableRowsInserted(n + 1, n + n2);
            }
        }
    }

    private class TreeTableTreeModelListener
    implements TreeModelListener {
        private TreeTableTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = new TreePath(treeModelEvent.getPath());
            int n = TreeTableModel.this.tree.getRowForPath(treePath);
            TreeTableNode treeTableNode = (TreeTableNode)treePath.getLastPathComponent();
            int n2 = treeTableNode.getChildCount();
            if (n != -1 && TreeTableModel.this.tree.isExpanded(n)) {
                TreeTableModel.this.fireTableRowsUpdated(n + 1, n + n2);
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = new TreePath(treeModelEvent.getPath());
            int n = TreeTableModel.this.tree.getRowForPath(treePath);
            if (n != -1 && TreeTableModel.this.tree.isExpanded(n)) {
                int[] nArray = treeModelEvent.getChildIndices();
                Arrays.sort(nArray);
                int n2 = 0;
                while (n2 < nArray.length) {
                    TreeTableModel.this.fireTableRowsInserted(nArray[n2], nArray[n2]);
                    ++n2;
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = new TreePath(treeModelEvent.getPath());
            int n = TreeTableModel.this.tree.getRowForPath(treePath);
            if (n != -1 && TreeTableModel.this.tree.isExpanded(n)) {
                int[] nArray = treeModelEvent.getChildIndices();
                Arrays.sort(nArray);
                int n2 = nArray.length - 1;
                while (n2 >= 0) {
                    TreeTableModel.this.fireTableRowsDeleted(nArray[n2], nArray[n2]);
                    ++n2;
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreeTableModel.this.fireTableStructureChanged();
        }
    }
}

