/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.DataFormatException;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommandBlock {
    private static final int NONE = 0;
    private static final int SET = 1;
    private static final int UPDATE = 2;
    private static final int IF = 4;
    private static final int ELSEIF = 8;
    private static final int INVOKE = 16;
    private static final int ALERT = 32;
    ArrayList commandList = new ArrayList();

    CommandBlock() {
    }

    CommandBlock(Element element, FormBase formBase) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element) {
                String string = node.getNodeName();
                if (string.equals("set")) {
                    this.addCommand(this.processSetElement(formBase, (Element)node));
                } else if (string.equals("if")) {
                    this.addCommand(this.processIfElement(formBase, (Element)node));
                } else if (string.equals("elseif")) {
                    this.addCommand(this.processElseifElement(formBase, (Element)node));
                } else if (string.equals("else")) {
                    this.addCommand(this.processElseElement(formBase, (Element)node));
                } else if (string.equals("invoke")) {
                    this.addCommand(this.processInvokeElement(formBase, (Element)node));
                }
            }
            ++n2;
        }
    }

    private Command processSetElement(FormBase formBase, Element element) {
        String string = element.getAttribute("property");
        String string2 = element.getAttribute("value");
        if (!NameContext.QUALIFIED_NAME.matcher(string).matches()) {
            throw new IllegalArgumentException("property attribute must be a valid identifier: <set property=\"" + string + "\" ...");
        }
        return new SetCommand(string, string2);
    }

    private Command processIfElement(FormBase formBase, Element element) {
        String string = element.getAttribute("test");
        return new IfCommand(string, element, formBase);
    }

    private Command processElseifElement(FormBase formBase, Element element) {
        String string = element.getAttribute("test");
        return new ElseIfCommand(string, element, formBase);
    }

    private Command processElseElement(FormBase formBase, Element element) {
        return new ElseCommand(element, formBase);
    }

    private Command processInvokeElement(FormBase formBase, Element element) {
        String string = element.getAttribute("method");
        String string2 = element.getAttribute("args");
        String[] stringArray = string2.trim().length() == 0 ? new String[]{} : string2.split(",");
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].trim();
            ++n;
        }
        return new InvokeCommand(string, stringArray);
    }

    public void execute(FormBase formBase) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException {
        Iterator iterator = this.commandList.iterator();
        int n = -1;
        boolean bl = false;
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            if ((command instanceof ElseIfCommand || command instanceof ElseCommand) && bl) continue;
            command.execute(formBase);
            if (!(command instanceof IfCommand)) continue;
            bl = ((IfCommand)command).getShouldSkip();
        }
    }

    public void appendDOMElements(Element element) {
        Document document = element.getOwnerDocument();
        Iterator iterator = this.commandList.iterator();
        while (iterator.hasNext()) {
            element.appendChild(((Command)iterator.next()).getDOMElement(document));
        }
    }

    void insertCommand(Command command, int n) {
        if (command.getParent() != null && command.getParent() != this) {
            command.getParent().commandList.remove(command);
        }
        command.setParent(this);
        if (n == -1) {
            this.commandList.add(command);
        } else {
            this.commandList.add(n, command);
        }
    }

    void addCommand(Command command) {
        if (command.getParent() != null && command.getParent() != this) {
            command.getParent().commandList.remove(command);
        }
        command.setParent(this);
        this.commandList.add(command);
    }

    void removeCommand(int n) {
        this.commandList.remove(n);
    }

    void removeCommand(Command command) {
        this.commandList.remove(command);
    }

    int indexOf(Command command) {
        return this.commandList.indexOf(command);
    }

    static class Identifier {
        public String text;

        public Identifier(String string) {
            this.text = string;
        }

        public String toString() {
            return this.text;
        }
    }

    static abstract class BlockCommand
    extends CommandBlock
    implements Command {
        CommandBlock parent;

        public BlockCommand() {
        }

        public BlockCommand(Element element, FormBase formBase) {
            super(element, formBase);
        }

        public void setParent(CommandBlock commandBlock) {
            this.parent = commandBlock;
        }

        public CommandBlock getParent() {
            return this.parent;
        }
    }

    static interface Command {
        public CommandBlock getParent();

        public void setParent(CommandBlock var1);

        public void execute(FormBase var1) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException;

        public Element getDOMElement(Document var1);
    }

    static class ElseCommand
    extends IfCommand {
        ElseCommand() {
            super("true");
        }

        ElseCommand(Element element, FormBase formBase) {
            super("true", element, formBase);
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("else");
            this.appendDOMElements(element);
            return element;
        }

        public String toString() {
            return "ELSE";
        }
    }

    static class ElseIfCommand
    extends IfCommand {
        ElseIfCommand(String string) {
            super(string);
        }

        ElseIfCommand(String string, Element element, FormBase formBase) {
            super(string, element, formBase);
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("elseif");
            element.setAttribute("test", this.test);
            this.appendDOMElements(element);
            return element;
        }

        public String toString() {
            return "ELSEIF " + this.test;
        }
    }

    static class IfCommand
    extends BlockCommand {
        String test;
        boolean shouldSkip;

        public IfCommand(String string) {
            this.test = string;
        }

        public IfCommand(String string, Element element, FormBase formBase) {
            super(element, formBase);
            this.test = string;
        }

        public boolean getShouldSkip() {
            return this.shouldSkip;
        }

        public void execute(FormBase formBase) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException {
            Matcher matcher = NameContext.refPattern.matcher(this.test);
            Object object = matcher.matches() ? formBase.getDasApplication().getNameContext().get(matcher.group(1)) : formBase.getDasApplication().getNameContext().parseValue(this.test, Boolean.TYPE);
            if (!(object instanceof Boolean)) {
                throw new DataFormatException(object + " is not a boolean");
            }
            Boolean bl = (Boolean)object;
            if (bl.booleanValue()) {
                super.execute(formBase);
            }
            this.shouldSkip = bl;
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("if");
            element.setAttribute("test", this.test);
            this.appendDOMElements(element);
            return element;
        }

        public String toString() {
            return "IF " + this.test;
        }
    }

    static class InvokeCommand
    implements Command {
        String target;
        String[] args;
        CommandBlock parent;

        public InvokeCommand(String string, String[] stringArray) {
            this.target = string;
            this.args = stringArray;
        }

        public void execute(FormBase formBase) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException {
            formBase.invoke(this.target, this.args);
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("invoke");
            element.setAttribute("method", this.target);
            if (this.args != null && this.args.length > 0) {
                String string = Arrays.asList(this.args).toString();
                string = string.substring(0, string.length() - 1);
                element.setAttribute("args", string);
            }
            return element;
        }

        public void setParent(CommandBlock commandBlock) {
            this.parent = commandBlock;
        }

        public CommandBlock getParent() {
            return this.parent;
        }

        public String toString() {
            return "INVOKE " + this.target + (this.args == null ? "[]" : Arrays.asList(this.args).toString());
        }
    }

    static class SetCommand
    implements Command {
        String id;
        String value;
        CommandBlock parent;

        SetCommand(String string, String string2) {
            this.id = string;
            this.value = string2;
        }

        public void execute(FormBase formBase) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException, DasNameException {
            formBase.getDasApplication().getNameContext().set(this.id, this.value);
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("set");
            element.setAttribute("property", this.id);
            element.setAttribute("value", this.value);
            return element;
        }

        public CommandBlock getParent() {
            return this.parent;
        }

        public void setParent(CommandBlock commandBlock) {
            this.parent = commandBlock;
        }

        public String toString() {
            return "SET " + this.id + " = " + this.value;
        }
    }
}

