/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.dasml.CommandBlock;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CommandBlockEditor
extends JButton
implements TableCellEditor,
PropertyEditor {
    EventListenerList listenerList = new EventListenerList();
    JDialog dialog;
    JPanel contentPanel;
    JCheckBox enable;
    JTree commandTree;
    CommandBlockTreeModel commandBlockTreeModel;
    MultiPurposeListener listener = new MultiPurposeListener();
    JButton commitChanges;
    JButton cancelEdit;
    JPanel editorPanel;
    CardLayout switcher;
    JTextField x1Field;
    JLabel x1FieldLabel;
    JButton x1Commit;
    JButton x1Cancel;
    JTextField x2Field1;
    JTextField x2Field2;
    JLabel x2Field1Label;
    JLabel x2Field2Label;
    JButton x2Commit;
    JButton x2Cancel;
    JButton newCommand;
    JButton editCommand;
    JButton removeCommand;
    JButton moveUpCommand;
    JButton moveDownCommand;
    CommandBlock commandBlock;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public CommandBlockEditor() {
        super("edit");
        this.addActionListener(this.listener);
        this.commandBlockTreeModel = new CommandBlockTreeModel(new CommandBlock());
        this.commandTree = new JTree(this.commandBlockTreeModel);
        this.commandTree.setRootVisible(true);
        this.commandTree.setShowsRootHandles(false);
        this.commandTree.getSelectionModel().setSelectionMode(1);
        this.commandTree.setVisibleRowCount(10);
        this.commandTree.setCellRenderer(new CommandRenderer());
        this.contentPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.commandTree, 22, 32), "Center");
        this.editorPanel = this.initEditorPanels();
        jPanel.add((Component)this.editorPanel, "South");
        jPanel.add((Component)this.initButtonPanel(), "East");
        this.contentPanel.add((Component)jPanel, "Center");
        this.enable = new JCheckBox("Enabled", false);
        this.setTopEnabled(false);
        this.enable.addActionListener(this.listener);
        this.contentPanel.add((Component)this.enable, "North");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.commitChanges = new JButton("Commit Changes");
        this.commitChanges.addActionListener(this.listener);
        this.cancelEdit = new JButton("Cancel Changes");
        this.cancelEdit.addActionListener(this.listener);
        jPanel2.add(this.commitChanges);
        jPanel2.add(this.cancelEdit);
        this.contentPanel.add((Component)jPanel2, "South");
    }

    private JPanel initButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.newCommand = new JButton("new");
        this.editCommand = new JButton("edit");
        this.removeCommand = new JButton("remove");
        this.moveUpCommand = new JButton("move up");
        this.moveDownCommand = new JButton("move down");
        Dimension dimension = this.moveDownCommand.getPreferredSize();
        this.newCommand.setPreferredSize(dimension);
        this.newCommand.setMaximumSize(dimension);
        this.editCommand.setPreferredSize(dimension);
        this.editCommand.setMaximumSize(dimension);
        this.removeCommand.setPreferredSize(dimension);
        this.removeCommand.setMaximumSize(dimension);
        this.moveUpCommand.setPreferredSize(dimension);
        this.moveUpCommand.setMaximumSize(dimension);
        this.newCommand.addActionListener(this.listener);
        this.editCommand.addActionListener(this.listener);
        this.removeCommand.addActionListener(this.listener);
        this.moveUpCommand.addActionListener(this.listener);
        this.moveDownCommand.addActionListener(this.listener);
        jPanel.add(this.newCommand);
        jPanel.add(this.editCommand);
        jPanel.add(this.removeCommand);
        jPanel.add(this.moveUpCommand);
        jPanel.add(this.moveDownCommand);
        return jPanel;
    }

    void addCommand(CommandBlock.Command command) {
        Object[] objectArray;
        int n;
        CommandBlock commandBlock;
        TreePath treePath = this.commandTree.getSelectionPath();
        if (treePath == null) {
            commandBlock = this.commandBlock;
            n = commandBlock.commandList.size();
        } else if (treePath.getLastPathComponent() instanceof CommandBlock) {
            commandBlock = (CommandBlock)treePath.getLastPathComponent();
            n = commandBlock.commandList.size();
        } else {
            objectArray = (Object[])treePath.getLastPathComponent();
            commandBlock = objectArray.getParent();
            n = commandBlock.indexOf((CommandBlock.Command)objectArray) + 1;
        }
        commandBlock.insertCommand(command, n);
        objectArray = this.commandBlockTreeModel.getPathToNode(commandBlock);
        this.commandBlockTreeModel.fireTreeNodeInserted(objectArray, n, command);
    }

    void removeCommands(TreePath[] treePathArray) {
        List<Object> list;
        Object object;
        Object object2;
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        int n = 0;
        while (n < treePathArray.length) {
            if (treePathArray[n].getPathCount() != 1) {
                object2 = treePathArray[n].getParentPath();
                object = treePathArray[n].getLastPathComponent();
                list = (List)hashMap.get(object2);
                if (list == null) {
                    list = new ArrayList<Object>();
                    hashMap.put(object2, (ArrayList<Object>)list);
                }
                list.add(object);
            }
            ++n;
        }
        object2 = hashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            list = (TreePath)object.getKey();
            List list2 = (List)object.getValue();
            Object[] objectArray = new CommandBlock.Command[list2.size()];
            list2.toArray(objectArray);
            int[] nArray = new int[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                nArray[n2] = objectArray[n2].getParent().indexOf((CommandBlock.Command)objectArray[n2]);
                objectArray[n2].getParent().removeCommand((CommandBlock.Command)objectArray[n2]);
                ++n2;
            }
            this.commandBlockTreeModel.fireTreeNodesRemoved((TreePath)((Object)list), nArray, objectArray);
        }
    }

    private JPanel initEditorPanels() {
        this.switcher = new CardLayout();
        JPanel jPanel = new JPanel(this.switcher);
        jPanel.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new EtchedBorder()), new EmptyBorder(2, 2, 2, 2)));
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "EMPTY");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.x1Field = new JTextField(30);
        this.x1Field.setMaximumSize(this.x1Field.getPreferredSize());
        this.x1Field.setAlignmentX(0.0f);
        this.x1FieldLabel = new JLabel("field", 2);
        this.x1FieldLabel.setAlignmentX(0.0f);
        jPanel3.add(this.x1FieldLabel);
        jPanel3.add(this.x1Field);
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        jPanel4.setAlignmentX(0.0f);
        this.x1Commit = new JButton("Commit Changes");
        this.x1Commit.addActionListener(this.listener);
        this.x1Cancel = new JButton("Cancel Changes");
        this.x1Cancel.addActionListener(this.listener);
        jPanel4.add(this.x1Commit);
        jPanel4.add(this.x1Cancel);
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add(jPanel4);
        jPanel.add((Component)jPanel3, "SINGLE");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this.x2Field1 = new JTextField(30);
        this.x2Field1.setMaximumSize(this.x2Field1.getPreferredSize());
        this.x2Field1.setAlignmentX(0.0f);
        this.x2Field1Label = new JLabel("field1");
        this.x2Field1Label.setAlignmentX(0.0f);
        this.x2Field2 = new JTextField(30);
        this.x2Field2.setMaximumSize(this.x2Field2.getPreferredSize());
        this.x2Field2.setAlignmentX(0.0f);
        this.x2Field2Label = new JLabel("field2");
        this.x2Field2Label.setAlignmentX(0.0f);
        jPanel5.add(this.x2Field1Label);
        jPanel5.add(this.x2Field1);
        jPanel5.add(this.x2Field2Label);
        jPanel5.add(this.x2Field2);
        JPanel jPanel6 = new JPanel(new FlowLayout(2));
        jPanel6.setAlignmentX(0.0f);
        this.x2Commit = new JButton("Commit Changes");
        this.x2Commit.addActionListener(this.listener);
        this.x2Cancel = new JButton("Cancel Changes");
        this.x2Cancel.addActionListener(this.listener);
        jPanel6.add(this.x2Commit);
        jPanel6.add(this.x2Cancel);
        jPanel5.add(Box.createVerticalGlue());
        jPanel5.add(jPanel6);
        jPanel.add((Component)jPanel5, "DOUBLE");
        return jPanel;
    }

    public void showDialog() {
        if (this.dialog == null) {
            Window window = SwingUtilities.windowForComponent(this);
            if (window instanceof Frame) {
                this.dialog = new JDialog((Frame)window, true);
            } else if (window instanceof Dialog) {
                this.dialog = new JDialog((Dialog)window, true);
            } else {
                this.dialog = new JDialog();
                this.dialog.setModal(true);
            }
            this.dialog.setContentPane(this.contentPanel);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.addWindowListener(this.listener);
        }
        this.dialog.setVisible(true);
    }

    public CommandBlock getCommandBlock() {
        if (this.enable.isSelected()) {
            return this.commandBlock;
        }
        return null;
    }

    public void setCommandBlock(CommandBlock commandBlock) {
        if (commandBlock == null) {
            commandBlock = new CommandBlock();
            this.enable.setSelected(false);
            this.setTopEnabled(false);
        } else {
            this.enable.setSelected(true);
            this.setTopEnabled(true);
        }
        this.commandBlock = commandBlock;
        this.commandBlockTreeModel.root = commandBlock;
        this.commandBlockTreeModel.fireTreeChanged();
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        this.dialog.setVisible(false);
        return true;
    }

    public void cancelCellEditing() {
        this.dialog.setVisible(false);
        this.fireEditingCanceled();
    }

    private void setTopEnabled(boolean bl) {
        this.commandTree.setEnabled(bl);
        this.newCommand.setEnabled(bl);
        this.editCommand.setEnabled(bl);
        this.removeCommand.setEnabled(bl);
        this.moveUpCommand.setEnabled(bl);
        this.moveDownCommand.setEnabled(bl);
    }

    public static void main(String[] stringArray) {
        CommandBlockEditor commandBlockEditor = new CommandBlockEditor();
        CommandBlock commandBlock = new CommandBlock();
        commandBlock.addCommand(new CommandBlock.SetCommand("property", "value"));
        commandBlock.addCommand(new CommandBlock.InvokeCommand("fred", new String[]{"arg1", "arg2"}));
        CommandBlock.IfCommand ifCommand = new CommandBlock.IfCommand("test");
        ifCommand.addCommand(new CommandBlock.SetCommand("fred", "larry"));
        commandBlock.addCommand(ifCommand);
        commandBlockEditor.setCommandBlock(commandBlock);
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(commandBlockEditor);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = CommandBlockEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public Object getCellEditorValue() {
        return this.getCommandBlock();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setCommandBlock((CommandBlock)object);
        return this;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = CommandBlockEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    private void fireEditingCanceled() {
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener == null ? CommandBlockEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingCanceled(changeEvent);
            }
            n -= 2;
        }
    }

    private void fireEditingStopped() {
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener == null ? CommandBlockEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingStopped(changeEvent);
            }
            n -= 2;
        }
    }

    public String getAsText() {
        return "dflkjd";
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.commandBlock;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public void setValue(Object object) {
        this.setCommandBlock((CommandBlock)object);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CommandRenderer
    extends JLabel
    implements TreeCellRenderer {
        Color textForeground;
        Color textBackground;
        Color selectionForeground;
        Color selectionBackground;
        Border focusedBorder;
        Border unfocusedBorder;

        CommandRenderer() {
            this.setOpaque(true);
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.focusedBorder = new LineBorder(UIManager.getColor("Tree.selectionBorderColor"));
            this.unfocusedBorder = new LineBorder(this.textBackground);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setForeground(bl ? this.selectionForeground : this.textForeground);
            this.setBackground(bl ? this.selectionBackground : this.textBackground);
            this.setBorder(bl4 ? this.focusedBorder : this.unfocusedBorder);
            if (!(object instanceof CommandBlock.Command)) {
                this.setText("[Command Block]");
            } else {
                this.setText(object.toString());
            }
            this.setEnabled(jTree.isEnabled());
            return this;
        }
    }

    private static class CommandBlockTreeModel
    implements TreeModel {
        private EventListenerList eventListenerList;
        private CommandBlock root;

        CommandBlockTreeModel(CommandBlock commandBlock) {
            this.root = commandBlock;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            if (this.eventListenerList == null) {
                this.eventListenerList = new EventListenerList();
            }
            this.eventListenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = CommandBlockEditor.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
        }

        public Object getChild(Object object, int n) {
            if (object instanceof CommandBlock) {
                return ((CommandBlock)object).commandList.get(n);
            }
            return null;
        }

        public int getChildCount(Object object) {
            if (object instanceof CommandBlock) {
                return ((CommandBlock)object).commandList.size();
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object instanceof CommandBlock) {
                return ((CommandBlock)object).commandList.indexOf(object2);
            }
            return -1;
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            return !(object instanceof CommandBlock);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            if (this.eventListenerList != null) {
                this.eventListenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = CommandBlockEditor.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
            }
        }

        protected void fireTreeChanged() {
            TreeModelEvent treeModelEvent = null;
            Object[] objectArray = this.eventListenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.root});
                    }
                    ((TreeModelListener)objectArray[n + 1]).treeStructureChanged(treeModelEvent);
                }
                n -= 2;
            }
        }

        protected void fireTreeNodesChanged(Object[] objectArray, int n, Object object) {
            TreeModelEvent treeModelEvent = null;
            Object[] objectArray2 = this.eventListenerList.getListenerList();
            int n2 = objectArray2.length - 2;
            while (n2 >= 0) {
                if (objectArray2[n2] == (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent((Object)this, objectArray, new int[]{n}, new Object[]{object});
                    }
                    ((TreeModelListener)objectArray2[n2 + 1]).treeNodesChanged(treeModelEvent);
                }
                n2 -= 2;
            }
        }

        protected void fireTreeNodeInserted(Object[] objectArray, int n, Object object) {
            TreeModelEvent treeModelEvent = null;
            Object[] objectArray2 = this.eventListenerList.getListenerList();
            int n2 = objectArray2.length - 2;
            while (n2 >= 0) {
                if (objectArray2[n2] == (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent((Object)this, objectArray, new int[]{n}, new Object[]{object});
                    }
                    ((TreeModelListener)objectArray2[n2 + 1]).treeNodesInserted(treeModelEvent);
                }
                n2 -= 2;
            }
        }

        protected void fireTreeNodesRemoved(TreePath treePath, int[] nArray, Object[] objectArray) {
            TreeModelEvent treeModelEvent = null;
            Object[] objectArray2 = this.eventListenerList.getListenerList();
            int n = objectArray2.length - 2;
            while (n >= 0) {
                if (objectArray2[n] == (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
                    }
                    ((TreeModelListener)objectArray2[n + 1]).treeNodesRemoved(treeModelEvent);
                }
                n -= 2;
            }
        }

        protected void fireTreeStructureChanged(Object[] objectArray) {
            TreeModelEvent treeModelEvent = null;
            Object[] objectArray2 = this.eventListenerList.getListenerList();
            int n = objectArray2.length - 2;
            while (n >= 0) {
                if (objectArray2[n] == (class$javax$swing$event$TreeModelListener == null ? CommandBlockEditor.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                    if (treeModelEvent == null) {
                        treeModelEvent = new TreeModelEvent((Object)this, objectArray);
                    }
                    ((TreeModelListener)objectArray2[n + 1]).treeStructureChanged(treeModelEvent);
                }
                n -= 2;
            }
        }

        Object[] getPathToNode(Object object) {
            if (!(object instanceof CommandBlock.Command)) {
                return new Object[]{object};
            }
            CommandBlock.Command command = (CommandBlock.Command)object;
            CommandBlock commandBlock = command.getParent();
            int n = 2;
            while (commandBlock instanceof CommandBlock.Command) {
                commandBlock = ((CommandBlock.Command)((Object)commandBlock)).getParent();
                ++n;
            }
            Object[] objectArray = new Object[n];
            commandBlock = command.getParent();
            objectArray[n - 1] = object;
            objectArray[n - 2] = commandBlock;
            int n2 = n - 2;
            while (commandBlock instanceof CommandBlock.Command) {
                commandBlock = ((CommandBlock.Command)((Object)commandBlock)).getParent();
                objectArray[--n2] = commandBlock;
            }
            System.out.println(Arrays.asList(objectArray));
            return objectArray;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }

    private class MultiPurposeListener
    extends WindowAdapter
    implements ActionListener {
        final JPopupMenu newCommandMenu = new JPopupMenu("new command");

        private MultiPurposeListener() {
            this.newCommandMenu.add("SET").addActionListener(this);
            this.newCommandMenu.add("INVOKE").addActionListener(this);
            this.newCommandMenu.add("IF").addActionListener(this);
            this.newCommandMenu.add("ELSEIF").addActionListener(this);
            this.newCommandMenu.add("ELSE").addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object == CommandBlockEditor.this) {
                CommandBlockEditor.this.showDialog();
            } else if (object == CommandBlockEditor.this.commitChanges) {
                CommandBlockEditor.this.stopCellEditing();
            } else if (object == CommandBlockEditor.this.cancelEdit) {
                CommandBlockEditor.this.cancelCellEditing();
            } else if (object == CommandBlockEditor.this.enable) {
                CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "EMPTY");
                CommandBlockEditor.this.setTopEnabled(CommandBlockEditor.this.enable.isSelected());
            } else if (object == CommandBlockEditor.this.newCommand) {
                this.newCommandMenu.show(CommandBlockEditor.this.newCommand, CommandBlockEditor.this.newCommand.getWidth(), 0);
            } else if (object == CommandBlockEditor.this.editCommand) {
                TreePath treePath = CommandBlockEditor.this.commandTree.getSelectionPath();
                if (treePath != null && treePath.getPathCount() != 1) {
                    Object object2 = treePath.getLastPathComponent();
                    if (object2 instanceof CommandBlock.SetCommand) {
                        CommandBlock.SetCommand setCommand = (CommandBlock.SetCommand)object2;
                        CommandBlockEditor.this.x2Field1Label.setText("Property");
                        CommandBlockEditor.this.x2Field1.setText(setCommand.id);
                        CommandBlockEditor.this.x2Field2Label.setText("Value");
                        CommandBlockEditor.this.x2Field2.setText(setCommand.value);
                        CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "DOUBLE");
                        this.setEditing(true);
                    } else if (object2 instanceof CommandBlock.InvokeCommand) {
                        CommandBlock.InvokeCommand invokeCommand = (CommandBlock.InvokeCommand)object2;
                        CommandBlockEditor.this.x2Field1Label.setText("Method");
                        CommandBlockEditor.this.x2Field1.setText(invokeCommand.target);
                        CommandBlockEditor.this.x2Field2Label.setText("Arguments (comma separated)");
                        if (invokeCommand.args != null) {
                            String string2 = Arrays.asList(invokeCommand.args).toString();
                            CommandBlockEditor.this.x2Field2.setText(string2.substring(1, string2.length() - 1));
                        } else {
                            CommandBlockEditor.this.x2Field2.setText("");
                        }
                        CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "DOUBLE");
                        this.setEditing(true);
                    } else {
                        if (object2 instanceof CommandBlock.ElseCommand) {
                            return;
                        }
                        if (object2 instanceof CommandBlock.IfCommand) {
                            CommandBlock.IfCommand ifCommand = (CommandBlock.IfCommand)object2;
                            CommandBlockEditor.this.x1FieldLabel.setText("Test");
                            CommandBlockEditor.this.x1Field.setText(ifCommand.test);
                            CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "SINGLE");
                            this.setEditing(true);
                        }
                    }
                }
            } else if (object == CommandBlockEditor.this.removeCommand) {
                TreePath[] treePathArray = CommandBlockEditor.this.commandTree.getSelectionPaths();
                if (treePathArray != null) {
                    CommandBlockEditor.this.removeCommands(treePathArray);
                }
            } else if (object == CommandBlockEditor.this.moveUpCommand) {
                TreePath treePath = CommandBlockEditor.this.commandTree.getSelectionPath();
                if (treePath == null || treePath.getPathCount() == 1) {
                    return;
                }
                CommandBlock.Command command = (CommandBlock.Command)treePath.getLastPathComponent();
                CommandBlock commandBlock = command.getParent();
                int n = commandBlock.indexOf(command);
                if (n == 0) {
                    return;
                }
                CommandBlockEditor.this.removeCommands(new TreePath[]{treePath});
                commandBlock.insertCommand(command, n - 1);
                CommandBlockEditor.this.commandBlockTreeModel.fireTreeNodeInserted(treePath.getParentPath().getPath(), n - 1, command);
            } else if (object == CommandBlockEditor.this.moveDownCommand) {
                TreePath treePath = CommandBlockEditor.this.commandTree.getSelectionPath();
                if (treePath == null || treePath.getPathCount() == 1) {
                    return;
                }
                CommandBlock.Command command = (CommandBlock.Command)treePath.getLastPathComponent();
                CommandBlock commandBlock = command.getParent();
                int n = commandBlock.indexOf(command);
                if (n == commandBlock.commandList.size() - 1) {
                    return;
                }
                CommandBlockEditor.this.removeCommands(new TreePath[]{treePath});
                commandBlock.insertCommand(command, n + 1);
                CommandBlockEditor.this.commandBlockTreeModel.fireTreeNodeInserted(treePath.getParentPath().getPath(), n + 1, command);
            } else if (object == CommandBlockEditor.this.x1Commit) {
                TreePath treePath = CommandBlockEditor.this.commandTree.getSelectionPath();
                Object object3 = treePath.getLastPathComponent();
                CommandBlock.IfCommand ifCommand = (CommandBlock.IfCommand)object3;
                ifCommand.test = CommandBlockEditor.this.x1Field.getText();
                this.setEditing(false);
            } else if (object == CommandBlockEditor.this.x2Commit) {
                TreePath treePath = CommandBlockEditor.this.commandTree.getSelectionPath();
                Object object4 = treePath.getLastPathComponent();
                if (object4 instanceof CommandBlock.SetCommand) {
                    CommandBlock.SetCommand setCommand = (CommandBlock.SetCommand)object4;
                    setCommand.id = CommandBlockEditor.this.x2Field1.getText();
                    setCommand.value = CommandBlockEditor.this.x2Field2.getText();
                    this.setEditing(false);
                } else {
                    CommandBlock.InvokeCommand invokeCommand = (CommandBlock.InvokeCommand)object4;
                    invokeCommand.target = CommandBlockEditor.this.x2Field1.getText();
                    invokeCommand.args = CommandBlockEditor.this.x2Field2.getText().split("\\s*,\\s*");
                    this.setEditing(false);
                }
            } else if (object == CommandBlockEditor.this.x1Cancel || object == CommandBlockEditor.this.x2Cancel) {
                this.setEditing(false);
            } else if (string.equals("SET")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.SetCommand("property", "value"));
            } else if (string.equals("INVOKE")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.InvokeCommand("object.method", null));
            } else if (string.equals("IF")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.IfCommand("test"));
            } else if (string.equals("ELSEIF")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.ElseIfCommand("test"));
            } else if (string.equals("ELSE")) {
                CommandBlockEditor.this.addCommand(new CommandBlock.ElseCommand());
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            CommandBlockEditor.this.cancelCellEditing();
        }

        private void setEditing(boolean bl) {
            boolean bl2 = bl = !bl;
            if (bl) {
                CommandBlockEditor.this.switcher.show(CommandBlockEditor.this.editorPanel, "EMPTY");
            }
            CommandBlockEditor.this.setTopEnabled(bl);
            CommandBlockEditor.this.enable.setEnabled(bl);
            TreePath treePath = CommandBlockEditor.this.commandTree.getSelectionPath();
            CommandBlock.Command command = (CommandBlock.Command)treePath.getLastPathComponent();
            int n = command.getParent().indexOf(command);
            CommandBlockEditor.this.commandBlockTreeModel.fireTreeNodesChanged(treePath.getParentPath().getPath(), n, command);
        }
    }
}

