/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormButton;
import edu.uiowa.physics.pw.das.dasml.FormCheckBox;
import edu.uiowa.physics.pw.das.dasml.FormChoice;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.FormContainer;
import edu.uiowa.physics.pw.das.dasml.FormList;
import edu.uiowa.physics.pw.das.dasml.FormPanel;
import edu.uiowa.physics.pw.das.dasml.FormRadioButtonGroup;
import edu.uiowa.physics.pw.das.dasml.FormText;
import edu.uiowa.physics.pw.das.dasml.FormTextField;
import edu.uiowa.physics.pw.das.dasml.Orientation;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.dasml.TransferableFormComponent;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvas;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormTab
extends FormContainer {
    private String label;
    private String dasName;

    public FormTab(String string, String string2) {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR};
        this.flavorList = Arrays.asList(dataFlavorArray);
        this.setDirection(Orientation.VERTICAL);
        if (string == null) {
            string = "form_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        this.label = string2;
        this.dndSupport = new FormContainer.ContainerDnDSupport(this, null);
    }

    FormTab(Element element, FormBase formBase) throws DasException, ParsedExpressionException, SAXException {
        Object object = new DataFlavor[]{TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR};
        this.flavorList = Arrays.asList(object);
        object = element.getAttribute("alignment");
        this.horizontalComponentAlignment = ((String)object).equals("left") ? 0.0f : (((String)object).equals("right") ? 1.0f : 0.5f);
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("label");
        this.setDirection(Orientation.VERTICAL);
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        if (string2.equals("")) {
            this.setLabel(string);
        } else {
            this.setLabel(string2);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element) {
                JComponent jComponent;
                String string3 = node.getNodeName();
                if (string3.equals("panel")) {
                    try {
                        jComponent = new FormPanel((Element)node, formBase);
                        this.add(jComponent);
                    }
                    catch (ParseException parseException) {
                        DasExceptionHandler.handle(parseException);
                    }
                } else if (string3.equals("text") || string3.equals("info")) {
                    jComponent = new FormText((Element)node);
                    this.add(jComponent);
                } else if (string3.equals("textfield")) {
                    jComponent = new FormTextField((Element)node, formBase);
                    this.add(jComponent);
                } else if (string3.equals("button")) {
                    jComponent = new FormButton((Element)node, formBase);
                    this.add(jComponent);
                } else if (string3.equals("checkbox")) {
                    jComponent = new FormCheckBox((Element)node, formBase);
                    this.add(jComponent);
                } else if (string3.equals("list")) {
                    jComponent = new FormList((Element)node, formBase);
                    this.add(jComponent);
                } else if (string3.equals("choice")) {
                    jComponent = new FormChoice((Element)node, formBase);
                    this.add(jComponent);
                } else if (string3.equals("glue")) {
                    this.add(formBase.processGlueElement((Element)node));
                } else if (string3.equals("buttongroup")) {
                    this.add(new FormRadioButtonGroup((Element)node, formBase));
                } else if (string3.equals("canvas")) {
                    try {
                        jComponent = DasCanvas.processCanvasElement((Element)node, formBase);
                        jComponent.setAlignmentX(this.horizontalComponentAlignment);
                        this.add(jComponent);
                    }
                    catch (DasException dasException) {
                        DasExceptionHandler.handle(dasException);
                    }
                    catch (ParseException parseException) {
                        DasExceptionHandler.handle(parseException);
                    }
                }
            }
            ++n2;
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(this, null);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        FormBase formBase = this.getForm();
        if (formBase != null) {
            formBase.setTitleAt(this.getForm().indexOfComponent(this), string);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("form");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("label", this.getLabel());
        int n = 0;
        while (n < this.getComponentCount()) {
            Element element2;
            FormComponent formComponent;
            Component component = this.getComponent(n);
            if (component instanceof FormComponent) {
                formComponent = (FormComponent)((Object)component);
                element2 = formComponent.getDOMElement(document);
                element.appendChild(element2);
            } else if (component instanceof DasCanvas) {
                formComponent = (DasCanvas)component;
                element2 = ((DasCanvas)formComponent).getDOMElement(document);
                element.appendChild(element2);
            }
            ++n;
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(this, null);
        }
        return this.dndSupport;
    }

    public void deregisterComponent() {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            try {
                if (nameContext.get(this.getDasName()) == this) {
                    nameContext.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dasPropertyException) {
                IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                illegalStateException.initCause(dasPropertyException);
                throw illegalStateException;
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                illegalStateException.initCause(invocationTargetException);
                throw illegalStateException;
            }
        }
        super.deregisterComponent();
    }

    public final DasApplication getDasApplication() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            NameContext nameContext = dasApplication.getNameContext();
            nameContext.put(this.getDasName(), this);
        }
        super.registerComponent();
    }
}

