/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dasml;

import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.DataFormatException;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedExpression {
    private static final Pattern SIMPLE_NAME_PATTERN = Pattern.compile("[A-Za-z_][A-Za-z0-9_-]*");
    private static final Pattern INT_PATTERN = Pattern.compile("-?(0|[1-9][0-9]*)");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("-?[0-9]*(\\.[0-9]*)?([eE]-?[0-9]+)?");
    private static final Pattern PAREN_PATTERN = Pattern.compile("\\(([^\\(\\)])\\)");
    private static final Pattern EQUALITY_PATTERN = Pattern.compile("\\b(eq|ne)\\b");
    private static final Pattern COMPARISON_PATTERN = Pattern.compile("\\b(lt|le|gt|ge)\\b");
    private static final Pattern OR_PATTERN = Pattern.compile("\\bor\\b");
    private static final Pattern AND_PATTERN = Pattern.compile("\\band\\b");
    private static final Pattern NOT_PATTERN = Pattern.compile("\\Anot\\b");
    static final int ID_LOAD = 0;
    static final int ID_ALOAD = 1;
    static final int ID_STORE = 2;
    static final int ID_ASTORE = 3;
    static final int ID_ADD = 4;
    static final int ID_SUBTRACT = 5;
    static final int ID_MULTIPLY = 6;
    static final int ID_DIVIDE = 7;
    static final int ID_NEGATE = 8;
    static final int ID_EQ = 9;
    static final int ID_NE = 10;
    static final int ID_GT = 11;
    static final int ID_LT = 12;
    static final int ID_GE = 13;
    static final int ID_LE = 14;
    static final int ID_OR = 15;
    static final int ID_AND = 16;
    static final int ID_NOT = 17;
    private List list;
    private String expression;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;

    public ParsedExpression(String string) throws ParsedExpressionException {
        this.expression = string;
        this.list = new LinkedList();
        if (!ParsedExpression.parseExpression(string, this.list)) {
            throw new ParsedExpressionException("Invalid expression");
        }
    }

    public String toString() {
        return this.expression;
    }

    private static boolean parseExpression(String string, List list) {
        return ParsedExpression.parseOrExpression(string, list);
    }

    private static boolean parseOrExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        Matcher matcher = OR_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = string.substring(matcher.end()).trim();
            String string3 = string.substring(0, matcher.start()).trim();
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            if (!ParsedExpression.parseAndExpression(string2, linkedList2) || !ParsedExpression.parseOrExpression(string3, linkedList)) continue;
            list.addAll(linkedList);
            list.addAll(linkedList2);
            list.add(Op.OR);
            return true;
        }
        return ParsedExpression.parseAndExpression(string, list);
    }

    private static boolean parseAndExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        Matcher matcher = AND_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = string.substring(matcher.end()).trim();
            String string3 = string.substring(0, matcher.start()).trim();
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            if (!ParsedExpression.parseNotExpression(string2, linkedList2) || !ParsedExpression.parseAndExpression(string3, linkedList)) continue;
            list.addAll(linkedList);
            list.addAll(linkedList2);
            list.add(Op.AND);
            return true;
        }
        return ParsedExpression.parseNotExpression(string, list);
    }

    private static boolean parseNotExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        Matcher matcher = NOT_PATTERN.matcher(string);
        if (matcher.find()) {
            LinkedList linkedList;
            String string2 = string.substring(matcher.end()).trim();
            if (ParsedExpression.parseEqualityExpression(string2, linkedList = new LinkedList())) {
                list.addAll(linkedList);
                list.add(Op.NOT);
                return true;
            }
            return false;
        }
        return ParsedExpression.parseEqualityExpression(string, list);
    }

    private static boolean parseEqualityExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        Matcher matcher = EQUALITY_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = string.substring(matcher.end()).trim();
            String string3 = string.substring(0, matcher.start()).trim();
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            if (!ParsedExpression.parseRelationalExpression(string2, linkedList2) || !ParsedExpression.parseEqualityExpression(string3, linkedList)) continue;
            list.addAll(linkedList);
            list.addAll(linkedList2);
            String string4 = matcher.group(1);
            if (string4.equals("eq")) {
                list.add(Op.EQ);
            } else {
                list.add(Op.NE);
            }
            return true;
        }
        return ParsedExpression.parseRelationalExpression(string, list);
    }

    private static boolean parseRelationalExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        Matcher matcher = COMPARISON_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = string.substring(matcher.end()).trim();
            String string3 = string.substring(0, matcher.start()).trim();
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            if (!ParsedExpression.parseAdditiveExpression(string2, linkedList2) || !ParsedExpression.parseRelationalExpression(string3, linkedList)) continue;
            list.addAll(linkedList);
            list.addAll(linkedList2);
            String string4 = matcher.group(1);
            if (string4.equals("lt")) {
                list.add(Op.LT);
            } else if (string4.equals("le")) {
                list.add(Op.LE);
            } else if (string4.equals("gt")) {
                list.add(Op.GT);
            } else {
                list.add(Op.GE);
            }
            return true;
        }
        return ParsedExpression.parseAdditiveExpression(string, list);
    }

    private static boolean parseAdditiveExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        int n = Math.max(string.lastIndexOf(43), string.lastIndexOf(45));
        while (n >= 0) {
            String string2 = string.substring(n + 1).trim();
            String string3 = string.substring(0, n).trim();
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            if (ParsedExpression.parseMultiplicativeExpression(string2, linkedList2) && ParsedExpression.parseAdditiveExpression(string3, linkedList)) {
                list.addAll(linkedList);
                list.addAll(linkedList2);
                list.add(string.charAt(n) == '+' ? Op.ADD : Op.SUBTRACT);
                return true;
            }
            n = Math.max(string.lastIndexOf(43, n - 1), string.lastIndexOf(45, n - 1));
        }
        return ParsedExpression.parseMultiplicativeExpression(string, list);
    }

    private static boolean parseMultiplicativeExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        int n = Math.max(string.lastIndexOf(42), string.lastIndexOf(47));
        while (n >= 0) {
            String string2 = string.substring(n + 1).trim();
            String string3 = string.substring(0, n).trim();
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            if (!ParsedExpression.parseUnaryExpression(string2, linkedList2) || !ParsedExpression.parseMultiplicativeExpression(string3, linkedList)) continue;
            list.addAll(linkedList);
            list.addAll(linkedList2);
            list.add(string.charAt(n) == '*' ? Op.MULTIPLY : Op.DIVIDE);
            return true;
        }
        return ParsedExpression.parseUnaryExpression(string, list);
    }

    private static boolean parseUnaryExpression(String string, List list) {
        return ParsedExpression.parseNegateExpression(string, list);
    }

    private static boolean parseNegateExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        if (string.charAt(0) == '-') {
            LinkedList linkedList = new LinkedList();
            boolean bl = ParsedExpression.parseSimpleExpression(string.substring(1).trim(), linkedList);
            if (bl) {
                list.addAll(linkedList);
                list.add(Op.NEGATE);
                return true;
            }
            return false;
        }
        return ParsedExpression.parseSimpleExpression(string, list);
    }

    private static boolean parseSimpleExpression(String string, List list) {
        if (string.length() < 1) {
            return false;
        }
        if (string.startsWith("(") && string.endsWith(")")) {
            LinkedList linkedList = new LinkedList();
            boolean bl = ParsedExpression.parseExpression(string.substring(1, string.length() - 1).trim(), linkedList);
            if (bl) {
                list.addAll(linkedList);
                return true;
            }
            return false;
        }
        if (string.startsWith("${") && string.endsWith("}")) {
            LinkedList linkedList = new LinkedList();
            boolean bl = ParsedExpression.parseArrayAccess(string.substring(2, string.length() - 1).trim(), linkedList);
            if (bl) {
                list.addAll(linkedList);
            }
            return bl;
        }
        Matcher matcher = INT_PATTERN.matcher(string);
        if (matcher.matches()) {
            list.add(new Integer(string));
            return true;
        }
        matcher = FLOAT_PATTERN.matcher(string);
        if (matcher.matches()) {
            list.add(new Double(string));
            return true;
        }
        if (string.equals("true")) {
            list.add(Boolean.TRUE);
            return true;
        }
        if (string.equals("false")) {
            list.add(Boolean.FALSE);
            return true;
        }
        return false;
    }

    private static boolean parseArrayAccess(String string, List list) {
        if ((string = string.trim()).length() < 1) {
            return false;
        }
        if (SIMPLE_NAME_PATTERN.matcher(string).matches()) {
            list.add(null);
            list.add(string);
            list.add(Op.LOAD);
            return true;
        }
        if (string.charAt(string.length() - 1) == ']') {
            int n = string.lastIndexOf(91);
            while (n >= 0) {
                boolean bl;
                int n2 = string.lastIndexOf(46, n);
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1, n).trim();
                String string4 = string.substring(n + 1, string.length() - 2).trim();
                if (!SIMPLE_NAME_PATTERN.matcher(string3).matches()) {
                    return false;
                }
                LinkedList linkedList = new LinkedList();
                LinkedList linkedList2 = new LinkedList();
                boolean bl2 = ParsedExpression.parseExpression(string4, linkedList2);
                if (!bl2 || !(bl = ParsedExpression.parseArrayAccess(string2, linkedList))) continue;
                list.addAll(linkedList);
                list.addAll(linkedList2);
                list.add(Op.ALOAD);
                return true;
            }
        } else {
            int n = string.lastIndexOf(46);
            while (n > 0) {
                String string5 = string.substring(0, n);
                String string6 = string.substring(n + 1);
                if (!SIMPLE_NAME_PATTERN.matcher(string6).matches()) {
                    return false;
                }
                LinkedList linkedList = new LinkedList();
                boolean bl = ParsedExpression.parseArrayAccess(string5, linkedList);
                if (!bl) continue;
                list.addAll(linkedList);
                list.add(string6);
                list.add(Op.LOAD);
                return true;
            }
        }
        return false;
    }

    public Object evaluate(NameContext nameContext) throws ParsedExpressionException, DasPropertyException {
        try {
            return ParsedExpression.evaluate(this.list, nameContext);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof DataFormatException) {
                ParsedExpressionException parsedExpressionException = new ParsedExpressionException(throwable.getMessage());
                parsedExpressionException.initCause(throwable);
                throw parsedExpressionException;
            }
            throw new RuntimeException(invocationTargetException);
        }
    }

    private static Object evaluate(List list, NameContext nameContext) throws ParsedExpressionException, InvocationTargetException, DasPropertyException {
        if (list.size() == 0) {
            throw new RuntimeException("empty expression");
        }
        if (list.size() == 1 && !(list.get(0) instanceof Op)) {
            return list.get(0);
        }
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Op) {
                Op op = (Op)e;
                ParsedExpression.evaluate(arrayList, op.id, nameContext);
                continue;
            }
            ParsedExpression.push(arrayList, e);
        }
        if (arrayList.size() != 1) {
            throw new IllegalArgumentException("Invalid expression: " + list);
        }
        return ParsedExpression.pop(arrayList);
    }

    private static void evaluate(List list, int n, NameContext nameContext) throws InvocationTargetException, ParsedExpressionException, DasPropertyException {
        switch (n) {
            case 0: {
                ParsedExpression.load(list, nameContext);
                break;
            }
            case 1: {
                ParsedExpression.aload(list, nameContext);
                break;
            }
            case 2: {
                ParsedExpression.store(list, nameContext);
                break;
            }
            case 3: {
                ParsedExpression.astore(list, nameContext);
                break;
            }
            case 8: {
                ParsedExpression.negate(list);
                break;
            }
            case 4: {
                ParsedExpression.add(list);
                break;
            }
            case 5: {
                ParsedExpression.subtract(list);
                break;
            }
            case 6: {
                ParsedExpression.multiply(list);
                break;
            }
            case 7: {
                ParsedExpression.divide(list);
                break;
            }
            case 9: {
                ParsedExpression.eq(list);
                break;
            }
            case 10: {
                ParsedExpression.ne(list);
                break;
            }
            case 11: {
                ParsedExpression.gt(list);
                break;
            }
            case 12: {
                ParsedExpression.lt(list);
                break;
            }
            case 13: {
                ParsedExpression.ge(list);
                break;
            }
            case 14: {
                ParsedExpression.le(list);
                break;
            }
            case 15: {
                ParsedExpression.or(list);
                break;
            }
            case 16: {
                ParsedExpression.and(list);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static Object pop(List list) {
        return list.remove(list.size() - 1);
    }

    private static Boolean popBoolean(List list) {
        return (Boolean)list.remove(list.size() - 1);
    }

    private static String popString(List list) {
        return (String)list.remove(list.size() - 1);
    }

    private static Integer popInteger(List list) {
        return (Integer)list.remove(list.size() - 1);
    }

    private static Double popDouble(List list) {
        return (Double)list.remove(list.size() - 1);
    }

    private static Number popNumber(List list) {
        return (Number)list.remove(list.size() - 1);
    }

    private static Comparable popComparable(List list) {
        return (Comparable)list.remove(list.size() - 1);
    }

    private static void push(List list, Object object) {
        list.add(object);
    }

    private static Class widest(Class clazz, Class clazz2) {
        if (clazz.getSuperclass() != (class$java$lang$Number == null ? (class$java$lang$Number = ParsedExpression.class$("java.lang.Number")) : class$java$lang$Number) || clazz2.getSuperclass() != (class$java$lang$Number == null ? (class$java$lang$Number = ParsedExpression.class$("java.lang.Number")) : class$java$lang$Number)) {
            throw new IllegalArgumentException("(" + clazz.getName() + ", " + clazz2.getName());
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) || clazz2 == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) || clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float)) {
            return class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short;
        }
        return class$java$lang$Byte == null ? (class$java$lang$Byte = ParsedExpression.class$("java.lang.Byte")) : class$java$lang$Byte;
    }

    private static void load(List list, NameContext nameContext) throws DasPropertyException, InvocationTargetException, ParsedExpressionException {
        String string = ParsedExpression.popString(list);
        Object object = ParsedExpression.pop(list);
        Object object2 = object == null ? nameContext.get(string) : nameContext.getPropertyValue(object, string);
        ParsedExpression.push(list, object2);
    }

    private static void aload(List list, NameContext nameContext) throws DasPropertyException, InvocationTargetException, ParsedExpressionException {
        Integer n = ParsedExpression.popInteger(list);
        String string = ParsedExpression.popString(list);
        Object object = ParsedExpression.pop(list);
        ParsedExpression.push(list, nameContext.getIndexedPropertyValue(object, string, n));
    }

    private static void store(List list, NameContext nameContext) throws DasPropertyException, InvocationTargetException, ParsedExpressionException {
        Object object = ParsedExpression.pop(list);
        String string = ParsedExpression.popString(list);
        Object object2 = ParsedExpression.pop(list);
        nameContext.setPropertyValue(object2, string, object);
    }

    private static void astore(List list, NameContext nameContext) throws DasPropertyException, InvocationTargetException, ParsedExpressionException {
        Object object = ParsedExpression.pop(list);
        Integer n = ParsedExpression.popInteger(list);
        String string = ParsedExpression.popString(list);
        Object object2 = ParsedExpression.pop(list);
        nameContext.setIndexedPropertyValue(object2, string, n, object);
    }

    private static void negate(List list) {
        Double d = ParsedExpression.popDouble(list);
        ParsedExpression.push(list, new Double(-d.doubleValue()));
    }

    private static void add(List list) {
        Number number = ParsedExpression.popNumber(list);
        Number number2 = ParsedExpression.popNumber(list);
        Class clazz = ParsedExpression.widest(number2.getClass(), number.getClass());
        Number number3 = clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) ? (Number)new Double(number2.doubleValue() + number.doubleValue()) : (Number)(clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(number2.floatValue() + number.floatValue()) : (Number)(clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(number2.longValue() + number.longValue()) : (Number)(clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(number2.intValue() + number.intValue()) : (Number)(clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short((short)(number2.shortValue() + number.shortValue())) : (Number)new Byte((byte)(number2.byteValue() + number.byteValue()))))));
        ParsedExpression.push(list, number3);
    }

    private static void subtract(List list) {
        Number number = ParsedExpression.popNumber(list);
        Number number2 = ParsedExpression.popNumber(list);
        Class clazz = ParsedExpression.widest(number2.getClass(), number.getClass());
        Number number3 = clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) ? (Number)new Double(number2.doubleValue() - number.doubleValue()) : (Number)(clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(number2.floatValue() - number.floatValue()) : (Number)(clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(number2.longValue() - number.longValue()) : (Number)(clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(number2.intValue() - number.intValue()) : (Number)(clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short((short)(number2.shortValue() - number.shortValue())) : (Number)new Byte((byte)(number2.byteValue() - number.byteValue()))))));
        ParsedExpression.push(list, number3);
    }

    private static void multiply(List list) {
        Number number = ParsedExpression.popNumber(list);
        Number number2 = ParsedExpression.popNumber(list);
        Class clazz = ParsedExpression.widest(number2.getClass(), number.getClass());
        Number number3 = clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) ? (Number)new Double(number2.doubleValue() * number.doubleValue()) : (Number)(clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(number2.floatValue() * number.floatValue()) : (Number)(clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(number2.longValue() * number.longValue()) : (Number)(clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(number2.intValue() * number.intValue()) : (Number)(clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short((short)(number2.shortValue() * number.shortValue())) : (Number)new Byte((byte)(number2.byteValue() * number.byteValue()))))));
        ParsedExpression.push(list, number3);
    }

    private static void divide(List list) {
        Number number = ParsedExpression.popNumber(list);
        Number number2 = ParsedExpression.popNumber(list);
        Class clazz = ParsedExpression.widest(number2.getClass(), number.getClass());
        Number number3 = clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ParsedExpression.class$("java.lang.Double")) : class$java$lang$Double) ? (Number)new Double(number2.doubleValue() / number.doubleValue()) : (Number)(clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ParsedExpression.class$("java.lang.Float")) : class$java$lang$Float) ? (Number)new Float(number2.floatValue() / number.floatValue()) : (Number)(clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ParsedExpression.class$("java.lang.Long")) : class$java$lang$Long) ? (Number)new Long(number2.longValue() / number.longValue()) : (Number)(clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ParsedExpression.class$("java.lang.Integer")) : class$java$lang$Integer) ? (Number)new Integer(number2.intValue() / number.intValue()) : (Number)(clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ParsedExpression.class$("java.lang.Short")) : class$java$lang$Short) ? (Number)new Short((short)(number2.shortValue() / number.shortValue())) : (Number)new Byte((byte)(number2.byteValue() / number.byteValue()))))));
        ParsedExpression.push(list, number3);
    }

    private static void eq(List list) {
        Object object = ParsedExpression.pop(list);
        Object object2 = ParsedExpression.pop(list);
        Boolean bl = object2 == object || object2 != null && object2.equals(object) ? Boolean.TRUE : Boolean.FALSE;
        ParsedExpression.push(list, bl);
    }

    private static void ne(List list) {
        Object object = ParsedExpression.pop(list);
        Object object2 = ParsedExpression.pop(list);
        ParsedExpression.push(list, object2 == object || object2 != null && object2.equals(object));
    }

    private static void gt(List list) {
        Comparable comparable = ParsedExpression.popComparable(list);
        Comparable comparable2 = ParsedExpression.popComparable(list);
        ParsedExpression.push(list, comparable2.compareTo(comparable) > 0);
    }

    private static void lt(List list) {
        Comparable comparable = ParsedExpression.popComparable(list);
        Comparable comparable2 = ParsedExpression.popComparable(list);
        ParsedExpression.push(list, comparable2.compareTo(comparable) < 0);
    }

    private static void ge(List list) {
        Comparable comparable = ParsedExpression.popComparable(list);
        Comparable comparable2 = ParsedExpression.popComparable(list);
        ParsedExpression.push(list, comparable2.compareTo(comparable) >= 0);
    }

    private static void le(List list) {
        Comparable comparable = ParsedExpression.popComparable(list);
        Comparable comparable2 = ParsedExpression.popComparable(list);
        ParsedExpression.push(list, comparable2.compareTo(comparable) <= 0);
    }

    private static void or(List list) {
        Boolean bl = ParsedExpression.popBoolean(list);
        Boolean bl2 = ParsedExpression.popBoolean(list);
        ParsedExpression.push(list, bl2 != false || bl != false);
    }

    private static void and(List list) {
        Boolean bl = ParsedExpression.popBoolean(list);
        Boolean bl2 = ParsedExpression.popBoolean(list);
        ParsedExpression.push(list, bl2 != false && bl != false);
    }

    private static void not(List list) {
        Boolean bl = ParsedExpression.popBoolean(list);
        ParsedExpression.push(list, bl == false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Op {
        static final Op LOAD = new Op(0);
        static final Op ALOAD = new Op(1);
        static final Op STORE = new Op(2);
        static final Op ADD = new Op(4);
        static final Op SUBTRACT = new Op(5);
        static final Op MULTIPLY = new Op(6);
        static final Op DIVIDE = new Op(7);
        static final Op NEGATE = new Op(8);
        static final Op EQ = new Op(9);
        static final Op NE = new Op(10);
        static final Op GT = new Op(11);
        static final Op LT = new Op(12);
        static final Op GE = new Op(13);
        static final Op LE = new Op(14);
        static final Op OR = new Op(15);
        static final Op AND = new Op(16);
        static final Op NOT = new Op(17);
        int id;

        private Op(int n) {
            this.id = n;
        }
    }
}

