/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.util.DasDie;

public class DataSetCache {
    protected Tag[] buffer = new Tag[1];
    private boolean enabled = true;
    public int hits = 0;
    public int misses = 0;

    public void store(DataSetDescriptor dataSetDescriptor, Datum datum, Datum datum2, Datum datum3, DataSet dataSet) {
        if (!this.enabled) {
            return;
        }
        Tag tag = new Tag(dataSetDescriptor, datum, datum2, datum3, dataSet);
        int n = -1;
        int n2 = this.buffer.length - 1;
        while (n2 >= 0) {
            if (this.buffer[n2] == null) {
                n = n2;
            }
            --n2;
        }
        if (n == -1) {
            long l = Long.MAX_VALUE;
            int n3 = -1;
            int n4 = this.buffer.length - 1;
            while (n4 >= 0) {
                if (this.buffer[n4].lastAccess < l) {
                    n3 = n4;
                    l = this.buffer[n4].lastAccess;
                }
                --n4;
            }
            n = n3;
        }
        this.buffer[n] = tag;
    }

    int findStored(DataSetDescriptor dataSetDescriptor, Datum datum, Datum datum2, Datum datum3) {
        Tag tag = new Tag(dataSetDescriptor, datum, datum2, datum3, null);
        int n = -1;
        int n2 = 0;
        while (n2 < this.buffer.length) {
            if (this.buffer[n2] != null && this.buffer[n2].isWithin(tag)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public boolean haveStored(DataSetDescriptor dataSetDescriptor, Datum datum, Datum datum2, Datum datum3) {
        Tag tag = new Tag(dataSetDescriptor, datum, datum2, datum3, null);
        DasDie.println(this.toString());
        DasDie.println("    need: " + tag.toString());
        int n = this.findStored(dataSetDescriptor, datum, datum2, datum3);
        if (n != -1) {
            ++this.hits;
            return true;
        }
        ++this.misses;
        return false;
    }

    public DataSet retrieve(DataSetDescriptor dataSetDescriptor, Datum datum, Datum datum2, Datum datum3) {
        int n = this.findStored(dataSetDescriptor, datum, datum2, datum3);
        if (n != -1) {
            DasDie.println(" time offset= " + this.buffer[n].start.subtract(datum));
            ++this.buffer[n].nhits;
            this.buffer[n].lastAccess = System.currentTimeMillis();
            return this.buffer[n].data;
        }
        throw new IllegalArgumentException("Data not found in buffer");
    }

    public void reset() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = null;
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.reset();
        }
    }

    public double calcHitRate() {
        return (double)this.hits * 100.0 / (double)(this.hits + this.misses);
    }

    public String toString() {
        String string = "\n---DataSetCache---\n";
        int n = 0;
        while (n < this.buffer.length) {
            string = string + "Buffer " + n + ": ";
            string = this.buffer[n] != null ? string + this.buffer[n].toString() : string + "";
            string = string + "\n";
            ++n;
        }
        string = string + "-------------------";
        return string;
    }

    protected class Tag {
        protected DataSetDescriptor dsd;
        protected Datum start;
        protected Datum end;
        protected Datum resolution;
        protected DataSet data;
        protected int nhits;
        protected long birthTime;
        protected long lastAccess;

        Tag() {
            this(null, null, null, null, null);
        }

        Tag(DataSetDescriptor dataSetDescriptor, Datum datum, Datum datum2, Datum datum3, DataSet dataSet) {
            this.dsd = dataSetDescriptor;
            this.start = datum;
            this.end = datum2;
            this.resolution = datum3;
            this.data = dataSet;
            this.nhits = 0;
            this.lastAccess = this.birthTime = System.currentTimeMillis();
        }

        public DataSet getData() {
            return this.data;
        }

        protected boolean isWithin(Tag tag) {
            boolean bl = this.dsd != null && tag.dsd != null;
            bl = bl && tag.dsd.toString().equals(this.dsd.toString());
            bl = bl && tag.start.compareTo(this.start) >= 0 && tag.end.compareTo(this.end) <= 0;
            bl = bl && tag.resolution.ge(this.resolution);
            return bl;
        }

        public String toString() {
            return this.dsd.toString() + " " + this.start.toString() + " - " + this.end.toString() + " @ " + this.resolution + "s  [" + this.nhits + " hits]";
        }
    }
}

