/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.dataset.AbstractDataSet;
import edu.uiowa.physics.pw.das.dataset.AbstractTableDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public final class DefaultTableDataSet
extends AbstractTableDataSet {
    private double[][][] tableData;
    private Units[] zUnits;
    private double[][] yTags;
    private int[] tableOffsets;
    private String[] planeIDs;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet;

    public DefaultTableDataSet(double[] dArray, Units units, double[][] dArray2, Units units2, double[][][] dArray3, Units units3, Map map, Map map2, Map map3) {
        super(dArray, units, units2, units3, map3);
        if (map == null ^ map2 == null) {
            throw new IllegalArgumentException("zValuesMap == null ^ zUnitsMap == null");
        }
        if (map != null && !map.keySet().equals(map2.keySet())) {
            throw new IllegalArgumentException("mismatched keySets for zValuesMap and zUnitsMap");
        }
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof String) continue;
                throw new IllegalArgumentException("Non-String key found in zValuesMap");
            }
        }
        int n = 1 + (map == null ? 0 : map.size());
        this.tableData = new double[n][][];
        this.tableData[0] = this.flatten(dArray3);
        this.yTags = DefaultTableDataSet.copy(dArray2);
        this.zUnits = new Units[n];
        this.zUnits[0] = units3;
        this.planeIDs = new String[n];
        this.planeIDs[0] = "";
        this.tableOffsets = DefaultTableDataSet.computeTableOffsets(dArray3, dArray2);
        if (map != null) {
            int n2 = 1;
            Iterator iterator = new TreeMap(map).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                double[][][] dArray4 = (double[][][])entry.getValue();
                double[][] dArray5 = this.flatten(dArray4);
                this.planeIDs[n2] = string;
                this.tableData[n2] = dArray5;
                this.zUnits[n2] = (Units)map2.get(string);
            }
        }
    }

    private double[][] flatten(double[][][] dArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            n += dArray[n2].length;
            ++n2;
        }
        double[][] dArrayArray = new double[n][];
        int n3 = 0;
        int n4 = 0;
        while (n4 < dArray.length) {
            int n5 = 0;
            while (n5 < dArray[n4].length) {
                dArrayArray[n3] = (double[])dArray[n4][n5].clone();
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return dArrayArray;
    }

    public static DefaultTableDataSet createSimple(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray3.length;
        int n2 = dArray3[0].length;
        if (dArray.length != n) {
            throw new IllegalArgumentException("xTags (" + dArray.length + ") don't match zValues' first dimension (" + n + "," + n2 + ").");
        }
        if (dArray2.length != n2) {
            throw new IllegalArgumentException("yTags (" + dArray2.length + ") don't match zValues' first dimension (" + n + "," + n2 + ").");
        }
        return new DefaultTableDataSet(dArray, Units.dimensionless, dArray2, Units.dimensionless, dArray3, Units.dimensionless, new HashMap());
    }

    public DefaultTableDataSet(double[] dArray, Units units, double[] dArray2, Units units2, double[][] dArray3, Units units3, Map map) {
        this(dArray, units, (double[][])new double[][]{dArray2}, units2, (double[][][])new double[][][]{dArray3}, units3, null, null, map);
    }

    DefaultTableDataSet(double[] dArray, Units units, double[][] dArray2, Units units2, double[][][] dArray3, Units[] unitsArray, String[] stringArray, int[] nArray, Map map) {
        super(dArray, units, units2, unitsArray[0], map);
        this.yTags = dArray2;
        this.tableData = dArray3;
        this.zUnits = unitsArray;
        this.planeIDs = stringArray;
        this.tableOffsets = nArray;
    }

    private static double[][][] copy(double[][][] dArray) {
        double[][][] dArrayArray = new double[dArray.length][][];
        int n = 0;
        while (n < dArray.length) {
            dArrayArray[n] = DefaultTableDataSet.copy(dArray[n]);
            ++n;
        }
        return dArrayArray;
    }

    private static double[][] copy(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArrayArray[n] = (double[])dArray[n].clone();
            ++n;
        }
        return dArrayArray;
    }

    private static int[] computeTableOffsets(double[][][] dArray, double[][] dArray2) {
        int[] nArray = new int[dArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n;
            n += dArray[n2].length;
            ++n2;
        }
        return nArray;
    }

    public Datum getDatum(int n, int n2) {
        int n3 = this.tableOfIndex(n);
        int n4 = this.yTags[n3].length;
        if (n < 0 || n >= this.tableData[0].length) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("x index is out of bounds: " + n + " xLength: " + this.getXLength());
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing((class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet == null ? (class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet = DefaultTableDataSet.class$("edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet")) : class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet).getName(), "getDatum(int,int)", indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n2 < 0 || n2 >= this.yTags[n3].length) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("y index is out of bounds: " + n + " yLength(" + n3 + "): " + this.getYLength(n3));
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing((class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet == null ? (class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet = DefaultTableDataSet.class$("edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet")) : class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet).getName(), "getDatum(int,int)", indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        double d = this.tableData[0][n][n2];
        return Datum.create(d, this.zUnits[0]);
    }

    public DatumVector getScan(int n) {
        int n2 = this.tableOfIndex(n);
        if (n < 0 || n >= this.tableData[0].length) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("x index is out of bounds: " + n + " xLength: " + this.getXLength());
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.throwing((class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet == null ? (class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet = DefaultTableDataSet.class$("edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet")) : class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet).getName(), "getDatum(int,int)", indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        double[] dArray = this.tableData[0][n];
        return DatumVector.newDatumVector(dArray, 0, this.getYLength(n2), this.zUnits[0]);
    }

    public double getDouble(int n, int n2, Units units) {
        int n3 = this.tableOfIndex(n);
        int n4 = this.yTags[n3].length;
        double d = this.tableData[0][n][n2];
        if (units == this.getZUnits()) {
            return d;
        }
        return this.zUnits[0].getConverter(units).convert(d);
    }

    public double[] getDoubleScan(int n, Units units) {
        int n2 = this.tableOfIndex(n);
        int n3 = this.yTags[n2].length;
        double[] dArray = this.tableData[0][n];
        double[] dArray2 = new double[n3];
        if (units == this.getZUnits()) {
            System.arraycopy(dArray, 0, dArray2, 0, n3);
        } else {
            UnitsConverter unitsConverter = this.zUnits[0].getConverter(units);
            int n4 = 0;
            while (n4 < n3) {
                dArray2[n4] = unitsConverter.convert(dArray[n4]);
                ++n4;
            }
        }
        return dArray2;
    }

    public int getInt(int n, int n2, Units units) {
        return (int)Math.round(this.getDouble(n, n2, units));
    }

    public DataSet getPlanarView(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.planeIDs.length) {
            if (this.planeIDs[n2].equals(string)) {
                n = n2;
            }
            ++n2;
        }
        if (n == -1) {
            return null;
        }
        return new PlanarViewDataSet(n);
    }

    public int getYLength(int n) {
        return this.yTags[n].length;
    }

    public Datum getYTagDatum(int n, int n2) {
        double d = this.yTags[n][n2];
        return Datum.create(d, this.getYUnits());
    }

    public double getYTagDouble(int n, int n2, Units units) {
        double d = this.yTags[n][n2];
        if (units == this.getYUnits()) {
            return d;
        }
        return this.getYUnits().getConverter(units).convert(d);
    }

    public int getYTagInt(int n, int n2, Units units) {
        return (int)Math.round(this.getYTagDouble(n, n2, units));
    }

    public DatumVector getYTags(int n) {
        return DatumVector.newDatumVector(this.yTags[n], 0, this.getYLength(n), this.getYUnits());
    }

    public int tableCount() {
        return this.yTags.length;
    }

    public int tableEnd(int n) {
        if (n == this.tableOffsets.length - 1) {
            return this.getXLength();
        }
        return this.tableOffsets[n + 1];
    }

    public int tableOfIndex(int n) {
        int n2 = Arrays.binarySearch(this.tableOffsets, n);
        if (n >= this.getXLength()) {
            throw new IndexOutOfBoundsException(n + " > " + this.getXLength());
        }
        if (n2 < 0) {
            n2 = ~n2 - 1;
        }
        return n2;
    }

    public int tableStart(int n) {
        return this.tableOffsets[n];
    }

    public void dump(PrintStream printStream) {
        MessageFormat messageFormat = new MessageFormat("        {0,number,00}. Y Length: {1,number,000}, Start: {2,number,000}, End: {3,number,000}");
        MessageFormat messageFormat2 = new MessageFormat("        ID: {0}, Z Units: ''{1}''");
        printStream.println("============================================================");
        printStream.println(this.getClass().getName());
        printStream.println("    X Length:    " + this.getXLength());
        printStream.println("    X Units:     '" + this.getXUnits() + "'");
        printStream.print("    X Tags:");
        int n = 0;
        while (n < this.getXLength()) {
            printStream.print(" ");
            printStream.print(this.getXTagDouble(n, this.getXUnits()));
            ++n;
        }
        printStream.println();
        printStream.println("    Y Units:     '" + this.getYUnits() + "'");
        printStream.println("    Z Units:     '" + this.getZUnits() + "'");
        printStream.println("    Table Count: " + this.tableCount());
        Object[] objectArray = new Object[4];
        int n2 = 0;
        while (n2 < this.tableCount()) {
            objectArray[0] = new Integer(n2);
            objectArray[1] = new Integer(this.yTags[n2].length);
            objectArray[2] = new Integer(this.tableStart(n2));
            objectArray[3] = new Integer(this.tableEnd(n2));
            String string = messageFormat.format(objectArray);
            printStream.println(string);
            printStream.print("        Y Tags:");
            int n3 = 0;
            while (n3 < this.getYLength(n2)) {
                printStream.print(" ");
                printStream.print(this.getYTagDouble(n2, n3, this.getXUnits()));
                ++n3;
            }
            printStream.println();
            printStream.println("        Z Values:");
            int n4 = 0;
            while (n4 < this.getYLength(n2)) {
                printStream.print("        ");
                int n5 = this.tableStart(n2);
                while (n5 < this.tableEnd(n2)) {
                    printStream.print(this.getDouble(n5, n4, this.getZUnits()));
                    printStream.print("\t");
                    ++n5;
                }
                printStream.println();
                ++n4;
            }
            ++n2;
        }
        printStream.println("    Plane Count: " + this.planeIDs.length);
        int n6 = 1;
        while (n6 < this.planeIDs.length) {
            objectArray[0] = this.planeIDs[n6];
            objectArray[1] = this.zUnits[n6];
            String string = messageFormat2.format(objectArray);
            printStream.println(string);
            ++n6;
        }
        printStream.println("============================================================");
    }

    public String toString() {
        return "DefaultTableDataSet " + TableUtil.toString(this);
    }

    public void printDebugInfo(PrintStream printStream) {
        printStream.println("xLength: " + this.getXLength());
        printStream.println("tableCount: " + this.tableCount());
        int n = 0;
        while (n < this.tableCount()) {
            printStream.println("tableStart(" + n + "): " + this.tableStart(n));
            printStream.println("yLength: " + this.getYLength(n));
            int n2 = this.tableStart(n);
            while (n2 < this.tableEnd(n)) {
                printStream.println(n2 + ": " + this.tableData[0][n2].length);
                ++n2;
            }
            printStream.println("tableEnd(" + n + "): " + this.tableEnd(n));
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PlanarViewDataSet
    extends AbstractDataSet.ViewDataSet
    implements TableDataSet {
        private final int index;

        private PlanarViewDataSet(int n) {
            this.index = n;
        }

        public DataSet getPlanarView(String string) {
            return null;
        }

        public Datum getDatum(int n, int n2) {
            int n3 = this.tableOfIndex(n);
            int n4 = DefaultTableDataSet.this.yTags[n3].length;
            double d = DefaultTableDataSet.this.tableData[this.index][n][n2];
            return Datum.create(d, DefaultTableDataSet.this.zUnits[this.index]);
        }

        public double getDouble(int n, int n2, Units units) {
            int n3 = this.tableOfIndex(n);
            int n4 = DefaultTableDataSet.this.yTags[n3].length;
            double d = DefaultTableDataSet.this.tableData[this.index][n][n2];
            return DefaultTableDataSet.this.zUnits[this.index].getConverter(units).convert(d);
        }

        public double[] getDoubleScan(int n, Units units) {
            int n2 = this.tableOfIndex(n);
            int n3 = DefaultTableDataSet.this.yTags[n2].length;
            double[] dArray = DefaultTableDataSet.this.tableData[this.index][n];
            double[] dArray2 = new double[n3];
            if (units == this.getZUnits()) {
                System.arraycopy(dArray, 0, dArray2, 0, n3);
            } else {
                UnitsConverter unitsConverter = DefaultTableDataSet.this.zUnits[this.index].getConverter(units);
                int n4 = 0;
                while (n4 < n3) {
                    dArray2[n4] = unitsConverter.convert(dArray[n4]);
                    ++n4;
                }
            }
            return dArray2;
        }

        public DatumVector getScan(int n) {
            int n2 = this.tableOfIndex(n);
            if (n < 0 || n >= DefaultTableDataSet.this.tableData[0].length) {
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("x index is out of bounds: " + n + " xLength: " + this.getXLength());
                Logger logger = DasApplication.getDefaultApplication().getLogger();
                logger.throwing((class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet == null ? (class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet = DefaultTableDataSet.class$("edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet")) : class$edu$uiowa$physics$pw$das$dataset$DefaultTableDataSet).getName(), "getDatum(int,int)", indexOutOfBoundsException);
                throw indexOutOfBoundsException;
            }
            double[] dArray = DefaultTableDataSet.this.tableData[this.index][n];
            return DatumVector.newDatumVector(dArray, 0, this.getYLength(n2), DefaultTableDataSet.this.zUnits[this.index]);
        }

        public int getInt(int n, int n2, Units units) {
            return (int)Math.round(this.getDouble(n, n2, units));
        }

        public VectorDataSet getXSlice(int n) {
            return new AbstractTableDataSet.XSliceDataSet(this, n);
        }

        public int getYLength(int n) {
            return DefaultTableDataSet.this.getYLength(n);
        }

        public VectorDataSet getYSlice(int n, int n2) {
            return new AbstractTableDataSet.YSliceDataSet(this, n, n2);
        }

        public Datum getYTagDatum(int n, int n2) {
            return DefaultTableDataSet.this.getYTagDatum(n, n2);
        }

        public double getYTagDouble(int n, int n2, Units units) {
            return DefaultTableDataSet.this.getYTagDouble(n, n2, units);
        }

        public int getYTagInt(int n, int n2, Units units) {
            return DefaultTableDataSet.this.getYTagInt(n, n2, units);
        }

        public Units getZUnits() {
            return DefaultTableDataSet.this.zUnits[this.index];
        }

        public int tableCount() {
            return DefaultTableDataSet.this.tableCount();
        }

        public int tableEnd(int n) {
            return DefaultTableDataSet.this.tableEnd(n);
        }

        public int tableOfIndex(int n) {
            return DefaultTableDataSet.this.tableOfIndex(n);
        }

        public int tableStart(int n) {
            return DefaultTableDataSet.this.tableStart(n);
        }

        public Object getProperty(String string) {
            return DefaultTableDataSet.this.getProperty(DefaultTableDataSet.this.planeIDs[this.index] + "." + string);
        }

        public DatumVector getYTags(int n) {
            return DefaultTableDataSet.this.getYTags(n);
        }
    }
}

