/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

class GapListDouble {
    private static final int INITIAL_ARRAY_SIZE = 128;
    private double[] array = new double[128];
    private int gapStart = 0;
    private int gapEnd = 128;

    GapListDouble() {
    }

    public int add(double d) {
        int n = this.indexOf(d);
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        if (this.isFull()) {
            this.resizeArray();
        }
        if (n != this.gapStart) {
            this.moveGap(n);
        }
        this.array[this.gapStart] = d;
        ++this.gapStart;
        return n;
    }

    public double get(int n) {
        if (n < this.gapStart) {
            return this.array[n];
        }
        return this.array[n + (this.gapEnd - this.gapStart)];
    }

    public int indexOf(double d) {
        if (this.gapStart != 0 && this.array[this.gapStart - 1] >= d) {
            return GapListDouble.binarySearch(d, this.array, 0, this.gapStart);
        }
        if (this.gapEnd != this.array.length && this.array[this.gapEnd] < d) {
            int n = GapListDouble.binarySearch(d, this.array, this.gapEnd, this.array.length);
            if (n >= 0) {
                return n - (this.gapEnd - this.gapStart);
            }
            return ~(~n - (this.gapEnd - this.gapStart));
        }
        return ~this.gapStart;
    }

    public boolean isEmpty() {
        return this.gapStart == 0 && this.gapEnd == this.array.length;
    }

    private boolean isFull() {
        return this.gapStart == this.gapEnd;
    }

    public int size() {
        return this.gapStart + this.array.length - this.gapEnd;
    }

    public double[] toArray() {
        double[] dArray = new double[this.size()];
        System.arraycopy(this.array, 0, dArray, 0, this.gapStart);
        System.arraycopy(this.array, this.gapEnd, dArray, this.gapStart, this.array.length - this.gapEnd);
        return dArray;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = this.size();
        int n2 = 0;
        while (n2 < n - 1) {
            stringBuffer.append(this.get(n2)).append(", ");
            ++n2;
        }
        stringBuffer.append(this.get(n - 1)).append("]");
        return stringBuffer.toString();
    }

    private void resizeArray() {
        double[] dArray = new double[this.array.length << 1];
        System.arraycopy(this.array, 0, dArray, 0, this.gapStart);
        int n = this.array.length - this.gapEnd;
        System.arraycopy(this.array, this.gapEnd, dArray, dArray.length - n, n);
        this.array = dArray;
        this.gapEnd = dArray.length - n;
    }

    private void moveGap(int n) {
        if (n < this.gapStart) {
            int n2 = this.gapStart - n;
            int n3 = this.gapEnd - this.gapStart;
            System.arraycopy(this.array, n, this.array, n + n3, n2);
            this.gapStart = n;
            this.gapEnd = this.gapStart + n3;
        } else if (n > this.gapStart) {
            int n4 = n - this.gapStart;
            int n5 = this.gapEnd - this.gapStart;
            System.arraycopy(this.array, this.gapEnd, this.array, this.gapStart, n4);
            this.gapStart = n;
            this.gapEnd = this.gapStart + n5;
        }
    }

    private static int binarySearch(double d, double[] dArray, int n, int n2) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            if (dArray[n5] < d) {
                n3 = n5 + 1;
                continue;
            }
            if (dArray[n5] > d) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return ~n3;
    }
}

