/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DefaultVectorDataSet;
import edu.uiowa.physics.pw.das.dataset.GapListDouble;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VectorDataSetBuilder {
    private GapListDouble xTags = new GapListDouble();
    private List yValues = new ArrayList();
    private List planeIDs = new ArrayList();
    private Units xUnits;
    private Map yUnitsMap;
    private Map properties;

    public VectorDataSetBuilder(Units units, Units units2) {
        this.planeIDs.add("");
        this.xUnits = Units.dimensionless;
        this.yUnitsMap = new HashMap();
        this.yUnitsMap.put("", Units.dimensionless);
        this.properties = new HashMap();
        this.xUnits = units;
        this.setYUnits(units2);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void addProperties(Map map) {
        this.properties.putAll(map);
    }

    public void addPlane(String string, Units units) {
        if (!this.planeIDs.contains(string)) {
            this.planeIDs.add(string);
            this.yUnitsMap.put(string, units);
        }
    }

    public void insertY(double d, double d2) {
        this.insertY(d, d2, "");
    }

    public void insertY(double d, double d2, String string) {
        int n = this.xTags.indexOf(d);
        if (string == null) {
            string = "";
        }
        if (n < 0) {
            this.xTags.add(d);
            MultiY multiY = new MultiY();
            multiY.put(string, d2);
            this.yValues.add(n ^= 0xFFFFFFFF, multiY);
        } else {
            MultiY multiY = (MultiY)this.yValues.get(n);
            multiY.put(string, d2);
        }
    }

    public void append(VectorDataSet vectorDataSet) {
        Units units = (Units)this.yUnitsMap.get("");
        int n = 0;
        while (n < vectorDataSet.getXLength()) {
            this.insertY(vectorDataSet.getXTagDouble(n, this.xUnits), vectorDataSet.getDouble(n, units));
            ++n;
        }
    }

    public void setXUnits(Units units) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.xUnits = units;
    }

    public void setYUnits(Units units) {
        this.setYUnits(units, "");
    }

    public void setYUnits(Units units, String string) {
        if (units == null) {
            throw new NullPointerException();
        }
        this.yUnitsMap.put(string, units);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x: ").append(VectorDataSetBuilder.toString(this.xTags.toArray())).append("\ny: ");
        Iterator iterator = this.yValues.iterator();
        while (iterator.hasNext()) {
            MultiY multiY = (MultiY)iterator.next();
            stringBuffer.append(multiY.get("")).append(',');
        }
        return stringBuffer.toString();
    }

    public VectorDataSet toVectorDataSet() {
        double[][] dArray = VectorDataSetBuilder.collapseYValues(this.yValues, this.planeIDs, this.yUnitsMap);
        Units[] unitsArray = VectorDataSetBuilder.getUnitsArray(this.planeIDs, this.yUnitsMap);
        this.properties.put("plane-list", Collections.unmodifiableList(this.planeIDs));
        return new DefaultVectorDataSet(this.xTags.toArray(), this.xUnits, dArray, unitsArray, this.planeIDs.toArray(new String[this.planeIDs.size()]), this.properties);
    }

    private static double[] insert(double[] dArray, double d, int n) {
        double[] dArray2 = new double[dArray.length + 1];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        dArray2[n] = d;
        System.arraycopy(dArray, n, dArray2, n + 1, dArray.length - n);
        return dArray2;
    }

    private static double[][] insert(double[][] dArray, double[] dArray2, int n) {
        double[][] dArrayArray = new double[dArray.length + 1][];
        System.arraycopy(dArray, 0, dArrayArray, 0, n);
        dArrayArray[n] = dArray2;
        System.arraycopy(dArray, n, dArrayArray, n + 1, dArray.length - n);
        return dArrayArray;
    }

    private static String toString(double[] dArray) {
        return VectorDataSetBuilder.toString(dArray, 0, dArray.length);
    }

    private static String toString(double[] dArray, int n, int n2) {
        if (dArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        int n3 = n;
        while (n3 < n2 - 1) {
            stringBuffer.append(dArray[n3]).append(", ");
            ++n3;
        }
        stringBuffer.append(dArray[n2 - 1]).append(']');
        return stringBuffer.toString();
    }

    private static double[][] collapseYValues(List list, List list2, Map map) {
        double[][] dArray = new double[list2.size()][list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MultiY multiY = (MultiY)iterator.next();
            int n2 = 0;
            while (n2 < list2.size()) {
                double d = multiY.get((String)list2.get(n2));
                if (Double.isNaN(d)) {
                    Units units = (Units)map.get(list2.get(n2));
                    d = units.getFillDouble();
                }
                dArray[n2][n] = d;
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    private static Units[] getUnitsArray(List list, Map map) {
        Units[] unitsArray = new Units[list.size()];
        int n = 0;
        while (n < unitsArray.length) {
            unitsArray[n] = (Units)map.get(list.get(n));
            ++n;
        }
        return unitsArray;
    }

    private class MultiY {
        private HashMap yValues = new HashMap();

        private MultiY() {
        }

        private void put(String string, double d) {
            this.yValues.put(string, new Double(d));
        }

        private double get(String string) {
            Double d = (Double)this.yValues.get(string);
            return d == null ? Double.NaN : d;
        }
    }
}

