/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamProducer;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.util.FixedWidthFormatter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class VectorUtil {
    public static double[] getXTagArrayDouble(DataSet dataSet, Units units) {
        int n = dataSet.getXLength();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = dataSet.getXTagDouble(n2, units);
            ++n2;
        }
        return dArray;
    }

    private static int closest(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length - 1 && dArray[n] < d) {
            ++n;
        }
        while (n > 0 && dArray[n] > d) {
            --n;
        }
        if (n < dArray.length - 2) {
            n = (d - dArray[n]) / (dArray[n + 1] - dArray[n]) < 0.5 ? n : n + 1;
        }
        return n;
    }

    public static int closestXTag(DataSet dataSet, Datum datum) {
        return VectorUtil.closestXTag(dataSet, datum.doubleValue(datum.getUnits()), datum.getUnits());
    }

    public static int closestXTag(DataSet dataSet, double d, Units units) {
        double[] dArray = VectorUtil.getXTagArrayDouble(dataSet, units);
        return VectorUtil.closest(dArray, d);
    }

    public static void dumpToAsciiStream(VectorDataSet vectorDataSet, Datum datum, Datum datum2, OutputStream outputStream) {
        Object object;
        List<String> list;
        PrintStream printStream = new PrintStream(outputStream);
        Datum datum3 = null;
        Units units = null;
        printStream.print("[00]");
        printStream.println("<stream start=\"" + vectorDataSet.getXTagDatum(0) + "\" end=\"" + vectorDataSet.getXTagDatum(vectorDataSet.getXLength() - 1) + "\" >");
        printStream.println("<comment>Stream creation date: " + TimeUtil.now().toString() + "</comment>");
        printStream.print("</stream>");
        if (vectorDataSet.getXUnits() instanceof LocationUnits && (units = ((LocationUnits)(datum3 = datum).getUnits()).getOffsetUnits()) == Units.microseconds) {
            units = Units.seconds;
        }
        printStream.print("[01]<packet>\n");
        printStream.print("<x type=\"asciiTab10\" ");
        if (datum3 != null) {
            printStream.print("base=\"" + datum3 + "\" ");
            printStream.print(" xUnits=\"" + units + "\" ");
        } else {
            printStream.print(" xUnits=\"" + vectorDataSet.getXUnits() + "\"");
        }
        printStream.println(" />");
        if (vectorDataSet.getProperty("plane-list") != null) {
            list = (List)vectorDataSet.getProperty("plane-list");
        } else {
            list = new ArrayList();
            list.add("");
        }
        int n = 0;
        while (n < list.size()) {
            object = (String)list.get(n);
            printStream.println("<y type=\"asciiTab10\" name=\"" + (String)object + "\" yUnits=\"" + vectorDataSet.getPlanarView((String)object).getYUnits() + "\" />");
            ++n;
        }
        printStream.print("</packet>");
        object = new DecimalFormat("00000.000");
        DecimalFormat decimalFormat = new DecimalFormat("0.00E00");
        double d = datum2.subtract(datum).doubleValue(units);
        int n2 = 0;
        while (n2 < vectorDataSet.getXLength()) {
            double d2 = datum3 != null ? vectorDataSet.getXTagDatum(n2).subtract(datum3).doubleValue(units) : vectorDataSet.getXTagDouble(n2, vectorDataSet.getXUnits());
            if (d2 >= 0.0 && d2 < d) {
                printStream.print(":01:");
                printStream.print(((NumberFormat)object).format(d2) + " ");
                int n3 = 0;
                while (n3 < list.size()) {
                    VectorDataSet vectorDataSet2 = (VectorDataSet)vectorDataSet.getPlanarView((String)list.get(n3));
                    printStream.print(FixedWidthFormatter.format(decimalFormat.format(vectorDataSet2.getDouble(n2, vectorDataSet2.getYUnits())), 9));
                    if (n3 == list.size() - 1) {
                        printStream.print("\n");
                    } else {
                        printStream.print(" ");
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        printStream.close();
    }

    public static void dumpToAsciiStream(VectorDataSet vectorDataSet, OutputStream outputStream) {
        VectorUtil.dumpToAsciiStream(vectorDataSet, Channels.newChannel(outputStream));
    }

    public static void dumpToAsciiStream(VectorDataSet vectorDataSet, WritableByteChannel writableByteChannel) {
        try {
            Units units = vectorDataSet.getYUnits();
            StreamProducer streamProducer = new StreamProducer(writableByteChannel);
            StreamDescriptor streamDescriptor = new StreamDescriptor();
            streamDescriptor.setProperty("start", vectorDataSet.getXTagDatum(0).toString());
            streamDescriptor.setProperty("end", vectorDataSet.getXTagDatum(vectorDataSet.getXLength() - 1));
            if (TimeUtil.now().lt(TimeUtil.createValid("2004-05-19"))) {
                streamDescriptor.setProperty("comment", "This *IS* a das2 stream, and it looks like it.");
            }
            DataTransferType dataTransferType = DataTransferType.getByName("ascii10");
            DataTransferType dataTransferType2 = DataTransferType.getByName("ascii24");
            streamProducer.streamDescriptor(streamDescriptor);
            DatumVector[] datumVectorArray = new DatumVector[1];
            StreamXDescriptor streamXDescriptor = new StreamXDescriptor();
            streamXDescriptor.setDataTransferType(dataTransferType2);
            streamXDescriptor.setUnits(vectorDataSet.getXUnits());
            StreamMultiYDescriptor streamMultiYDescriptor = new StreamMultiYDescriptor();
            streamMultiYDescriptor.setDataTransferType(dataTransferType);
            streamMultiYDescriptor.setUnits(vectorDataSet.getYUnits());
            PacketDescriptor packetDescriptor = new PacketDescriptor();
            packetDescriptor.setXDescriptor(streamXDescriptor);
            packetDescriptor.addYDescriptor(streamMultiYDescriptor);
            streamProducer.packetDescriptor(packetDescriptor);
            int n = 0;
            while (n < vectorDataSet.getXLength()) {
                Datum datum = vectorDataSet.getXTagDatum(n);
                datumVectorArray[0] = DatumVector.newDatumVector(new double[]{vectorDataSet.getDouble(n, units)}, units);
                streamProducer.packet(packetDescriptor, datum, datumVectorArray);
                ++n;
            }
            streamProducer.streamClosed(streamDescriptor);
        }
        catch (StreamException streamException) {
            throw new RuntimeException(streamException);
        }
    }

    public static void dumpToStream(VectorDataSet vectorDataSet, OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        Datum datum = null;
        Units units = null;
        if (vectorDataSet.getXUnits() instanceof LocationUnits) {
            datum = vectorDataSet.getXTagDatum(0);
            units = ((LocationUnits)datum.getUnits()).getOffsetUnits();
            if (units == Units.microseconds) {
                units = Units.seconds;
            }
            printStream.println("# X is first value, offset in " + units + " from " + datum);
        } else {
            printStream.println("# X is first value, in " + vectorDataSet.getXUnits());
        }
        printStream.println("# Y values follow, in " + vectorDataSet.getYUnits());
        printStream.println("#");
        printStream.println("# File created on: " + TimeUtil.now().toString() + " UT");
        String string = "\t";
        int n = 0;
        while (n < vectorDataSet.getXLength()) {
            double d = datum != null ? vectorDataSet.getXTagDatum(n).subtract(datum).doubleValue(units) : vectorDataSet.getXTagDouble(n, vectorDataSet.getXUnits());
            printStream.print("" + d + string);
            printStream.print("" + vectorDataSet.getDouble(n, vectorDataSet.getYUnits()));
            printStream.println();
            ++n;
        }
        printStream.close();
    }
}

