/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;

public class MendelbrotDataSetDescriptor
extends DataSetDescriptor {
    DasAxis yAxis;

    public MendelbrotDataSetDescriptor(DasAxis dasAxis) {
        this.yAxis = dasAxis;
    }

    private float punktfarbe(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        while (n < 256 && d5 < 4.0) {
            ++n;
            d5 = d3 * d3 - d4 * d4;
            d4 = 2.0 * d3 * d4 + d2;
            d3 = d5 + d;
        }
        if (n == 256) {
            n = 0;
        }
        return (float)n / 256.0f;
    }

    protected DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        double d = datum.doubleValue(Units.dimensionless);
        double d2 = datum2.doubleValue(Units.dimensionless);
        double d3 = datum3.doubleValue(Units.dimensionless);
        double d4 = this.yAxis.getDataMinimum(Units.dimensionless);
        double d5 = this.yAxis.getDataMaximum(Units.dimensionless);
        int n = this.yAxis.getRow().getHeight();
        double d6 = (d5 - d4) / (double)n;
        int n2 = (int)(2.0 * ((d5 - d4) / d6));
        int n3 = (int)(2.0 * ((d2 - d) / d3));
        double[][] dArray = new double[n3][n2];
        dasProgressMonitor.setTaskSize(n2);
        dasProgressMonitor.started();
        int n4 = 0;
        while (n4 < n2) {
            if (dasProgressMonitor.isCancelled()) break;
            dasProgressMonitor.setTaskProgress(n4);
            int n5 = 0;
            while (n5 < n3) {
                dArray[n5][n4] = this.punktfarbe(d + (double)n5 * d3, d4 + (double)n4 * d6);
                ++n5;
            }
            ++n4;
        }
        dasProgressMonitor.finished();
        double[] dArray2 = new double[n3];
        int n6 = 0;
        while (n6 < n3) {
            dArray2[n6] = d + (double)n6 * d3;
            ++n6;
        }
        double[] dArray3 = new double[n2];
        int n7 = 0;
        while (n7 < n2) {
            dArray3[n7] = d4 + (double)n7 * d6;
            ++n7;
        }
        return DefaultTableDataSet.createSimple(dArray2, dArray3, dArray);
    }

    public Units getXUnits() {
        return Units.dimensionless;
    }
}

