/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.XSliceDataSet;
import edu.uiowa.physics.pw.das.dataset.YSliceDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;

public class RipplesDataSet
implements TableDataSet {
    double x1;
    double y1;
    double p1;
    double x2;
    double y2;
    double p2;
    int ytags;
    int xtags;
    Units zUnits = Units.dimensionless;
    Units xUnits = Units.dimensionless;
    Units yUnits = Units.dimensionless;

    public RipplesDataSet() {
        this(2.0, 3.0, 1.0, 13.0, 15.0, 2.0, 30, 30);
    }

    public RipplesDataSet(double d, double d2, double d3, double d4, double d5, double d6, int n, int n2) {
        this.x1 = d;
        this.y1 = d2;
        this.p1 = d3;
        this.x2 = d4;
        this.y2 = d5;
        this.p2 = d6;
        this.xtags = n;
        this.ytags = n2;
    }

    public Datum getDatum(int n, int n2) {
        return this.zUnits.createDatum(this.getDouble(n, n2, this.zUnits));
    }

    public double getDouble(int n, int n2, Units units) {
        double d = this.getXTagDouble(n, this.xUnits);
        double d2 = this.getYTagDouble(0, n2, this.yUnits);
        if (12.0 < d && d < 14.0) {
            return units.getFillDouble();
        }
        double d3 = Math.sqrt((d - this.x1) * (d - this.x1) + (d2 - this.y1) * (d2 - this.y1));
        double d4 = Math.exp(-d3 / this.p1) * Math.cos(Math.PI * d3 / this.p1);
        double d5 = Math.sqrt((d - this.x2) * (d - this.x2) + (d2 - this.y2) * (d2 - this.y2));
        double d6 = Math.exp(-d5 / this.p2) * Math.cos(Math.PI * d5 / this.p2);
        double d7 = d4 + d6;
        return this.zUnits.convertDoubleTo(units, d7);
    }

    public double[] getDoubleScan(int n, Units units) {
        int n2 = this.getYLength(this.tableOfIndex(n));
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = this.getDouble(n, n3, units);
            ++n3;
        }
        return dArray;
    }

    public DatumVector getScan(int n) {
        return DatumVector.newDatumVector(this.getDoubleScan(n, this.zUnits), this.zUnits);
    }

    public int getInt(int n, int n2, Units units) {
        return (int)this.getDouble(n, n2, units);
    }

    public DataSet getPlanarView(String string) {
        if ("weights".equals(string)) {
            return null;
        }
        return null;
    }

    public Object getProperty(String string) {
        return null;
    }

    public int getXLength() {
        return this.xtags;
    }

    public VectorDataSet getXSlice(int n) {
        return new XSliceDataSet(this, n);
    }

    public Datum getXTagDatum(int n) {
        return this.xUnits.createDatum(this.getXTagDouble(n, this.xUnits));
    }

    public double getXTagDouble(int n, Units units) {
        return this.xUnits.convertDoubleTo(units, (double)n * 20.0 / (double)this.xtags);
    }

    public int getXTagInt(int n, Units units) {
        return (int)this.getXTagDouble(n, units);
    }

    public Units getXUnits() {
        return this.xUnits;
    }

    public int getYLength(int n) {
        return this.ytags;
    }

    public VectorDataSet getYSlice(int n, int n2) {
        return new YSliceDataSet(this, n, n2);
    }

    public Datum getYTagDatum(int n, int n2) {
        return this.yUnits.createDatum(this.getYTagDouble(n, n2, this.yUnits));
    }

    public double getYTagDouble(int n, int n2, Units units) {
        return this.yUnits.convertDoubleTo(units, (double)n2 * 20.0 / (double)this.ytags);
    }

    public int getYTagInt(int n, int n2, Units units) {
        return (int)this.getYTagDouble(n, n2, units);
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int n) {
        return this.ytags;
    }

    public int tableOfIndex(int n) {
        return 0;
    }

    public int tableStart(int n) {
        return 0;
    }

    public DatumVector getYTags(int n) {
        double[] dArray = new double[this.getYLength(n)];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = this.getYTagDouble(n, n2, this.yUnits);
            ++n2;
        }
        return DatumVector.newDatumVector(dArray, this.yUnits);
    }
}

