/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;

public class RipplesDataSetDescriptor
extends DataSetDescriptor {
    double x1;
    double y1;
    double p1;
    double x2;
    double y2;
    double p2;

    public RipplesDataSetDescriptor() {
        this(14.0, 17.0, 10.0, 20.0, 60.0, 15.0);
    }

    public RipplesDataSetDescriptor(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x1 = d;
        this.y1 = d2;
        this.p1 = d3;
        this.x2 = d4;
        this.y2 = d5;
        this.p2 = d6;
    }

    public Units getXUnits() {
        return Units.dimensionless;
    }

    public Units getYUnits() {
        return Units.dimensionless;
    }

    public Units getZUnits() {
        return Units.dimensionless;
    }

    public DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        int n;
        int n2 = 300;
        int n3 = 300;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[n2][n3];
        dasProgressMonitor.setTaskSize(dArray.length);
        dasProgressMonitor.started();
        int n4 = 0;
        while (n4 < dArray.length) {
            dArray[n4] = n4;
            n = 0;
            while (n < dArray2.length) {
                double d = Math.sqrt(((double)n4 - this.x1) * ((double)n4 - this.x1) + ((double)n - this.y1) * ((double)n - this.y1));
                double d2 = Math.exp(-d / this.p1) * Math.cos(Math.PI * this.p1 * d);
                double d3 = Math.sqrt((n4 - n2 * 2 / 3) * (n4 - n2 * 2 / 3) + (n - n3 * 2 / 3) * (n - n3 * 2 / 3));
                double d4 = Math.exp(-d3 / this.p2) * Math.cos(Math.PI * this.p2 * d3);
                dArray3[n4][n] = d2 + d4;
                if (22 < n4 && n4 < 24) {
                    dArray3[n4][n] = -1.0E31f;
                }
                ++n;
            }
            if (dasProgressMonitor.isCancelled()) break;
            dasProgressMonitor.setTaskProgress(n4);
            ++n4;
        }
        n = 0;
        while (n < dArray2.length) {
            dArray2[n] = n;
            ++n;
        }
        dArray3[50][50] = -1.0;
        dArray3[0][0] = 1.0;
        dArray3[25][25] = -0.5;
        return DefaultTableDataSet.createSimple(dArray, dArray2, dArray3);
    }
}

