/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DatumUtil {
    private DatumUtil() {
    }

    public static DatumFormatter bestFormatter(Datum datum, Datum datum2, int n) {
        Object object;
        Units units = datum.getUnits();
        if (datum2.lt(datum)) {
            object = datum2;
            datum2 = datum;
            datum = object;
        }
        if (units instanceof TimeLocationUnits) {
            return DatumUtil.bestTimeFormatter(datum, datum2, n);
        }
        object = datum.getUnits().getDatumFormatterFactory();
        try {
            if (!(object instanceof DefaultDatumFormatterFactory)) {
                return ((DatumFormatterFactory)object).defaultFormatter();
            }
            double d = Math.abs(datum2.subtract(datum).doubleValue(units) / (double)n);
            if (d < 0.001) {
                int n2 = Math.abs((int)Math.floor(DasMath.log10(d)));
                String string = DatumUtil.exp(n2);
                return ((DatumFormatterFactory)object).newFormatter(string);
            }
            int n3 = -1 * (int)Math.floor(DasMath.log10(d));
            n3 = n3 < 0 ? 0 : n3;
            String string = DatumUtil.zeros(n3);
            return ((DatumFormatterFactory)object).newFormatter(string);
        }
        catch (ParseException parseException) {
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            RuntimeException runtimeException = new RuntimeException(parseException);
            logger.log(Level.SEVERE, parseException.getMessage(), runtimeException);
            throw runtimeException;
        }
    }

    private static String exp(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        int n2 = 0;
        while (n2 < n - 1) {
            stringBuffer.append('#');
            ++n2;
        }
        stringBuffer.append("0.#E0");
        return stringBuffer.toString();
    }

    private static String zeros(int n) {
        if (n <= 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer(n + 2).append("0.");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append('0');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static DatumFormatter bestTimeFormatter(Datum datum, Datum datum2, int n) {
        double d = datum2.subtract(datum).doubleValue(Units.seconds) / (double)n;
        if (d < 1.0) {
            return TimeDatumFormatter.MILLISECONDS;
        }
        if (d < 60.0) {
            return TimeDatumFormatter.SECONDS;
        }
        if (d < 86400.0) {
            return TimeDatumFormatter.MINUTES;
        }
        return TimeDatumFormatter.DAYS;
    }

    public static Datum createValid(String string) {
        return Datum.create(Double.parseDouble(string), Units.dimensionless);
    }

    public static double[] doubleValues(Datum[] datumArray, Units units) {
        double[] dArray = new double[datumArray.length];
        int n = 0;
        while (n < datumArray.length) {
            dArray[n] = datumArray[n].doubleValue(units);
            ++n;
        }
        return dArray;
    }

    public static double[] doubleValues(Datum[] datumArray, Units[] unitsArray) {
        double[] dArray = new double[datumArray.length];
        int n = 0;
        while (n < datumArray.length) {
            dArray[n] = datumArray[n].doubleValue(unitsArray[n]);
            ++n;
        }
        return dArray;
    }

    public static Datum asOrderOneUnits(Datum datum) {
        Units units = datum.getUnits();
        if (units instanceof LocationUnits) {
            return datum;
        }
        Units[] unitsArray = units.getConvertableUnits();
        double d = 0.0;
        Datum datum2 = datum;
        int n = 0;
        while (n < unitsArray.length) {
            Datum datum3 = datum.convertTo(unitsArray[n]);
            Number number = datum3.getValue();
            double d2 = Math.abs(number.doubleValue());
            double d3 = number.doubleValue() > 1.0 ? 1.0 / d2 : d2;
            if (d3 > d) {
                d = d3;
                datum2 = datum3;
            }
            ++n;
        }
        return datum2;
    }
}

