/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import java.text.ParseException;

public class NumberUnits
extends Units {
    public NumberUnits(String string) {
        this(string, "");
    }

    public NumberUnits(String string, String string2) {
        super(string, string2);
    }

    public Datum createDatum(double d) {
        return new Datum.Double(new Double(d), (Units)this);
    }

    public Datum createDatum(int n) {
        return new Datum.Double(new Double(n), (Units)this);
    }

    public Datum createDatum(long l) {
        return new Datum.Double(new Double(l), (Units)this);
    }

    public Datum createDatum(Number number) {
        return new Datum.Double(number, (Units)this);
    }

    public DatumFormatterFactory getDatumFormatterFactory() {
        return DefaultDatumFormatterFactory.getInstance();
    }

    public Datum parse(String string) throws ParseException {
        try {
            return Datum.create(Double.parseDouble(string), (Units)this);
        }
        catch (NumberFormatException numberFormatException) {
            ParseException parseException = new ParseException(numberFormatException.getMessage(), 0);
            parseException.initCause(numberFormatException);
            throw parseException;
        }
    }

    protected static Number add(Number number, Number number2) {
        if (number instanceof Integer && number2 instanceof Integer) {
            return new Integer(number.intValue() + number2.intValue());
        }
        return new Double(number.doubleValue() + number2.doubleValue());
    }

    protected static Number subtract(Number number, Number number2) {
        if (number instanceof Integer && number2 instanceof Integer) {
            return new Integer(number.intValue() - number2.intValue());
        }
        return new Double(number.doubleValue() - number2.doubleValue());
    }

    protected static Number divide(Number number, Number number2) {
        if (number instanceof Integer && number2 instanceof Integer) {
            return new Integer(number.intValue() / number2.intValue());
        }
        return new Double(number.doubleValue() / number2.doubleValue());
    }

    protected static Number multiply(Number number, Number number2) {
        if (number instanceof Integer && number2 instanceof Integer) {
            return new Integer(number.intValue() * number2.intValue());
        }
        return new Double(number.doubleValue() * number2.doubleValue());
    }

    public Datum add(Number number, Number number2, Units units) {
        if (units != this) {
            UnitsConverter unitsConverter = Units.getConverter(units, this);
            number2 = unitsConverter.convert(number2);
        }
        return this.createDatum(NumberUnits.add(number, number2));
    }

    public Datum subtract(Number number, Number number2, Units units) {
        if (units != this) {
            UnitsConverter unitsConverter = Units.getConverter(units, this);
            number2 = unitsConverter.convert(number2);
        }
        return this.createDatum(NumberUnits.subtract(number, number2));
    }

    public Datum multiply(Number number, Number number2, Units units) {
        if (units == Units.dimensionless) {
            return this.createDatum(NumberUnits.multiply(number, number2));
        }
        throw new IllegalArgumentException("Only multiplication by dimensionless numbers is supported");
    }

    public Datum divide(Number number, Number number2, Units units) {
        if (units == Units.dimensionless) {
            return this.createDatum(NumberUnits.divide(number, number2));
        }
        throw new IllegalArgumentException("Only multiplication by dimensionless numbers is supported");
    }
}

