/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.EnumerationUnits;
import edu.uiowa.physics.pw.das.datum.NumberUnits;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class Units {
    public static final Units dimensionless = new NumberUnits("");
    public static final Units dB = new NumberUnits("dB");
    public static final Units celcius;
    public static final Units fahrenheit;
    public static final Units seconds;
    public static final Units microseconds;
    public static final Units days;
    public static final Units hertz;
    public static final TimeLocationUnits us2000;
    public static final TimeLocationUnits t2000;
    public static final TimeLocationUnits t1970;
    public static final TimeLocationUnits mj1958;
    public static final EnumerationUnits spacecraft;
    public static final Units percent;
    private static Map unitsMap;
    private String id;
    private String description;
    private Map conversionMap = new IdentityHashMap();
    private static double FILL_DOUBLE;
    private static float FILL_FLOAT;
    private static int FILL_INT;
    private static long FILL_LONG;

    protected Units(String string) {
        this(string, "");
    }

    protected Units(String string, String string2) {
        this.id = string;
        this.description = string2;
    }

    private void registerConverter(Units units, UnitsConverter unitsConverter) {
        this.conversionMap.put(units, unitsConverter);
        UnitsConverter unitsConverter2 = (UnitsConverter)units.conversionMap.get(this);
        if (unitsConverter2 == null || unitsConverter2.getInverse() != unitsConverter) {
            units.registerConverter(this, unitsConverter.getInverse());
        }
    }

    public Units[] getConvertableUnits() {
        HashSet<Units> hashSet = new HashSet<Units>();
        LinkedList<Units> linkedList = new LinkedList<Units>();
        linkedList.add(this);
        hashSet.add(this);
        while (!linkedList.isEmpty()) {
            Units units = (Units)linkedList.removeFirst();
            Iterator iterator = units.conversionMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Units units2 = (Units)entry.getKey();
                if (hashSet.contains(units2)) continue;
                linkedList.add(units2);
                hashSet.add(units2);
            }
        }
        return hashSet.toArray(new Units[hashSet.size()]);
    }

    public static UnitsConverter getConverter(Units units, Units units2) {
        Object object;
        Object object2;
        if (units == units2) {
            return UnitsConverter.IDENTITY;
        }
        if (units.conversionMap.get(units2) != null) {
            return (UnitsConverter)units.conversionMap.get(units2);
        }
        HashMap<Units, Object> hashMap = new HashMap<Units, Object>();
        hashMap.put(units, null);
        LinkedList<Units> linkedList = new LinkedList<Units>();
        linkedList.add(units);
        while (!linkedList.isEmpty()) {
            object2 = (Units)linkedList.removeFirst();
            object = ((Units)object2).conversionMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                Units units3 = (Units)entry.getKey();
                if (hashMap.containsKey(units3)) continue;
                hashMap.put(units3, object2);
                linkedList.add(units3);
                if (units3 != units2) continue;
                return Units.buildConversion(units, units2, hashMap);
            }
        }
        object2 = units == dimensionless ? "(dimensionless)" : units.toString();
        object = units2 == dimensionless ? "(dimensionless)" : units2.toString();
        throw new IllegalArgumentException("Inconvertible units: " + (String)object2 + " -> " + (String)object);
    }

    private static UnitsConverter buildConversion(Units units, Units units2, Map map) {
        ArrayList<Units> arrayList = new ArrayList<Units>();
        Units units3 = units2;
        while (units3 != null) {
            arrayList.add(units3);
            units3 = (Units)map.get(units3);
        }
        UnitsConverter unitsConverter = UnitsConverter.IDENTITY;
        int n = arrayList.size() - 1;
        while (n > 0) {
            Units units4 = (Units)arrayList.get(n);
            Units units5 = (Units)arrayList.get(n - 1);
            UnitsConverter unitsConverter2 = (UnitsConverter)units4.conversionMap.get(units5);
            unitsConverter = unitsConverter.append(unitsConverter2);
            --n;
        }
        units.registerConverter(units2, unitsConverter);
        return unitsConverter;
    }

    public UnitsConverter getConverter(Units units) {
        return Units.getConverter(this, units);
    }

    public double convertDoubleTo(Units units, double d) {
        if (this == units) {
            return d;
        }
        return Units.getConverter(this, units).convert(d);
    }

    public String toString() {
        return this.id;
    }

    public Units getOffsetUnits() {
        return this;
    }

    public abstract Datum createDatum(double var1);

    public abstract Datum createDatum(int var1);

    public abstract Datum createDatum(long var1);

    public abstract Datum createDatum(Number var1);

    public double getFillDouble() {
        return FILL_DOUBLE;
    }

    public float getFillFloat() {
        return FILL_FLOAT;
    }

    public int getFillInt() {
        return FILL_INT;
    }

    public long getFillLong() {
        return FILL_LONG;
    }

    public boolean isFill(double d) {
        return Math.abs((d - FILL_DOUBLE) / d) < 1.0E-5;
    }

    public boolean isFill(float f) {
        return (double)Math.abs((f - FILL_FLOAT) / f) < 1.0E-5;
    }

    public boolean isFill(long l) {
        return l == FILL_LONG;
    }

    public boolean isFill(int n) {
        return n == FILL_INT;
    }

    public boolean isFill(Number number) {
        if (number instanceof Double) {
            return this.isFill(number.doubleValue());
        }
        if (number instanceof Float) {
            return this.isFill(number.floatValue());
        }
        if (number instanceof Integer) {
            return this.isFill(number.intValue());
        }
        if (number instanceof Long) {
            return this.isFill(number.longValue());
        }
        throw new IllegalArgumentException("Unknown Number class: " + number.getClass().toString());
    }

    public abstract DatumFormatterFactory getDatumFormatterFactory();

    public abstract Datum parse(String var1) throws ParseException;

    public String format(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().format(datum);
    }

    public String grannyFormat(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().grannyFormat(datum);
    }

    public abstract Datum add(Number var1, Number var2, Units var3);

    public abstract Datum subtract(Number var1, Number var2, Units var3);

    public abstract Datum multiply(Number var1, Number var2, Units var3);

    public abstract Datum divide(Number var1, Number var2, Units var3);

    public static Units getByName(String string) {
        Units units = (Units)unitsMap.get(string);
        if (string == null) {
            throw new IllegalArgumentException("Unrecognized units");
        }
        return units;
    }

    public static void main(String[] stringArray) throws ParseException {
        Datum datum = Datum.create(100);
        Datum datum2 = datum.convertTo(dB);
        System.out.println("ratio: " + datum);
        System.out.println("dB: " + datum2);
    }

    static {
        dimensionless.registerConverter(dB, new dBConverter());
        celcius = new NumberUnits("deg C");
        fahrenheit = new NumberUnits("deg F");
        celcius.registerConverter(fahrenheit, new UnitsConverter.ScaleOffset(1.8, 32.0));
        seconds = new NumberUnits("s");
        microseconds = new NumberUnits("microseconds");
        days = new NumberUnits("days");
        seconds.registerConverter(microseconds, UnitsConverter.MICRO);
        days.registerConverter(seconds, new UnitsConverter.ScaleOffset(86400.0, 0.0));
        hertz = new NumberUnits("Hz");
        us2000 = new TimeLocationUnits("us2000", "Microseconds since midnight Jan 1, 2000.", microseconds);
        t2000 = new TimeLocationUnits("t2000", "Seconds since midnight Jan 1, 2000.", seconds);
        t1970 = new TimeLocationUnits("t1970", "Seconds since midnight Jan 1, 1970", seconds);
        mj1958 = new TimeLocationUnits("mj1958", "Julian - 2436204.5", days);
        super.registerConverter(us2000, UnitsConverter.MICRO);
        super.registerConverter(t1970, new UnitsConverter.ScaleOffset(1.0, 9.466848E8));
        super.registerConverter(mj1958, new UnitsConverter.ScaleOffset(1.1574074074074073E-5, 15340.0));
        spacecraft = new EnumerationUnits("spacecraft", "Enumeration of various spacecraft");
        spacecraft.createDatum("Voyager1");
        spacecraft.createDatum("Voyager2");
        spacecraft.createDatum("Cluster Rumba");
        spacecraft.createDatum("Cluster Salsa");
        spacecraft.createDatum("Cluster Samba");
        spacecraft.createDatum("Cluster Tango");
        percent = new NumberUnits("%", "Special dimensionless number, possibly useful for specifying Tag relevance on logarithmic scale");
        unitsMap = new HashMap();
        unitsMap.put("mj1958", mj1958);
        unitsMap.put("t1970", t1970);
        unitsMap.put("t2000", t2000);
        unitsMap.put("us2000", us2000);
        unitsMap.put("seconds", seconds);
        unitsMap.put("s", seconds);
        unitsMap.put("days", days);
        unitsMap.put("microseconds", microseconds);
        unitsMap.put("", dimensionless);
        unitsMap.put("dB", dB);
        FILL_DOUBLE = -1.0E31;
        FILL_FLOAT = -1.0E31f;
        FILL_INT = Integer.MAX_VALUE;
        FILL_LONG = Long.MAX_VALUE;
    }

    private static final class dBConverter
    extends UnitsConverter {
        private dBConverter() {
        }

        public double convert(double d) {
            return 10.0 * DasMath.log10(d);
        }

        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    public double convert(double d) {
                        return Math.pow(10.0, d / 10.0);
                    }

                    public UnitsConverter getInverse() {
                        return this;
                    }
                };
            }
            return this.inverse;
        }
    }
}

