/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.event.BoxRenderer;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MousePointSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DasMouseInputAdapter
extends MouseInputAdapter {
    private MouseModule primary = null;
    private MouseModule secondary = null;
    private MouseModule tertiary = null;
    private Vector active = null;
    private Vector modules;
    private HashMap primaryActionButtonMap;
    private HashMap secondaryActionButtonMap;
    protected JPopupMenu primaryPopup;
    protected JPopupMenu secondaryPopup;
    private Point primaryPopupLocation;
    private Point secondaryPopupLocation;
    private JPanel pngFileNamePanel;
    private JTextField pngFileTextField;
    private JFileChooser pngFileChooser;
    JCheckBoxMenuItem primarySelectedItem;
    JCheckBoxMenuItem secondarySelectedItem;
    int numInserted;
    protected ActionListener popupListener;
    protected DasCanvasComponent parent = null;
    private Point selectionStart;
    private Point selectionEnd;
    private Point dSelectionStart;
    private Point dSelectionEnd;
    private Graphics2D g;
    private MousePointSelectionEvent mousePointSelection;
    private int xOffset;
    private int yOffset;
    private int button = 0;
    private MouseMode mouseMode = MouseMode.idle;
    private DragRenderer resizeRenderer = null;
    private Point resizeStart = null;
    Vector hotSpots = null;
    Rectangle dirtyBounds = null;

    public DasMouseInputAdapter(DasCanvasComponent dasCanvasComponent) {
        this.parent = dasCanvasComponent;
        this.modules = new Vector();
        this.primaryActionButtonMap = new HashMap();
        this.secondaryActionButtonMap = new HashMap();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.primaryPopup = this.createPopup();
            this.secondaryPopup = this.createPopup();
        }
        this.active = null;
        this.mousePointSelection = new MousePointSelectionEvent(this, 0, 0);
        this.resizeRenderer = new BoxRenderer(dasCanvasComponent);
        this.numInserted = 0;
    }

    public void replaceMouseModule(MouseModule mouseModule2, MouseModule mouseModule3) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(mouseModule2);
        this.primaryActionButtonMap.put(mouseModule3, jCheckBoxMenuItem);
        this.primaryActionButtonMap.remove(mouseModule2);
        this.secondaryActionButtonMap.put(mouseModule3, this.secondaryActionButtonMap.get(mouseModule2));
        this.secondaryActionButtonMap.remove(mouseModule2);
        this.modules.removeElement(mouseModule2);
        this.modules.addElement(mouseModule3);
    }

    public void addMouseModule(MouseModule mouseModule2) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            DasApplication.getDefaultApplication().getLogger().info("not adding module since headless is true");
        } else {
            MouseModule mouseModule3 = this.getModuleByLabel(mouseModule2.getLabel());
            if (mouseModule3 != null) {
                DasDie.println(DasDie.INFORM, "Replacing mouse module " + mouseModule2.getLabel() + ".");
                this.replaceMouseModule(mouseModule3, mouseModule2);
            } else {
                this.modules.add(mouseModule2);
                String string = mouseModule2.getLabel();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
                JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(string);
                jCheckBoxMenuItem.addActionListener(this.popupListener);
                jCheckBoxMenuItem.setActionCommand("primary");
                jCheckBoxMenuItem2.addActionListener(this.popupListener);
                jCheckBoxMenuItem2.setActionCommand("secondary");
                this.primaryActionButtonMap.put(mouseModule2, jCheckBoxMenuItem);
                this.secondaryActionButtonMap.put(mouseModule2, jCheckBoxMenuItem2);
                this.primaryPopup.add((Component)jCheckBoxMenuItem, this.primaryActionButtonMap.size() - 1);
                this.secondaryPopup.add((Component)jCheckBoxMenuItem2, this.secondaryActionButtonMap.size() - 1);
            }
        }
    }

    public void setPrimaryModule(MouseModule mouseModule2) {
        JCheckBoxMenuItem jCheckBoxMenuItem;
        Iterator iterator = this.primaryActionButtonMap.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                jCheckBoxMenuItem = iterator.next().getValue();
                jCheckBoxMenuItem.setSelected(false);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
        jCheckBoxMenuItem = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(mouseModule2);
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setSelected(true);
        }
        this.primarySelectedItem = jCheckBoxMenuItem;
        this.primary = mouseModule2;
        this.parent.setCursor(this.primary.getCursor());
    }

    public void setSecondaryModule(MouseModule mouseModule2) {
        JCheckBoxMenuItem jCheckBoxMenuItem;
        Iterator iterator = this.secondaryActionButtonMap.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                jCheckBoxMenuItem = iterator.next().getValue();
                jCheckBoxMenuItem.setSelected(false);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
        jCheckBoxMenuItem = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(mouseModule2);
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setSelected(true);
        }
        this.secondarySelectedItem = jCheckBoxMenuItem;
        this.secondary = mouseModule2;
    }

    public void setTertiaryModule(MouseModule mouseModule2) {
        this.tertiary = mouseModule2;
    }

    private JPopupMenu createPopup() {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.popupListener = this.createPopupMenuListener();
        if (this.parent instanceof Editable) {
            jMenuItem = new JMenuItem("properties");
            jMenuItem.addActionListener(this.popupListener);
            jMenuItem.setToolTipText("edit object properties");
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        jMenuItem = new JMenuItem("print...");
        jMenuItem.setActionCommand("print");
        jMenuItem.addActionListener(this.popupListener);
        jMenuItem.setToolTipText("print entire canvas");
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("save as PNG...");
        jMenuItem2.setActionCommand("toPng");
        jMenuItem2.setToolTipText("save canvas to png image file");
        jMenuItem2.addActionListener(this.popupListener);
        jPopupMenu.add(jMenuItem2);
        return jPopupMenu;
    }

    private ActionListener createPopupMenuListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DasMouseInputAdapter dasMouseInputAdapter = DasMouseInputAdapter.this;
                String string = actionEvent.getActionCommand();
                if (string.equals("properties")) {
                    DasMouseInputAdapter.this.parent.showProperties();
                } else if (string.equals("print")) {
                    Printable printable = ((DasCanvas)DasMouseInputAdapter.this.parent.getParent()).getPrintable();
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(printable);
                    if (printerJob.printDialog()) {
                        try {
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            Object[] objectArray = new Object[]{"Error printing", printerException.getMessage()};
                            JOptionPane.showMessageDialog(null, objectArray, "ERROR", 0);
                        }
                    }
                } else if (string.equals("toPng")) {
                    Object object;
                    if (DasMouseInputAdapter.this.pngFileNamePanel == null) {
                        DasMouseInputAdapter.this.pngFileNamePanel = new JPanel();
                        DasMouseInputAdapter.this.pngFileNamePanel.setLayout(new BoxLayout(DasMouseInputAdapter.this.pngFileNamePanel, 0));
                        DasMouseInputAdapter.this.pngFileTextField = new JTextField(32);
                        DasMouseInputAdapter.this.pngFileTextField.setMaximumSize(DasMouseInputAdapter.this.pngFileTextField.getPreferredSize());
                        DasMouseInputAdapter.this.pngFileChooser = new JFileChooser();
                        DasMouseInputAdapter.this.pngFileChooser.setApproveButtonText("Select File");
                        DasMouseInputAdapter.this.pngFileChooser.setDialogTitle("Write to PNG");
                        object = new JButton("Browse");
                        ((AbstractButton)object).setActionCommand("pngBrowse");
                        ((AbstractButton)object).addActionListener(this);
                        DasMouseInputAdapter.this.pngFileNamePanel.add(DasMouseInputAdapter.this.pngFileTextField);
                        DasMouseInputAdapter.this.pngFileNamePanel.add((Component)object);
                    }
                    DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getCurrentDirectory().getPath());
                    object = new String[]{"Write to PNG", "Cancel"};
                    int n = JOptionPane.showOptionDialog(DasMouseInputAdapter.this.parent, DasMouseInputAdapter.this.pngFileNamePanel, "Write to PNG", 0, 3, null, (Object[])object, "Ok");
                    if (n == 0) {
                        DasCanvas dasCanvas = (DasCanvas)DasMouseInputAdapter.this.parent.getParent();
                        try {
                            dasCanvas.writeToPng(DasMouseInputAdapter.this.pngFileTextField.getText());
                        }
                        catch (IOException iOException) {
                            DasExceptionHandler.handle(iOException);
                        }
                    }
                } else if (string.equals("pngBrowse")) {
                    int n = DasMouseInputAdapter.this.pngFileChooser.showDialog(DasMouseInputAdapter.this.parent, "Select File");
                    if (n == 0) {
                        DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getSelectedFile().getPath());
                    }
                } else if (!string.equals("close")) {
                    if (string.equals("primary")) {
                        if (DasMouseInputAdapter.this.primarySelectedItem != null) {
                            DasMouseInputAdapter.this.primarySelectedItem.setSelected(false);
                        }
                        int n = 0;
                        while (n < DasMouseInputAdapter.this.modules.size()) {
                            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)DasMouseInputAdapter.this.primaryActionButtonMap.get(DasMouseInputAdapter.this.modules.get(n));
                            if (jCheckBoxMenuItem.isSelected()) {
                                DasMouseInputAdapter.this.primarySelectedItem = jCheckBoxMenuItem;
                                break;
                            }
                            ++n;
                        }
                        DasMouseInputAdapter.this.primarySelectedItem.setSelected(true);
                    } else if (string.equals("secondary")) {
                        if (DasMouseInputAdapter.this.secondarySelectedItem != null) {
                            DasMouseInputAdapter.this.secondarySelectedItem.setSelected(false);
                        }
                        Point point = DasMouseInputAdapter.this.secondaryPopupLocation;
                        int n = 0;
                        while (n < DasMouseInputAdapter.this.modules.size()) {
                            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)DasMouseInputAdapter.this.secondaryActionButtonMap.get(DasMouseInputAdapter.this.modules.get(n));
                            if (jCheckBoxMenuItem.isSelected()) {
                                DasMouseInputAdapter.this.secondarySelectedItem = jCheckBoxMenuItem;
                                break;
                            }
                            ++n;
                        }
                    } else {
                        DasDie.println("" + string);
                    }
                }
            }
        };
    }

    public void renderSelection(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.active.size()) {
            DasCanvas dasCanvas = this.parent.getCanvas();
            this.selectionStart = SwingUtilities.convertPoint(dasCanvas, this.dSelectionStart, this.parent);
            this.selectionEnd = SwingUtilities.convertPoint(dasCanvas, this.dSelectionEnd, this.parent);
            ((MouseModule)this.active.get((int)n)).dragRenderer.renderDrag(graphics2D, this.selectionStart, this.selectionEnd);
            ++n;
        }
    }

    public void clearSelection(Graphics2D graphics2D) {
        if (this.active == null) {
            return;
        }
        int n = 0;
        while (n < this.active.size()) {
            ((MouseModule)this.active.get((int)n)).dragRenderer.clear(graphics2D);
            ++n;
        }
    }

    private MouseMode activateMouseMode(MouseEvent mouseEvent) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.parent.getRow() != null && this.parent.getColumn() != null) {
            int n = this.parent.getColumn().getDMinimum() - this.xOffset;
            int n2 = this.parent.getColumn().getDMaximum() - this.xOffset;
            int n3 = this.parent.getRow().getDMinimum() - this.yOffset;
            int n4 = this.parent.getRow().getDMaximum() - this.yOffset;
            bl = mouseEvent.getX() < n + 5;
            bl2 = mouseEvent.getX() > n2 - 5;
            bl3 = mouseEvent.getY() < n3 + 5 && mouseEvent.getY() >= n3;
            bl4 = mouseEvent.getY() > n4 - 5;
        }
        MouseMode mouseMode = MouseMode.idle;
        Cursor cursor = new Cursor(0);
        if (!(this.parent instanceof DasAxis)) {
            if (bl) {
                if (bl3) {
                    mouseMode = MouseMode.resize;
                    cursor = new Cursor(6);
                } else if (bl4) {
                    mouseMode = MouseMode.resize;
                    cursor = new Cursor(4);
                }
            } else if (bl2) {
                if (bl3) {
                    mouseMode = MouseMode.resize;
                    cursor = new Cursor(7);
                } else if (bl4) {
                    mouseMode = MouseMode.resize;
                    cursor = new Cursor(5);
                }
            }
        }
        Shape shape = null;
        if (this.hotSpots != null) {
            Vector vector = this.hotSpots;
            int n = 0;
            while (n < vector.size()) {
                Shape shape2 = (Shape)vector.get(n);
                if (shape2.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    cursor = new Cursor(12);
                    mouseMode = MouseMode.hotSpot;
                    shape = shape2;
                }
                ++n;
            }
        }
        if (mouseMode == MouseMode.resize) {
            mouseMode.resizeBottom = bl4;
            mouseMode.resizeTop = bl3;
            mouseMode.resizeRight = bl2;
            mouseMode.resizeLeft = bl;
        }
        if (mouseMode != this.mouseMode) {
            this.getGlassPane().setCursor(cursor);
            if (this.mouseMode == MouseMode.hotSpot && mouseMode != MouseMode.hotSpot) {
                this.parent.repaint(this.dirtyBounds);
                this.dirtyBounds = null;
            } else if (mouseMode == MouseMode.hotSpot && this.mouseMode != MouseMode.hotSpot) {
                Graphics2D graphics2D = (Graphics2D)this.parent.getGraphics();
                graphics2D.setColor(new Color(0, 200, 255, 50));
                graphics2D.fill(shape);
                this.dirtyBounds = shape.getBounds();
            }
        }
        return mouseMode;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = this.parent.getLocation();
        this.xOffset = point.x;
        this.yOffset = point.y;
        MouseMode mouseMode = this.activateMouseMode(mouseEvent);
        this.mouseMode = mouseMode != null ? mouseMode : MouseMode.idle;
    }

    private void showPopup(JPopupMenu jPopupMenu, Point point) {
        HashMap hashMap = null;
        if (jPopupMenu == this.primaryPopup) {
            hashMap = this.primaryActionButtonMap;
        } else if (jPopupMenu == this.secondaryPopup) {
            hashMap = this.secondaryActionButtonMap;
        } else {
            throw new IllegalArgumentException("menu must be primary or secondary popup menu");
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            MouseModule mouseModule2 = (MouseModule)iterator.next();
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(mouseModule2);
            jCheckBoxMenuItem.setText(mouseModule2.getLabel());
        }
        jPopupMenu.show(this.parent, point.x, point.y);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block22: {
            block20: {
                block21: {
                    Point point = this.parent.getLocation();
                    this.xOffset = point.x;
                    this.yOffset = point.y;
                    if (this.mouseMode != MouseMode.resize) break block20;
                    this.resizeStart = new Point(0, 0);
                    this.g = (Graphics2D)this.getGlassPane().getGraphics();
                    this.g.translate(this.parent.getX(), this.parent.getY());
                    if (this.mouseMode.resizeRight) {
                        this.resizeStart.x = 0;
                    } else if (this.mouseMode.resizeLeft) {
                        this.resizeStart.x = this.parent.getWidth();
                    }
                    if (!this.mouseMode.resizeTop) break block21;
                    this.resizeStart.y = this.parent.getHeight();
                    break block22;
                }
                if (!this.mouseMode.resizeBottom) break block22;
                this.resizeStart.y = 0;
                break block22;
            }
            if (this.mouseMode == MouseMode.hotSpot) {
                Vector vector = this.hotSpots;
                int n = 0;
                while (n < vector.size()) {
                    if (((Shape)vector.get(n)).contains(mouseEvent.getX(), mouseEvent.getY())) {
                        this.primary.hotSpotPressed((Shape)vector.get(n));
                    }
                    ++n;
                }
            } else if (this.active == null) {
                this.button = mouseEvent.getButton();
                this.selectionStart = mouseEvent.getPoint();
                this.dSelectionStart = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
                this.selectionEnd = mouseEvent.getPoint();
                this.dSelectionEnd = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
                this.g = (Graphics2D)this.parent.getGraphics();
                if (mouseEvent.isControlDown() || this.button == 3) {
                    if (this.button == 1 || this.button == 3) {
                        this.showPopup(this.primaryPopup, mouseEvent.getPoint());
                    } else {
                        this.showPopup(this.secondaryPopup, mouseEvent.getPoint());
                    }
                } else {
                    Object object;
                    int n;
                    this.active = new Vector();
                    if (this.button == 1 || this.button == 3) {
                        n = 0;
                        while (n < this.modules.size()) {
                            object = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(this.modules.get(n));
                            if (((AbstractButton)object).isSelected()) {
                                this.active.add(this.modules.get(n));
                            }
                            ++n;
                        }
                    } else {
                        n = 0;
                        while (n < this.modules.size()) {
                            object = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(this.modules.get(n));
                            if (((AbstractButton)object).isSelected()) {
                                this.active.add(this.modules.get(n));
                            }
                            ++n;
                        }
                    }
                    this.mouseMode = MouseMode.moduleDrag;
                    this.mousePointSelection.set(mouseEvent.getX() + this.xOffset, mouseEvent.getY() + this.yOffset);
                    n = 0;
                    while (n < this.active.size()) {
                        object = (MouseModule)this.active.get(n);
                        ((MouseModule)object).mousePressed(mouseEvent);
                        if (((MouseModule)object).dragRenderer.isPointSelection()) {
                            this.mouseDragged(mouseEvent);
                        }
                        ++n;
                    }
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseMode == MouseMode.resize) {
            this.resizeRenderer.clear(this.g);
            this.resizeRenderer.renderDrag(this.g, this.resizeStart, mouseEvent.getPoint());
        } else if (this.active != null) {
            this.clearSelection(this.g);
            this.selectionEnd = mouseEvent.getPoint();
            this.dSelectionEnd = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
            this.renderSelection(this.g);
            this.mousePointSelection.set((int)this.dSelectionEnd.getX(), (int)this.dSelectionEnd.getY());
            int n = 0;
            while (n < this.active.size()) {
                MouseModule mouseModule2 = (MouseModule)this.active.get(n);
                if (mouseModule2.dragRenderer.isPointSelection()) {
                    mouseModule2.mousePointSelected(this.mousePointSelection);
                }
                if (mouseModule2.dragRenderer.isUpdatingDragSelection()) {
                    MouseDragEvent mouseDragEvent = mouseModule2.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, mouseEvent.isShiftDown());
                    mouseModule2.mouseRangeSelected(mouseDragEvent);
                }
                mouseModule2.mouseDragged(mouseEvent);
                ++n;
            }
        }
    }

    private void performResize(MouseEvent mouseEvent) {
        DasCanvas dasCanvas = (DasCanvas)this.parent.getParent();
        int n = this.parent.getColumn().getDMinimum();
        int n2 = this.parent.getColumn().getDMaximum();
        int n3 = this.parent.getRow().getDMinimum();
        int n4 = this.parent.getRow().getDMaximum();
        int n5 = mouseEvent.getX() + this.xOffset;
        int n6 = mouseEvent.getY() + this.yOffset;
        if (this.mouseMode.resizeRight) {
            n2 = n5;
        } else if (this.mouseMode.resizeLeft) {
            n = n5;
        }
        if (this.mouseMode.resizeTop) {
            n3 = n6;
        } else if (this.mouseMode.resizeBottom) {
            n4 = n6;
        }
        this.parent.getColumn().setDPosition(n, n2);
        this.parent.getRow().setDPosition(n3, n4);
        this.parent.resize();
        this.getGlassPane().setCursor(new Cursor(0));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseMode == MouseMode.resize) {
            this.performResize(mouseEvent);
        } else if (mouseEvent.getButton() == this.button && this.active != null) {
            this.clearSelection(this.g);
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            while (n3 < this.active.size()) {
                boolean bl;
                MouseModule mouseModule2 = (MouseModule)this.active.get(n3);
                boolean bl2 = mouseModule2.dragRenderer.isXRangeSelection() && n2 >= 0 && n2 <= this.parent.getHeight();
                boolean bl3 = bl = mouseModule2.dragRenderer.isYRangeSelection() && n >= 0 && n <= this.parent.getWidth();
                if (bl2 || bl) {
                    MouseDragEvent mouseDragEvent = mouseModule2.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, mouseEvent.isShiftDown());
                    mouseModule2.mouseRangeSelected(mouseDragEvent);
                }
                this.button = 0;
                mouseModule2.mouseReleased(mouseEvent);
                ++n3;
            }
            this.active = null;
        }
    }

    public void removeMouseModule(MouseModule mouseModule2) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.primary != null) {
            this.hotSpots = this.primary.getHotSpots();
            this.getGlassPane().setCursor(this.primary.getCursor());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseMode == MouseMode.hotSpot) {
            this.parent.repaint(this.dirtyBounds);
            this.mouseMode = MouseMode.idle;
        }
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
    }

    public void addMenuItem(Component component) {
        if (this.numInserted == 0) {
            this.primaryPopup.insert(new JPopupMenu.Separator(), 0);
        }
        this.primaryPopup.insert(component, this.numInserted);
        ++this.numInserted;
    }

    public Component getGlassPane() {
        return ((DasCanvas)this.parent.getParent()).getGlassPane();
    }

    public MouseModule getModuleByLabel(String string) {
        MouseModule mouseModule2 = null;
        int n = 0;
        while (n < this.modules.size()) {
            if (string.equals(((MouseModule)this.modules.get(n)).getLabel())) {
                mouseModule2 = (MouseModule)this.modules.get(n);
            }
            ++n;
        }
        return mouseModule2;
    }

    private static class MouseMode {
        String s;
        boolean resizeTop = false;
        boolean resizeBottom = false;
        boolean resizeRight = false;
        boolean resizeLeft = false;
        static MouseMode idle = new MouseMode("idle");
        static MouseMode resize = new MouseMode("resize");
        static MouseMode moduleDrag = new MouseMode("moduleDrag");
        static MouseMode hotSpot = new MouseMode("hotSpot");

        MouseMode(String string) {
            this.s = string;
        }

        public String toString() {
            return this.s;
        }
    }
}

