/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;

public class HorizontalFrequencyDragRenderer
implements DragRenderer,
KeyListener {
    private Rectangle dirtyBounds;
    DasCanvasComponent parent;
    DasAxis axis;
    int ncycles;

    public HorizontalFrequencyDragRenderer(DasCanvasComponent dasCanvasComponent, DasAxis dasAxis) {
        this.parent = dasCanvasComponent;
        dasCanvasComponent.addKeyListener(this);
        this.axis = dasAxis;
        this.dirtyBounds = new Rectangle();
        this.ncycles = 1;
    }

    public boolean isXRangeSelection() {
        return false;
    }

    public void renderLabel(Graphics graphics, Point point, Point point2, String string) {
        int n = Integer.MIN_VALUE;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fontMetrics = this.parent.getGraphics().getFontMetrics();
        Color color = graphics2D.getColor();
        graphics2D.setColor(new Color(255, 255, 255, 200));
        Dimension dimension = this.parent.getSize();
        int n2 = fontMetrics.stringWidth(string) + 6;
        if (n < n2) {
            n = n2;
        }
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n4 = point2.x + 3;
        int n5 = point2.y - 3 - n3;
        if (n4 + n > dimension.width - 3 && point2.x - 3 - n2 > 0) {
            n4 = point2.x - 3 - n2;
        }
        if (n5 < 13) {
            n5 = point2.y + 3;
        }
        Rectangle rectangle = new Rectangle(n4, n5, n2, n3);
        graphics2D.fill(rectangle);
        graphics2D.setColor(new Color(20, 20, 20));
        graphics2D.drawString(string, n4 + 3, n5 + fontMetrics.getAscent());
        graphics2D.setColor(color);
        this.dirtyBounds.add(rectangle);
    }

    public void renderDrag(Graphics graphics, Point point, Point point2) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = point2.x;
        int n3 = point.x;
        if (n2 < n3) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        n = n2 - n3;
        int n4 = point2.y;
        Color color = graphics2D.getColor();
        graphics2D.setColor(new Color(255, 255, 255, 100));
        graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
        if (n > 6) {
            graphics2D.drawLine(n3 + 3, n4, n2 - 3, n4);
        }
        graphics2D.drawLine(n3, n4 + 2, n3, n4 - 2);
        graphics2D.drawLine(n2, n4 + 2, n2, n4 - 2);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color);
        if (n > 6) {
            graphics2D.drawLine(n3 + 3, n4, n2 - 3, n4);
        }
        graphics2D.drawLine(n3, n4 + 2, n3, n4 - 2);
        graphics2D.drawLine(n2, n4 + 2, n2, n4 - 2);
        this.dirtyBounds.setRect(n3 - 2, n4 - 5, 4.0, 10.0);
        double d = (double)n / (double)this.ncycles;
        if (n > 3 * this.ncycles) {
            double d2 = (double)n2 + d;
            while (d2 < (double)this.axis.getColumn().getWidth()) {
                graphics2D.drawLine((int)d2, n4 + 2, (int)d2, n4 - 2);
                this.dirtyBounds.add((int)d2 + 2, n4 - 5);
                d2 += d;
            }
            double d3 = (double)n2 - d;
            while (d3 > 0.0) {
                graphics2D.drawLine((int)d3, n4 + 2, (int)d3, n4 - 2);
                this.dirtyBounds.add((int)d3 - 2, n4 - 5);
                d3 -= d;
            }
        }
        Datum datum = this.axis.invTransform(n2).subtract(this.axis.invTransform(n3));
        double d4 = datum.doubleValue(datum.getUnits());
        double d5 = (double)this.ncycles / d4;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        this.renderLabel(graphics, point, point2, "T:" + decimalFormat.format(d4) + " f:" + decimalFormat.format(d5));
    }

    public boolean isPointSelection() {
        return false;
    }

    public void clear(Graphics graphics) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return false;
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        return null;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        System.out.println(keyEvent);
        if (keyEvent.getKeyChar() == '1') {
            this.ncycles = 1;
        } else if (keyEvent.getKeyChar() == '2') {
            this.ncycles = 2;
        } else if (keyEvent.getKeyChar() == '3') {
            this.ncycles = 3;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

