/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataRequestThread;
import edu.uiowa.physics.pw.das.dataset.DataRequestor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatterFactory;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.HorizontalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.VerticalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasMath;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InterruptedIOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasAxis
extends DasCanvasComponent
implements DataRangeSelectionListener,
TimeRangeSelectionListener,
Cloneable {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int UP = 995;
    public static final int DOWN = 996;
    private static final String SCAN_PREVIOUS_LABEL = "<< scan";
    private static final String SCAN_NEXT_LABEL = "scan >>";
    protected DataRange dataRange;
    private int orientation;
    private int tickDirection = 1;
    protected String axisLabel = "";
    protected TickVDescriptor tickV;
    private boolean ticksVisible = true;
    private boolean tickLabelsVisible = true;
    private boolean oppositeAxisVisible;
    protected DatumFormatter datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    private MouseModule zoom = null;
    private PropertyChangeListener dataRangePropertyListener;
    protected JPanel primaryInputPanel;
    protected JPanel secondaryInputPanel;
    private ScanButton scanPrevious;
    private ScanButton scanNext;
    private boolean animated = "on".equals(DasProperties.getInstance().get("visualCues"));
    private Rectangle blLineRect;
    private Rectangle trLineRect;
    private Rectangle blTickRect;
    private Rectangle trTickRect;
    private Rectangle blLabelRect;
    private Rectangle trLabelRect;
    private Rectangle blTitleRect;
    private Rectangle trTitleRect;
    private EventListenerList timeRangeListenerList = null;
    private TimeRangeSelectionEvent lastProcessedEvent = null;
    private DataSetDescriptor dsd;
    private VectorDataSet[] tcaData = new VectorDataSet[0];
    private String dataset = "";
    private boolean drawTca;
    private DataRequestThread drt;
    private static final boolean DEBUG_GRAPHICS = false;
    private static final Color[] DEBUG_COLORS = null;
    private int debugColorIndex = 0;
    private static final Pattern pattern = Pattern.compile("\\([eEfF]\\d+.\\d+\\)");
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasRow;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColumn;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasAxis;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener;

    public static DasAxis create(double[] dArray, Units units, int n, boolean bl) {
        DasAxis dasAxis = new DasAxis(Datum.create(0, units), Datum.create(0, units), n, bl);
        dasAxis.setDataRange(dArray);
        return dasAxis;
    }

    public DasAxis(Datum datum, Datum datum2, int n) {
        this(datum, datum2, n, false);
    }

    public DasAxis(Datum datum, Datum datum2, int n, boolean bl) {
        this(n);
        this.dataRange = new DataRange(this, datum, datum2, bl);
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    protected DasAxis(DataRange dataRange, int n) {
        this(n);
        this.dataRange = dataRange;
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    private DasAxis(int n) {
        this.setOpaque(false);
        this.setOrientationInternal(n);
        this.installMouseModules();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            JMenuItem jMenuItem = new JMenuItem("Back");
            jMenuItem.addActionListener(this.createActionListener());
            jMenuItem.setActionCommand("back");
            jMenuItem.setToolTipText("undo last operation");
            this.mouseAdapter.addMenuItem(jMenuItem);
        }
        this.dataRangePropertyListener = this.createDataRangePropertyListener();
        this.setLayout(new AxisLayoutManager());
        this.maybeInitializeInputPanels();
        this.maybeInitializeScanButtons();
        this.add(this.primaryInputPanel);
        this.add(this.secondaryInputPanel);
    }

    private void maybeInitializeInputPanels() {
        if (this.primaryInputPanel == null) {
            this.primaryInputPanel = new JPanel();
            this.primaryInputPanel.setOpaque(false);
        }
        if (this.secondaryInputPanel == null) {
            this.secondaryInputPanel = new JPanel();
            this.secondaryInputPanel.setOpaque(false);
        }
    }

    private void maybeInitializeScanButtons() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.scanPrevious = new ScanButton(SCAN_PREVIOUS_LABEL);
            this.scanNext = new ScanButton(SCAN_NEXT_LABEL);
            ActionListener actionListener = this.createScanActionListener();
            this.scanPrevious.addActionListener(actionListener);
            this.scanNext.addActionListener(actionListener);
            this.add(this.scanPrevious);
            this.add(this.scanNext);
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("back")) {
                    DasAxis.this.setDataRangePrev();
                }
            }
        };
    }

    private ActionListener createScanActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals(DasAxis.SCAN_PREVIOUS_LABEL)) {
                    DasAxis.this.scanPrevious();
                } else if (string.equals(DasAxis.SCAN_NEXT_LABEL)) {
                    DasAxis.this.scanNext();
                }
            }
        };
    }

    private PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if (string.equals("log")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("log", object, object2);
                } else if (string.equals("minimum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMinimum", object, object2);
                } else if (string.equals("maximum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMaximum", object, object2);
                }
                DasAxis.this.markDirty();
            }
        };
    }

    private void installMouseModules() {
        if (this.zoom instanceof HorizontalRangeSelectorMouseModule) {
            ((HorizontalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        } else if (this.zoom instanceof VerticalRangeSelectorMouseModule) {
            ((VerticalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        }
        if (this.isHorizontal()) {
            this.zoom = new HorizontalRangeSelectorMouseModule(this, this);
            ((HorizontalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
        } else {
            this.zoom = new VerticalRangeSelectorMouseModule(this, this);
            ((VerticalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
        }
    }

    public void setOrientation(int n) {
        boolean bl = this.isHorizontal();
        this.setOrientationInternal(n);
        if (bl != this.isHorizontal()) {
            this.installMouseModules();
        }
    }

    private void setOrientationInternal(int n) {
        this.orientation = n;
        if (n == 1) {
            this.setTickDirection(995);
        } else if (n == 2) {
            this.setTickDirection(996);
        } else if (n == 3) {
            this.setTickDirection(4);
        } else if (n == 4) {
            this.setTickDirection(3);
        } else {
            throw new IllegalArgumentException("Invalid value for orientation");
        }
    }

    public void setDataRange(Datum datum, Datum datum2) {
        if (!datum2.gt(datum)) {
            DasDie.println(DasDie.CRITICAL, "setDataRange where min > max ignored");
            return;
        }
        Units units = this.dataRange.getUnits();
        if (datum.getUnits() != units) {
            datum.convertTo(units);
            datum2.convertTo(units);
        }
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        this.animateChange(d, d2, datum.doubleValue(this.getUnits()), datum2.doubleValue(this.getUnits()));
        this.dataRange.setRange(datum.doubleValue(this.getUnits()), datum2.doubleValue(this.getUnits()));
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    private void createAndFireRangeSelectionEvent() {
        if (this.getUnits() instanceof TimeLocationUnits) {
            TimeRangeSelectionEvent timeRangeSelectionEvent = new TimeRangeSelectionEvent(this, this.getDataMinimum(), this.getDataMaximum());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(timeRangeSelectionEvent);
        }
    }

    public void setDataRange(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            d = d < dArray[n] ? d : dArray[n];
            d2 = d2 > dArray[n] ? d2 : dArray[n];
            ++n;
        }
        double d3 = d2 - d;
        if (this.isLog()) {
            this.setDataRange(Datum.create(d, this.getUnits()), Datum.create(d2, this.getUnits()));
        } else {
            Datum datum = Datum.create(d - d3 * 0.05, this.getUnits());
            Datum datum2 = Datum.create(d2 + d3 * 0.05, this.getUnits());
            this.setDataRange(datum, datum2);
        }
    }

    public void setDataRangePrev() {
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        this.dataRange.setRangePrev();
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        this.animateChange(d, d2, d3, d4);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public void setDataRangeForward() {
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        this.dataRange.setRangeForward();
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        this.animateChange(d, d2, d3, d4);
        this.update();
        this.createAndFireRangeSelectionEvent();
    }

    public void setDataRangeZoomOut() {
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        if (this.isLog()) {
            d = Math.log(d);
            d2 = Math.log(d2);
        }
        double d3 = d2 - d;
        double d4 = d - d3 / 2.0;
        double d5 = d2 + d3 / 2.0;
        if (this.isLog()) {
            d4 = Math.exp(d4);
            d5 = Math.exp(d5);
        }
        this.animateChange(d, d2, d4, d5);
        this.dataRange.setRange(d4, d5);
    }

    public DataRange getDataRange() {
        return this.dataRange;
    }

    protected void deviceRangeChanged() {
    }

    public Datum getDataMinimum() {
        Datum datum = Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits());
        return datum;
    }

    public Datum getDataMaximum() {
        Datum datum = Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits());
        return datum;
    }

    public double getDataMaximum(Units units) {
        double d = units != this.dataRange.getUnits() ? this.dataRange.getUnits().getConverter(units).convert(this.dataRange.getMaximum()) : this.dataRange.getMaximum();
        return d;
    }

    public double getDataMinimum(Units units) {
        double d = units != this.dataRange.getUnits() ? this.dataRange.getUnits().getConverter(units).convert(this.dataRange.getMinimum()) : this.dataRange.getMinimum();
        return d;
    }

    public void setDataMaximum(Datum datum) {
        this.dataRange.setMaximum(datum.doubleValue(this.getUnits()));
        this.update();
    }

    public void setDataMinimum(Datum datum) {
        this.dataRange.setMinimum(datum.doubleValue(this.getUnits()));
        this.update();
    }

    public boolean isLog() {
        return this.dataRange.isLog();
    }

    public void setLog(boolean bl) {
        boolean bl2 = this.isLog();
        this.dataRange.setLog(bl);
        this.update();
        if (bl != bl2) {
            this.firePropertyChange("log", bl2, bl);
        }
    }

    public Units getUnits() {
        return this.dataRange.getUnits();
    }

    public void setUnits(Units units) {
        this.dataRange.setUnits(units);
    }

    public void setOppositeAxisVisible(boolean bl) {
        if (bl == this.oppositeAxisVisible) {
            return;
        }
        boolean bl2 = this.oppositeAxisVisible;
        this.oppositeAxisVisible = bl;
        this.revalidate();
        this.repaint();
        this.firePropertyChange("oppositeAxisVisible", bl2, bl);
    }

    public boolean isOppositeAxisVisible() {
        return this.oppositeAxisVisible;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String string2 = this.axisLabel;
        this.axisLabel = string;
        this.update();
        this.firePropertyChange("label", string2, string);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public boolean getDrawTca() {
        return this.drawTca;
    }

    public void setDrawTca(boolean bl) {
        boolean bl2 = this.drawTca;
        if (bl && this.getOrientation() != 2) {
            throw new IllegalArgumentException("Vertical time axes cannot have annotations");
        }
        if (this.drawTca == bl) {
            return;
        }
        this.drawTca = bl;
        this.markDirty();
        this.update();
        this.firePropertyChange("showTca", bl2, bl);
    }

    public String getDataPath() {
        return this.dataset;
    }

    public void setDataPath(String string) {
        if (string == null) {
            throw new NullPointerException("null dataPath string not allowed");
        }
        String string2 = this.dataset;
        if (string.equals(this.dataset)) {
            return;
        }
        this.dataset = string;
        try {
            this.dsd = DataSetDescriptor.create(string);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        this.markDirty();
        this.update();
        this.firePropertyChange("dataPath", string2, string);
    }

    private void updateDataSet() {
        Datum datum;
        Datum datum2;
        Datum datum3;
        if (!this.drawTca || this.dataset.equals("") || this.dsd == null) {
            return;
        }
        double[] dArray = this.getTickV().tickV;
        if (dArray.length == 1) {
            datum3 = Datum.create(dArray[0], this.getTickV().units);
            datum2 = Datum.create(dArray[0], this.getTickV().units);
            datum = datum2.subtract(datum3);
        } else {
            datum3 = Datum.create(dArray[0], this.getTickV().units);
            datum2 = Datum.create(dArray[dArray.length - 1], this.getTickV().units);
            datum = datum2.subtract(datum3).divide(dArray.length - 1);
        }
        datum2 = datum2.add(datum);
        Datum datum4 = datum;
        this.tcaData = null;
        DataRequestor dataRequestor = new DataRequestor(){

            public void currentByteCount(int n) {
            }

            public void totalByteCount(int n) {
            }

            public void exception(Exception exception) {
                if (!(exception instanceof InterruptedIOException)) {
                    if (exception instanceof DasException) {
                        DasExceptionHandler.handle(exception);
                        this.finished(null);
                    } else {
                        Object[] objectArray = new Object[]{"Error reading data set", new JEditorPane("text/html", exception.getMessage())};
                        ((JEditorPane)objectArray[1]).setEditable(false);
                        DasExceptionHandler.handle(exception);
                        this.finished(null);
                    }
                }
            }

            public void finished(DataSet dataSet) {
                if (dataSet != null) {
                    VectorDataSet vectorDataSet = (VectorDataSet)dataSet;
                    List list = (List)vectorDataSet.getProperty("plane-list");
                    VectorDataSet[] vectorDataSetArray = new VectorDataSet[list.size()];
                    vectorDataSetArray[0] = vectorDataSet;
                    int n = 1;
                    while (n < list.size()) {
                        vectorDataSetArray[n] = (VectorDataSet)vectorDataSet.getPlanarView((String)list.get(n));
                        ++n;
                    }
                    DasAxis.access$302(DasAxis.this, vectorDataSetArray);
                    DasAxis.this.update();
                }
            }
        };
        if (this.drt == null) {
            this.drt = new DataRequestThread();
        }
        try {
            this.drt.request(this.dsd, datum3, datum2.add(Datum.create(1.0, Units.seconds)), datum4, dataRequestor, null);
        }
        catch (InterruptedException interruptedException) {
            DasExceptionHandler.handle(interruptedException);
        }
    }

    public final int getDevicePosition() {
        if (this.orientation == 2) {
            return this.getRow().getDMaximum();
        }
        if (this.orientation == 1) {
            return this.getRow().getDMinimum();
        }
        if (this.orientation == 3) {
            return this.getColumn().getDMinimum();
        }
        return this.getColumn().getDMaximum();
    }

    public int getDLength() {
        if (this.isHorizontal()) {
            return this.getColumn().getWidth();
        }
        return this.getRow().getHeight();
    }

    public DasAxis getMasterAxis() {
        return this.dataRange.getCreator();
    }

    public void attachTo(DasAxis dasAxis) {
        DataRange dataRange = this.dataRange;
        this.dataRange = dasAxis.dataRange;
        dataRange.removePropertyChangeListener("log", this.dataRangePropertyListener);
        dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        if (dataRange.isLog() != this.dataRange.isLog()) {
            this.firePropertyChange("log", dataRange.isLog(), this.dataRange.isLog());
        }
        this.firePropertyChange("minimum", dataRange.getMinimum(), this.dataRange.getMinimum());
        this.firePropertyChange("maximum", dataRange.getMaximum(), this.dataRange.getMaximum());
    }

    public void detach() {
        DataRange dataRange;
        this.dataRange.removePropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange = dataRange = new DataRange(this, Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits()), Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits()), this.dataRange.isLog());
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    public boolean isAttached() {
        return this != this.getMasterAxis();
    }

    protected TickVDescriptor getTickV() {
        if (this.tickV == null) {
            this.updateTickV();
        }
        return this.tickV;
    }

    private void updateTickVLog() {
        TickVDescriptor tickVDescriptor = new TickVDescriptor();
        tickVDescriptor.units = this.dataRange.getUnits();
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        double d3 = DasMath.roundNDigits(DasMath.log10(d), 4);
        int n = (int)Math.ceil(d3);
        double d4 = DasMath.roundNDigits(DasMath.log10(d2), 4);
        int n2 = (int)Math.floor(d4);
        int n3 = 1;
        int n4 = (n2 - n) / n3 + 1;
        int n5 = this.isHorizontal() ? this.getColumn().getWidth() / n4 : this.getRow().getHeight() / n4;
        if (n4 > 5 && n5 < 30 && n5 > 0) {
            n3 = (int)Math.floor((double)(n2 - n) / 5.0);
            n = (int)Math.ceil((float)n / (float)n3) * n3;
            n2 = (int)Math.floor((float)n2 / (float)n3) * n3;
            n4 = (n2 - n) / n3 + 1;
        }
        double[] dArray = new double[n4];
        int n6 = 0;
        while (n6 < n4) {
            dArray[n6] = DasMath.exp10(n6 * n3 + n);
            ++n6;
        }
        tickVDescriptor.tickV = dArray;
        if (DasMath.log10(d2 / d) >= 5.0 || DasMath.log10(d2) >= 5.0 || DasMath.log10(d) <= -5.0) {
            DatumFormatterFactory datumFormatterFactory = this.getUnits().getDatumFormatterFactory();
            if (datumFormatterFactory instanceof DefaultDatumFormatterFactory) {
                try {
                    this.datumFormatter = datumFormatterFactory.newFormatter("0E0");
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(parseException);
                }
            } else {
                this.datumFormatter = datumFormatterFactory.defaultFormatter();
            }
        } else {
            this.datumFormatter = DatumUtil.bestFormatter(tickVDescriptor.units.createDatum(DasMath.exp10(n)), tickVDescriptor.units.createDatum(DasMath.exp10(n2)), n4 - 1);
        }
        int n7 = (int)Math.floor(DasMath.log10(d));
        int n8 = (int)Math.floor(DasMath.log10(d2));
        int n9 = 0;
        double[] dArray2 = new double[(n8 - n7 + 1) * 9];
        int n10 = n7;
        while (n10 <= n8) {
            int n11 = 0;
            while (n11 < 9) {
                try {
                    dArray2[n9++] = DasMath.exp10(n10) + DasMath.exp10(n10) * (double)n11;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
                ++n11;
            }
            ++n10;
        }
        tickVDescriptor.minorTickV = dArray2;
        if (n >= n2) {
            double[] dArray3 = new double[tickVDescriptor.tickV.length + tickVDescriptor.minorTickV.length];
            int n12 = 0;
            while (n12 < tickVDescriptor.tickV.length) {
                dArray3[n12] = tickVDescriptor.tickV[n12];
                ++n12;
            }
            int n13 = 0;
            while (n13 < tickVDescriptor.minorTickV.length) {
                dArray3[n13 + tickVDescriptor.tickV.length] = tickVDescriptor.minorTickV[n13];
                ++n13;
            }
        }
        this.tickV = tickVDescriptor;
    }

    private void updateTickVLinear() {
        int n;
        int n2;
        int n3;
        if (this.isHorizontal()) {
            n3 = this.getFontMetrics(this.getTickLabelFont()).stringWidth("0.0000");
            n2 = this.getColumn().getWidth();
            n = n2 / n3;
        } else {
            n3 = this.getFontMetrics(this.getTickLabelFont()).getHeight();
            n2 = this.getRow().getHeight();
            n = n2 / n3;
        }
        n = n < 7 ? n : 7;
        TickVDescriptor tickVDescriptor = new TickVDescriptor();
        tickVDescriptor.units = this.dataRange.getUnits();
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        double d3 = (d2 - d) / (double)n;
        double d4 = Math.exp(Math.log(10.0) * Math.floor(Math.log(d3) / Math.log(10.0)));
        double d5 = d3 / d4;
        d5 = d5 < 1.666 ? 1.0 : (d5 < 3.333 ? 2.0 : 5.0);
        double d6 = d2 - d;
        double d7 = d5 * d4;
        double d8 = d7 * Math.ceil((d - d6) / d7 - 0.01);
        double d9 = d7 * Math.floor((d2 + d6) / d7 + 0.01);
        int n4 = 1 + (int)Math.round((d9 - d8) / d7);
        double[] dArray = new double[n4];
        int n5 = 0;
        while (n5 < n4) {
            dArray[n5] = d8 + (double)n5 * d7;
            ++n5;
        }
        tickVDescriptor.tickV = dArray;
        double d10 = d5 == 5.0 ? d7 / 5.0 : (d5 == 2.0 ? d7 / 2.0 : d7 / 4.0);
        this.datumFormatter = DatumUtil.bestFormatter(tickVDescriptor.units.createDatum(d8), tickVDescriptor.units.createDatum(d9), n4 - 1);
        double d11 = d10 * Math.ceil((d - d6) / d10);
        double d12 = d10 * Math.floor((d2 + d6) / d10);
        int n6 = (int)((d12 - d11) / d10 + 0.5);
        double[] dArray2 = new double[n6];
        int n7 = 0;
        while (n7 < n6) {
            dArray2[n7] = d11 + (double)n7 * d10;
            ++n7;
        }
        tickVDescriptor.minorTickV = dArray2;
        this.tickV = tickVDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private void updateTickVTime() {
        void var29_30;
        int n;
        int n2;
        int n3;
        reference var20_16;
        reference var18_15;
        Object object;
        int n4;
        int n5;
        Object object2;
        TickVDescriptor tickVDescriptor = new TickVDescriptor();
        double d = this.getDataMinimum().doubleValue(Units.t2000);
        double d2 = this.getDataMaximum().doubleValue(Units.t2000);
        if (this.isHorizontal()) {
            object2 = new GrannyTextRenderer();
            ((GrannyTextRenderer)object2).setString(this, "0000-00-00");
            n5 = (int)((GrannyTextRenderer)object2).getWidth();
            int n6 = this.getColumn().getWidth();
            n4 = n6 / n5;
        } else {
            int n7 = this.getFontMetrics(this.getTickLabelFont()).getHeight();
            n5 = this.getRow().getHeight();
            n4 = n5 / n7;
        }
        n4 = n4 > 1 ? n4 : 2;
        n4 = n4 < 10 ? n4 : 10;
        object2 = new double[]{0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 30.0, 60.0, 120.0, 300.0, 600.0, 1200.0, 3600.0, 7200.0, 10800.0, 14400.0, 21600.0, 28800.0, 43200.0, 86400.0, 172800.0, 432000.0, 864000.0};
        int[] nArray = new int[]{4, 4, 5, 4, 4, 5, 4, 4, 5, 4, 4, 5, 5, 3, 6, 4, 5, 5, 4, 4, 4, 3, 4, 3, 4, 6, 4, 2, 5, 10};
        Object object3 = -1.0;
        int n8 = 0;
        int n9 = -1;
        if (d2 - d > 86400.0) {
            n8 = 4;
        }
        while (n8 < ((Object)object2).length && n9 == -1) {
            Object object4;
            object = object4 = object2[n8];
            var18_15 = object * Math.ceil(d / object);
            var20_16 = object * Math.floor(d2 / object);
            n3 = (var20_16 - var18_15) / object > 1000.0 ? 1000 : 1 + (int)((var20_16 - var18_15) / object);
            if (n3 < n4) {
                n9 = n8;
            }
            ++n8;
        }
        if (n9 != -1) {
            object3 = object2[n9];
            double d3 = 1.0;
            object = d3 * object3;
            double d4 = d2 - d;
            var18_15 = object * Math.ceil((d - d4) / object);
            var20_16 = object * Math.floor((d2 + d4) / object);
            n3 = 1 + (int)Math.round((double)((var20_16 - var18_15) / object));
            if (n3 < 2) {
                DasDie.println("Only able to find one major tick--sorry! ");
                DasDie.println("please let us know how you entered this condition");
                n3 = 2;
            }
            double[] dArray = new double[n3];
            n8 = 0;
            while (n8 < n3) {
                dArray[n8] = (double)(var18_15 + (double)n8 * object);
                ++n8;
            }
            tickVDescriptor.tickV = dArray;
            reference var23_23 = object / (double)nArray[n9];
            reference var29_24 = var23_23 * Math.ceil((d - d4) / var23_23);
            reference var31_31 = var23_23 * Math.floor((d2 + d4) / var23_23);
            n2 = (int)((var31_31 - var29_24) / var23_23 + 0.5);
            double[] dArray2 = new double[n2];
            n = 0;
            while (n < n2) {
                dArray2[n] = (double)(var29_24 + (double)n * var23_23);
                ++n;
            }
            tickVDescriptor.minorTickV = dArray2;
            this.datumFormatter = DatumUtil.bestFormatter(Units.t2000.createDatum((double)var18_15), Units.t2000.createDatum((double)var20_16), n3 - 1);
        } else {
            void var29_28;
            void n15;
            int n6;
            double[] dArray = new double[30];
            ArrayList<Datum> arrayList = new ArrayList<Datum>();
            boolean n11 = false;
            Datum datum = Datum.create(d, (Units)Units.t2000);
            Datum datum2 = Datum.create(d2, (Units)Units.t2000);
            int n7 = 1;
            int n10 = 1;
            if (d2 - d < 1.5552E7) {
                n2 = 2;
                n = 3;
                n10 = 1;
            } else if (d2 - d < 6.48E7) {
                n2 = 98;
                n = 2;
            } else if (d2 - d < 1.89216E8) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 1;
                n = 1;
                n7 = 2;
            }
            Datum datum3 = TimeUtil.prev(n2, TimeUtil.prev(n2, datum));
            Datum datum4 = TimeUtil.next(n2, TimeUtil.next(n2, datum2));
            Datum datum5 = datum3;
            while (datum4.ge(datum5)) {
                dArray[++n15] = datum5.doubleValue(Units.t2000);
                datum5 = TimeUtil.next(n2, datum5);
                n6 = n7;
                while (n6 > 1) {
                    datum5 = TimeUtil.next(n2, datum5);
                    --n6;
                }
            }
            tickVDescriptor.tickV = new double[n15];
            boolean bl = false;
            while (var29_28 < tickVDescriptor.tickV.length) {
                tickVDescriptor.tickV[var29_28] = dArray[var29_28];
                ++var29_28;
            }
            datum5 = datum3;
            while (datum4.ge(datum5)) {
                arrayList.add(datum5);
                datum5 = TimeUtil.next(n, datum5);
                n6 = n10;
                while (n6 > 1) {
                    datum5 = TimeUtil.next(n, datum5);
                    --n6;
                }
            }
            tickVDescriptor.minorTickV = new double[arrayList.size()];
            n6 = 0;
            while (n6 < arrayList.size()) {
                tickVDescriptor.minorTickV[n6] = ((Datum)arrayList.get(n6)).doubleValue(Units.t2000);
                ++n6;
            }
            this.datumFormatter = DatumUtil.bestFormatter(datum3, datum4, 6);
        }
        tickVDescriptor.units = this.getUnits();
        UnitsConverter unitsConverter = Units.getConverter(Units.t2000, tickVDescriptor.units);
        int n11 = 0;
        while (n11 < tickVDescriptor.tickV.length) {
            tickVDescriptor.tickV[n11] = unitsConverter.convert(tickVDescriptor.tickV[n11]);
            ++n11;
        }
        boolean bl = false;
        while (var29_30 < tickVDescriptor.minorTickV.length) {
            tickVDescriptor.minorTickV[var29_30] = unitsConverter.convert(tickVDescriptor.minorTickV[var29_30]);
            ++var29_30;
        }
        this.tickV = tickVDescriptor;
        this.updateDataSet();
    }

    protected void updateTickV() {
        if (this.getUnits() instanceof TimeLocationUnits) {
            this.updateTickVTime();
        } else if (this.dataRange.isLog()) {
            this.updateTickVLog();
        } else {
            this.updateTickVLinear();
        }
    }

    private double pixelSizeData() {
        Units units = this.getUnits();
        return (this.getDataMaximum().doubleValue(units) - this.getDataMinimum().doubleValue(units)) / (double)this.getDLength();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.translate(-this.getX(), -this.getY());
        if (this.isHorizontal()) {
            this.paintHorizontalAxis(graphics2D);
        } else {
            this.paintVerticalAxis(graphics2D);
        }
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.drawTca && this.getOrientation() == 2 && this.tcaData != null && this.blLabelRect != null && this.blLabelRect.intersects(rectangle)) {
            int n = this.getRow().getDMaximum();
            int n2 = this.getColumn().getDMinimum();
            Font font = this.getTickLabelFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n3 = font.getSize() * 2 / 3;
            int n4 = fontMetrics.stringWidth(" ");
            int n5 = font.getSize() + this.getLineSpacing();
            int n6 = this.getMaxLabelWidth(fontMetrics);
            int n7 = n + n3 + n4 + font.getSize();
            int n8 = n2 - fontMetrics.stringWidth("0000") - n4;
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            int n9 = 0;
            while (n9 < this.tcaData.length) {
                grannyTextRenderer.setString(this, (String)this.tcaData[n9].getProperty("label"));
                int n10 = (int)Math.floor(grannyTextRenderer.getWidth() + 0.5);
                int n11 = n8 - n10;
                grannyTextRenderer.draw(graphics2D, n11, n7 += n5);
                ++n9;
            }
        }
    }

    protected void paintHorizontalAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        Rectangle rectangle = graphics2D.getClipBounds();
        boolean bl = (this.orientation == 2 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(rectangle);
        boolean bl2 = (this.orientation == 2 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(rectangle);
        boolean bl3 = this.orientation == 2 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(rectangle);
        boolean bl4 = this.orientation == 2 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(rectangle);
        boolean bl5 = (this.orientation == 1 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(rectangle);
        boolean bl6 = (this.orientation == 1 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(rectangle);
        boolean bl7 = this.orientation == 1 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(rectangle);
        boolean bl8 = this.orientation == 1 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(rectangle);
        int n3 = this.getRow().getDMinimum() - 1;
        int n4 = this.getRow().getDMaximum();
        int n5 = this.getColumn().getDMaximum();
        int n6 = this.getColumn().getDMinimum();
        Font font = this.getTickLabelFont();
        double d = this.dataRange.getMaximum();
        double d2 = this.dataRange.getMinimum();
        TickVDescriptor tickVDescriptor = this.getTickV();
        double[] dArray = tickVDescriptor.tickV;
        if (bl) {
            graphics2D.drawLine(n6, n4, n5, n4);
        }
        if (bl5) {
            graphics2D.drawLine(n6, n3, n5, n3);
        }
        int n7 = font.getSize() * 2 / 3;
        int n8 = n7 / 2;
        int n9 = 0;
        while (n9 < tickVDescriptor.tickV.length) {
            double d3 = tickVDescriptor.tickV[n9];
            if (d3 >= d2 - this.pixelSizeData() / 2.0 && d3 <= d + this.pixelSizeData() / 2.0) {
                n2 = (int)Math.floor((double)this.transform(d3, tickVDescriptor.units) + 0.5);
                n = n7;
                if (bl2) {
                    graphics2D.drawLine(n2, n4, n2, n4 + n);
                }
                if (bl3) {
                    this.drawLabel(graphics2D, d3, n9, n2, n4 + n);
                }
                if (bl6) {
                    graphics2D.drawLine(n2, n3, n2, n3 - n);
                }
                if (bl7) {
                    this.drawLabel(graphics2D, d3, n9, n2, n3 - n);
                }
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < tickVDescriptor.minorTickV.length) {
            double d4 = tickVDescriptor.minorTickV[n10];
            if (d4 >= d2 && d4 <= d) {
                n = n8;
                int n11 = (int)Math.floor((double)this.transform(d4, tickVDescriptor.units) + 0.5);
                if (bl2) {
                    graphics2D.drawLine(n11, n4, n11, n4 + n);
                }
                if (bl6) {
                    graphics2D.drawLine(n11, n3, n11, n3 - n);
                }
            }
            ++n10;
        }
        if (!this.axisLabel.equals("")) {
            int n12;
            int n13;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            n2 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            int n14 = (int)grannyTextRenderer.getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl4) {
                n13 = n6 + (n5 - n6 - n14) / 2;
                n12 = n4 + n2;
                grannyTextRenderer.draw(graphics2D2, n13, n12);
            }
            if (bl8) {
                n13 = n6 + (n5 - n6 - n14) / 2;
                n12 = n3 - n2;
                grannyTextRenderer.draw(graphics2D2, n13, n12);
            }
            graphics2D2.dispose();
        }
    }

    protected void paintVerticalAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        Rectangle rectangle = graphics2D.getClipBounds();
        boolean bl = (this.orientation == 3 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(rectangle);
        boolean bl2 = (this.orientation == 3 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(rectangle);
        boolean bl3 = this.orientation == 3 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(rectangle);
        boolean bl4 = this.orientation == 3 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(rectangle);
        boolean bl5 = (this.orientation == 4 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(rectangle);
        boolean bl6 = (this.orientation == 4 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(rectangle);
        boolean bl7 = this.orientation == 4 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(rectangle);
        boolean bl8 = this.orientation == 4 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(rectangle);
        int n3 = this.getColumn().getDMinimum() - 1;
        int n4 = this.getColumn().getDMaximum();
        int n5 = this.getRow().getDMaximum();
        int n6 = this.getRow().getDMinimum();
        Font font = this.getTickLabelFont();
        double d = this.dataRange.getMaximum();
        double d2 = this.dataRange.getMinimum();
        TickVDescriptor tickVDescriptor = this.getTickV();
        double[] dArray = tickVDescriptor.tickV;
        if (bl) {
            graphics2D.drawLine(n3, n6, n3, n5);
        }
        if (bl5) {
            graphics2D.drawLine(n4, n6, n4, n5);
        }
        int n7 = font.getSize() * 2 / 3;
        int n8 = n7 / 2;
        int n9 = 0;
        while (n9 < tickVDescriptor.tickV.length) {
            double d3 = tickVDescriptor.tickV[n9];
            if (d3 >= d2 * 0.999 && d3 <= d * 1.001) {
                n2 = (int)Math.floor((double)this.transform(d3, tickVDescriptor.units) + 0.5);
                n = n7;
                if (bl2) {
                    graphics2D.drawLine(n3, n2, n3 - n, n2);
                }
                if (bl3) {
                    this.drawLabel(graphics2D, d3, n9, n3 - n, n2);
                }
                if (bl6) {
                    graphics2D.drawLine(n4, n2, n4 + n, n2);
                }
                if (bl7) {
                    this.drawLabel(graphics2D, d3, n9, n4 + n, n2);
                }
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < tickVDescriptor.minorTickV.length) {
            n = n8;
            double d4 = tickVDescriptor.minorTickV[n10];
            if (d4 >= d2 && d4 <= d) {
                int n11 = (int)Math.floor((double)this.transform(d4, tickVDescriptor.units) + 0.5);
                n = n8;
                if (bl2) {
                    graphics2D.drawLine(n3, n11, n3 - n, n11);
                }
                if (bl6) {
                    graphics2D.drawLine(n4, n11, n4 + n, n11);
                }
            }
            ++n10;
        }
        if (!this.axisLabel.equals("")) {
            int n12;
            int n13;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            n2 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            int n14 = (int)grannyTextRenderer.getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl4) {
                graphics2D2.rotate(-1.5707963267948966);
                n13 = -n5 + (n5 - n6 - n14) / 2;
                n12 = n3 - n2;
                grannyTextRenderer.draw(graphics2D2, n13, n12);
            }
            if (bl8) {
                graphics2D2.rotate(1.5707963267948966);
                n13 = n6 + (n5 - n6 - n14) / 2;
                n12 = -n4 - n2;
                grannyTextRenderer.draw(graphics2D2, n13, n12);
            }
            graphics2D2.dispose();
        }
    }

    protected int getTitlePositionOffset() {
        Font font = this.getTickLabelFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Font font2 = this.getLabelFont();
        int n = font.getSize() * 2 / 3;
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.axisLabel);
        int n2 = this.orientation == 2 ? font.getSize() + n + fontMetrics.stringWidth(" ") + font2.getSize() + font2.getSize() / 2 : (this.orientation == 1 ? n + fontMetrics.stringWidth(" ") + font2.getSize() + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent() : (this.orientation == 3 ? n + this.getMaxLabelWidth(fontMetrics) + fontMetrics.stringWidth(" ") + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent() : n + this.getMaxLabelWidth(fontMetrics) + fontMetrics.stringWidth(" ") + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent()));
        if (this.getOrientation() == 2) {
            if (this.drawTca && this.tcaData != null) {
                n2 += this.tcaData.length * (font.getSize() + this.getLineSpacing());
            }
            n2 += font.getSize() + this.getLineSpacing();
        }
        return n2;
    }

    public int getLineSpacing() {
        return this.getTickLabelFont().getSize() / 4;
    }

    protected void drawLabel(Graphics graphics, double d, int n, int n2, int n3) {
        if (!this.tickLabelsVisible) {
            return;
        }
        String string = this.tickFormatter(d);
        graphics.setFont(this.getTickLabelFont());
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, string);
        int n4 = (int)grannyTextRenderer.getWidth();
        int n5 = (int)grannyTextRenderer.getHeight();
        int n6 = (int)grannyTextRenderer.getAscent();
        int n7 = this.getFontMetrics(this.getTickLabelFont()).stringWidth(" ");
        if (this.orientation == 2) {
            n2 -= n4 / 2;
            n3 += this.getTickLabelFont().getSize() + n7;
        } else if (this.orientation == 1) {
            n2 -= n4 / 2;
            n3 = (int)((double)n3 - ((double)n7 + grannyTextRenderer.getDescent()));
        } else if (this.orientation == 3) {
            n2 -= n4 + n7;
            n3 += n6 - n5 / 2;
        } else {
            n2 += n7;
            n3 += n6 - n5 / 2;
        }
        Color color = graphics.getColor();
        grannyTextRenderer.draw(graphics, n2, n3);
        if (this.orientation == 2 && this.drawTca && this.tcaData != null) {
            this.drawTCAItems(graphics, n, n2, n3, n4);
        }
    }

    private void drawTCAItems(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getTickLabelFont().getSize();
        int n6 = this.getFontMetrics(this.getTickLabelFont()).stringWidth(" ");
        int n7 = n3;
        int n8 = n2;
        int n9 = n8 + n4;
        Font font = this.getTickLabelFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n10 = font.getSize() + this.getLineSpacing();
        int n11 = 0;
        while (n11 < this.tcaData.length) {
            String string = DasAxis.format(this.tcaData[n11].getDouble(n, this.tcaData[n11].getYUnits()), "(f8.2)");
            n4 = fontMetrics.stringWidth(string);
            n8 = n9 - n4;
            graphics.drawString(string, n8, n7 += n10);
            ++n11;
        }
    }

    public Font getTickLabelFont() {
        return this.getFont();
    }

    public void setTickLabelFont(Font font) {
    }

    public Font getLabelFont() {
        return this.getFont();
    }

    public void setLabelFont(Font font) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }

    private void setTickDirection(int n) {
        if (n == 995 || n == 4) {
            this.tickDirection = -1;
        } else if (n == 996 || n == 3) {
            this.tickDirection = 1;
        } else {
            throw new IllegalArgumentException("Invalid tick direction");
        }
    }

    protected int getMaxLabelWidth(FontMetrics fontMetrics) {
        TickVDescriptor tickVDescriptor = this.getTickV();
        double[] dArray = tickVDescriptor.tickV;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        while (n2 < dArray.length) {
            String string = this.tickFormatter(dArray[n2]);
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, string);
            int n3 = (int)Math.round(grannyTextRenderer.getWidth());
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public void resize() {
        this.setBounds(this.getAxisBounds());
        this.invalidate();
        this.validate();
    }

    protected Rectangle getAxisBounds() {
        Rectangle rectangle = this.isHorizontal() ? this.getHorizontalAxisBounds() : this.getVerticalAxisBounds();
        if (this.getOrientation() == 2 && this.areTickLabelsVisible()) {
            if (this.drawTca && this.tcaData != null) {
                int n;
                int n2 = this.getColumn().getDMinimum();
                int n3 = this.getColumn().getDMaximum();
                Font font = this.getTickLabelFont();
                int n4 = this.getFontMetrics(font).stringWidth(" ");
                int n5 = (font.getSize() + this.getLineSpacing()) * this.tcaData.length;
                int n6 = this.getMaxLabelWidth(this.getFontMetrics(font));
                rectangle.height += n5;
                this.blLabelRect.height += n5;
                this.blTitleRect.y += n5;
                GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
                grannyTextRenderer.setString(this, "SCET");
                int n7 = (int)Math.floor(grannyTextRenderer.getWidth() + 0.5);
                int n8 = 0;
                while (n8 < this.tcaData.length) {
                    grannyTextRenderer.setString(this, (String)this.tcaData[n8].getProperty("label"));
                    n = (int)Math.floor(grannyTextRenderer.getWidth() + 0.5);
                    n7 = Math.max(n7, n);
                    ++n8;
                }
                if (n7 > 0) {
                    n = n2 - n7 - n4;
                    int n9 = Math.min(n - n6 / 2, rectangle.x);
                    int n10 = rectangle.x + rectangle.width;
                    rectangle.x = n9;
                    rectangle.width = n10 - n9;
                    this.blLabelRect.x = n9;
                    this.blLabelRect.width = n10 - n9;
                }
            }
            rectangle.height += this.getTickLabelFont().getSize() + this.getLineSpacing();
            if (this.getTickDirection() == -1) {
                rectangle.y -= this.getTickLabelFont().getSize() + this.getLineSpacing();
            }
        }
        return rectangle;
    }

    private Rectangle getHorizontalAxisBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.getRow().getDMinimum() - 1;
        int n11 = this.getRow().getDMaximum();
        DasColumn dasColumn = this.getColumn();
        int n12 = dasColumn.getDMaximum();
        int n13 = dasColumn.getDMinimum();
        boolean bl = this.orientation == 2 || this.oppositeAxisVisible;
        boolean bl2 = this.orientation == 2 && this.tickLabelsVisible;
        boolean bl3 = this.orientation == 2 && !this.axisLabel.equals("");
        boolean bl4 = this.orientation == 1 || this.oppositeAxisVisible;
        boolean bl5 = this.orientation == 1 && this.tickLabelsVisible;
        boolean bl6 = this.orientation == 1 && !this.axisLabel.equals("");
        Font font = this.getTickLabelFont();
        int n14 = font.getSize() * 2 / 3;
        if (bl) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(n13, n11, n12 - n13 + 1, 1);
        }
        if (bl4) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(n13, n10, n12 - n13 + 1, 1);
        }
        if (bl) {
            n9 = n13;
            n8 = n11 + 1;
            n7 = n12 - n13;
            n6 = n14;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, n9, n8, n7, n6);
        }
        if (bl4) {
            n9 = n13;
            n8 = n10 - n14;
            n7 = n12 - n13;
            n6 = n14;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, n9, n8, n7, n6);
        }
        n9 = this.getMaxLabelWidth(this.getFontMetrics(font));
        n8 = this.getFontMetrics(font).stringWidth(" ");
        if (bl2) {
            n7 = n13 - n9 / 2;
            n6 = this.blTickRect.y + this.blTickRect.height;
            n5 = n12 - n13 + n9;
            n4 = font.getSize() * 3 / 2 + n8;
            this.blLabelRect = DasAxis.setRectangleBounds(this.blLabelRect, n7, n6, n5, n4);
        }
        if (bl5) {
            n7 = n13 - n9 / 2;
            n6 = n10 - (font.getSize() * 3 / 2 + n8 + 1);
            n5 = n12 - n13 + n9;
            n4 = font.getSize() * 3 / 2 + n8;
            this.trLabelRect = DasAxis.setRectangleBounds(this.trLabelRect, n7, n6, n5, n4);
        }
        Font font2 = this.getLabelFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.getLabel());
        n5 = (int)grannyTextRenderer.getHeight() + font2.getSize() / 2;
        if (bl3) {
            n4 = n13;
            n3 = this.blLabelRect.y + this.blLabelRect.height;
            n2 = n12 - n13;
            n = n5;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, n4, n3, n2, n);
        }
        if (bl6) {
            n4 = n13;
            n3 = this.trLabelRect.y - n5;
            n2 = n12 - n13;
            n = n5;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, n4, n3, n2, n);
        }
        Rectangle rectangle = new Rectangle(this.orientation == 2 ? this.blLineRect : this.trLineRect);
        if (bl) {
            rectangle.add(this.blLineRect);
            rectangle.add(this.blTickRect);
        }
        if (bl2) {
            rectangle.add(this.blLabelRect);
        }
        if (bl3) {
            rectangle.add(this.blTitleRect);
        }
        if (bl4) {
            rectangle.add(this.trLineRect);
            rectangle.add(this.trTickRect);
        }
        if (bl5) {
            rectangle.add(this.trLabelRect);
        }
        if (bl6) {
            rectangle.add(this.trTitleRect);
        }
        if (this.scanPrevious != null && this.scanNext != null) {
            Dimension dimension = this.scanPrevious.getPreferredSize();
            Dimension dimension2 = this.scanPrevious.getPreferredSize();
            n2 = Math.min(n13 - dimension.width, rectangle.x);
            n = Math.max(n12 + dimension2.width, rectangle.x + rectangle.width);
            rectangle.x = n2;
            rectangle.width = n - n2;
        }
        return rectangle;
    }

    private Rectangle getVerticalAxisBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl = this.orientation == 3 || this.oppositeAxisVisible;
        boolean bl2 = this.orientation == 3 && this.tickLabelsVisible;
        boolean bl3 = this.orientation == 3 && !this.axisLabel.equals("");
        boolean bl4 = this.orientation == 4 || this.oppositeAxisVisible;
        boolean bl5 = this.orientation == 4 && this.tickLabelsVisible;
        boolean bl6 = this.orientation == 4 && !this.axisLabel.equals("");
        int n10 = this.getColumn().getDMinimum() - 1;
        int n11 = this.getColumn().getDMaximum();
        int n12 = this.getRow().getDMaximum();
        int n13 = this.getRow().getDMinimum();
        Font font = this.getTickLabelFont();
        int n14 = font.getSize() * 2 / 3;
        if (bl) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(n10, n13, 1, n12 - n13 + 1);
        }
        if (bl4) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(n11, n13, 1, n12 - n13 + 1);
        }
        if (bl) {
            n9 = n10 - n14;
            n8 = n13;
            n7 = n14;
            n6 = n12 - n13;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, n9, n8, n7, n6);
        }
        if (bl4) {
            n9 = n11 + 1;
            n8 = n13;
            n7 = n14;
            n6 = n12 - n13;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, n9, n8, n7, n6);
        }
        n9 = this.getMaxLabelWidth(this.getFontMetrics(font));
        n8 = this.getFontMetrics(font).stringWidth(" ");
        if (bl2) {
            n7 = this.blTickRect.x - (n9 + n8);
            n6 = n13 - font.getSize();
            n5 = n9 + n8;
            n4 = n12 - n13 + font.getSize() * 2;
            this.blLabelRect = DasAxis.setRectangleBounds(this.blLabelRect, n7, n6, n5, n4);
        }
        if (bl5) {
            n7 = this.trTickRect.x + this.trTickRect.width;
            n6 = n13 - font.getSize();
            n5 = n9 + n8;
            n4 = n12 - n13 + font.getSize() * 2;
            this.trLabelRect = DasAxis.setRectangleBounds(this.trLabelRect, n7, n6, n5, n4);
        }
        Font font2 = this.getLabelFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.getLabel());
        n5 = (int)grannyTextRenderer.getHeight() + font2.getSize() / 2;
        if (bl3) {
            n4 = this.blLabelRect.x - n5;
            n3 = n13;
            n2 = n5;
            n = n12 - n13;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, n4, n3, n2, n);
        }
        if (bl6) {
            n4 = this.trLabelRect.x + this.trLabelRect.width;
            n3 = n13;
            n2 = n5;
            n = n12 - n13;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, n4, n3, n2, n);
        }
        Rectangle rectangle = new Rectangle(this.orientation == 3 ? this.blLineRect : this.trLineRect);
        if (bl) {
            rectangle.add(this.blLineRect);
            rectangle.add(this.blTickRect);
        }
        if (bl2) {
            rectangle.add(this.blLabelRect);
        }
        if (bl3) {
            rectangle.add(this.blTitleRect);
        }
        if (bl4) {
            rectangle.add(this.trLineRect);
            rectangle.add(this.trTickRect);
        }
        if (bl5) {
            rectangle.add(this.trLabelRect);
        }
        if (bl6) {
            rectangle.add(this.trTitleRect);
        }
        return rectangle;
    }

    private static Rectangle setRectangleBounds(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (rectangle == null) {
            return new Rectangle(n, n2, n3, n4);
        }
        rectangle.setBounds(n, n2, n3, n4);
        return rectangle;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    public int getTickDirection() {
        return this.tickDirection;
    }

    public DatumFormatter getDatumFormatter() {
        return this.datumFormatter;
    }

    public int transform(Datum datum) {
        return this.transform(datum.doubleValue(this.getUnits()), this.getUnits());
    }

    int transform(double d, Units units) {
        if (this.isHorizontal()) {
            DasColumn dasColumn = this.getColumn();
            return this.transform(d, units, dasColumn.getDMinimum(), dasColumn.getDMaximum());
        }
        DasRow dasRow = this.getRow();
        return this.transform(d, units, dasRow.getDMaximum(), dasRow.getDMinimum());
    }

    int transform(double d, Units units, int n, int n2) {
        int n3;
        if (units != this.dataRange.getUnits()) {
            d = units.convertDoubleTo(this.dataRange.getUnits(), d);
        }
        int n4 = n2 - n;
        if (this.dataRange.isLog()) {
            double d2 = Math.log(d);
            double d3 = Math.log(this.dataRange.getMinimum());
            double d4 = Math.log(this.dataRange.getMaximum());
            double d5 = d4 - d3;
            n3 = (int)((double)n4 * (d2 - d3) / d5) + n;
        } else {
            double d6 = this.dataRange.getMinimum();
            double d7 = this.dataRange.getMaximum();
            double d8 = d7 - d6;
            n3 = (int)((double)n4 * (d - d6) / d8) + n;
        }
        if (n3 > 10000) {
            n3 = 10000;
        }
        if (n3 < -10000) {
            n3 = -10000;
        }
        return n3;
    }

    public Datum invTransform(int n) {
        double d;
        double d2;
        DasDevicePosition dasDevicePosition = this.isHorizontal() ? this.getColumn() : this.getRow();
        double d3 = (double)(n - dasDevicePosition.getDMinimum()) / (double)this.getDLength();
        if (!this.isHorizontal()) {
            d3 = 1.0 - d3;
        }
        if (this.dataRange.isLog()) {
            d2 = Math.log(this.dataRange.getMinimum());
            double d4 = Math.log(this.dataRange.getMaximum());
            double d5 = d4 - d2;
            double d6 = d5 * d3 + d2;
            d = Math.exp(d6);
        } else {
            d2 = this.dataRange.getMinimum();
            double d7 = this.dataRange.getMaximum();
            double d8 = d7 - d2;
            d = d8 * d3 + d2;
        }
        DatumFormatter datumFormatter = DatumUtil.bestFormatter(this.getDataMinimum(), this.getDataMaximum(), this.getDLength());
        Datum datum = Datum.create(d, this.dataRange.getUnits(), datumFormatter);
        return datum;
    }

    protected String tickFormatter(double d) {
        return this.datumFormatter.grannyFormat(Datum.create(d, this.getUnits()));
    }

    public void DataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        this.setDataRange(dataRangeSelectionEvent.getMinimum(), dataRangeSelectionEvent.getMaximum());
    }

    private Datum findTickLog(Datum datum, double d, boolean bl) {
        double d2;
        double d3 = datum.doubleValue(this.tickV.units);
        if (d > 0.0) {
            d2 = this.tickV.tickV[this.tickV.tickV.length - 1] * 10.0;
            int n = this.tickV.tickV.length - 1;
            while (n >= 0) {
                if (d3 < this.tickV.tickV[n]) {
                    d2 = this.tickV.tickV[n];
                }
                --n;
            }
        } else if (d < 0.0) {
            d2 = this.tickV.tickV[0] / 10.0;
            int n = 0;
            while (n < this.tickV.tickV.length) {
                if (d3 > this.tickV.tickV[n]) {
                    d2 = this.tickV.tickV[n];
                }
                ++n;
            }
        } else {
            d2 = -999.0;
            double d4 = Double.MAX_VALUE;
            int n = 0;
            while (n < this.tickV.tickV.length) {
                double d5 = Math.abs(Math.log(d3) - Math.log(this.tickV.tickV[n]));
                if (d5 < d4) {
                    d2 = this.tickV.tickV[n];
                    d4 = d5;
                }
                ++n;
            }
        }
        return Datum.create(d2, datum.getUnits());
    }

    public Datum findTick(Datum datum, double d, boolean bl) {
        if (this.tickV == null) {
            return datum;
        }
        double[] dArray = new double[this.tickV.tickV.length + this.tickV.minorTickV.length];
        int n = 0;
        while (n < this.tickV.tickV.length) {
            dArray[n] = this.tickV.tickV[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.tickV.minorTickV.length) {
            dArray[n2 + this.tickV.tickV.length] = this.tickV.minorTickV[n2];
            ++n2;
        }
        int n3 = 0;
        double d2 = Double.MAX_VALUE;
        double d3 = datum.doubleValue(this.tickV.units);
        int n4 = 0;
        while (n4 < dArray.length) {
            if (d < 0.0 && dArray[n4] < d3 && d3 - dArray[n4] < d2) {
                n3 = n4;
                d2 = d3 - dArray[n4];
            } else if (d > 0.0 && d3 < dArray[n4] && dArray[n4] - d3 < d2) {
                n3 = n4;
                d2 = dArray[n4] - d3;
            }
            if (d == 0.0 && Math.abs(dArray[n4] - d3) < d2) {
                n3 = n4;
                d2 = Math.abs(dArray[n4] - d3);
            }
            ++n4;
        }
        return Datum.create(dArray[n3], this.tickV.units);
    }

    private void animateChange(double d, double d2, double d3, double d4) {
        if (this.animated) {
            DataRange dataRange;
            boolean bl = this.getDrawTca();
            this.setDrawTca(false);
            long l = System.currentTimeMillis();
            DataRange dataRange2 = this.dataRange;
            this.dataRange = dataRange = this.dataRange.getAnimationDataRange();
            double d5 = 300.0;
            double d6 = (double)(System.currentTimeMillis() - l) / d5;
            while (d6 < 1.0) {
                d6 = (double)(System.currentTimeMillis() - l) / d5;
                double d7 = -3.0 + 6.0 * d6;
                double d8 = (DasMath.tanh(d7) + 1.0) / 2.0;
                double d9 = 1.0 - d8;
                if (this.isLog()) {
                    dataRange.setRange(Math.exp(Math.log(d) * d9 + Math.log(d3) * d8), Math.exp(Math.log(d2) * d9 + Math.log(d4) * d8));
                } else {
                    dataRange.setRange(d * d9 + d3 * d8, d2 * d9 + d4 * d8);
                }
                this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            }
            this.setDrawTca(bl);
            this.dataRange = dataRange2;
        }
    }

    protected void updateImmediately() {
        super.updateImmediately();
        this.updateTickV();
    }

    public boolean areTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (this.tickLabelsVisible == bl) {
            return;
        }
        boolean bl2 = this.ticksVisible;
        this.tickLabelsVisible = bl;
        this.update();
        this.firePropertyChange("tickLabelsVisible", bl2, bl);
    }

    protected void installComponent() {
        super.installComponent();
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    static DasAxis processAxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        Object object2;
        Datum datum;
        Datum datum2;
        Object object3;
        String string;
        String string2 = element.getAttribute("name");
        boolean bl = element.getAttribute("log").equals("true");
        if ("TIME".equals(element.getAttribute("units"))) {
            string = element.getAttribute("dataMinimum");
            object3 = element.getAttribute("dataMaximum");
            datum2 = string == null || string.equals("") ? TimeUtil.create("1979-02-26") : TimeUtil.create(string);
            datum = object3 == null || ((String)object3).equals("") ? TimeUtil.create("1979-02-27") : TimeUtil.create((String)object3);
        } else {
            string = element.getAttribute("dataMinimum");
            object3 = element.getAttribute("dataMaximum");
            datum2 = string == null || string.equals("") ? Datum.create(1.0) : Datum.create(Double.parseDouble(string));
            datum = object3 == null || ((String)object3).equals("") ? Datum.create(10.0) : Datum.create(Double.parseDouble((String)object3));
        }
        int n = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        object3 = new DasAxis(datum2, datum, n, bl);
        String string3 = element.getAttribute("row");
        if (!string3.equals("")) {
            object2 = (DasRow)formBase.checkValue(string3, class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
            ((DasCanvasComponent)object3).setRow((DasRow)object2);
        }
        if (!((String)(object2 = element.getAttribute("column"))).equals("")) {
            object = (DasColumn)formBase.checkValue((String)object2, class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
            ((DasCanvasComponent)object3).setColumn((DasColumn)object);
        }
        ((DasAxis)object3).setLabel(element.getAttribute("label"));
        ((DasAxis)object3).setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        ((DasAxis)object3).setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        ((DasCanvasComponent)object3).setDasName(string2);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string2, object3);
        return object3;
    }

    protected static String orientationToString(int n) {
        switch (n) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        throw new IllegalStateException("invalid orienation: " + n);
    }

    protected static int parseOrientationString(String string) {
        if (string.equals("horizontal")) {
            return 2;
        }
        if (string.equals("vertical")) {
            return 3;
        }
        if (string.equals("left")) {
            return 3;
        }
        if (string.equals("right")) {
            return 4;
        }
        if (string.equals("top")) {
            return 1;
        }
        if (string.equals("bottom")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid orientation: " + string);
    }

    public Element getDOMElement(Document document) {
        Element element = this.isAttached() ? document.createElement("attachedaxis") : document.createElement("axis");
        if (this.isAttached()) {
            element.setAttribute("ref", this.getMasterAxis().getDasName());
        } else {
            String string = this.getDataMinimum().toString();
            element.setAttribute("dataMinimum", string);
            String string2 = this.getDataMaximum().toString();
            element.setAttribute("dataMaximum", string2);
        }
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("label", this.getLabel());
        element.setAttribute("log", Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.areTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", DasAxis.orientationToString(this.getOrientation()));
        return element;
    }

    public DasAxis createAttachedAxis() {
        return new DasAxis(this.dataRange, this.getOrientation());
    }

    public DasAxis createAttachedAxis(int n) {
        return new DasAxis(this.dataRange, n);
    }

    static DasAxis processAttachedaxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException {
        Object object;
        Object object2;
        String string = element.getAttribute("name");
        DasAxis dasAxis = (DasAxis)formBase.checkValue(element.getAttribute("ref"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<attachedaxis>");
        int n = element.getAttribute("orientation").equals("horizontal") ? 2 : 3;
        DasAxis dasAxis2 = dasAxis.createAttachedAxis(n);
        String string2 = element.getAttribute("row");
        if (!string2.equals("")) {
            object2 = (DasRow)formBase.checkValue(string2, class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
            dasAxis2.setRow((DasRow)object2);
        }
        if (!((String)(object2 = element.getAttribute("column"))).equals("")) {
            object = (DasColumn)formBase.checkValue((String)object2, class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
            dasAxis2.setColumn((DasColumn)object);
        }
        dasAxis2.setDataPath(element.getAttribute("dataPath"));
        dasAxis2.setDrawTca(element.getAttribute("showTca").equals("true"));
        dasAxis2.setLabel(element.getAttribute("label"));
        dasAxis2.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        dasAxis2.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        dasAxis2.setDasName(string);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string, dasAxis2);
        return dasAxis2;
    }

    public static DasAxis createNamedAxis(String string) {
        DasAxis dasAxis = new DasAxis(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), 2);
        if (string == null) {
            string = "axis_" + Integer.toHexString(System.identityHashCode(dasAxis));
        }
        try {
            dasAxis.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return dasAxis;
    }

    public void scanPrevious() {
        Datum datum = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum datum2 = this.getDataMinimum().subtract(datum);
        Datum datum3 = this.getDataMaximum().subtract(datum);
        this.setDataRange(datum2, datum3);
    }

    public void scanNext() {
        Datum datum = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum datum2 = this.getDataMinimum().add(datum);
        Datum datum3 = this.getDataMaximum().add(datum);
        this.setDataRange(datum2, datum3);
    }

    public Shape getActiveRegion() {
        Rectangle rectangle = this.primaryInputPanel.getBounds();
        rectangle.translate(this.getX(), this.getY());
        if (this.oppositeAxisVisible) {
            Rectangle rectangle2 = this.secondaryInputPanel.getBounds();
            rectangle2.translate(this.getX(), this.getY());
            GeneralPath generalPath = new GeneralPath(rectangle);
            generalPath.setWindingRule(0);
            generalPath.append(rectangle2, false);
            return generalPath;
        }
        return rectangle;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseListener(mouseListener);
        this.secondaryInputPanel.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseListener(mouseListener);
        this.secondaryInputPanel.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseMotionListener(mouseMotionListener);
        this.secondaryInputPanel.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseMotionListener(mouseMotionListener);
        this.secondaryInputPanel.removeMouseMotionListener(mouseMotionListener);
    }

    public void TimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (timeRangeSelectionEvent.getSource() != this && !timeRangeSelectionEvent.equals(this.lastProcessedEvent)) {
            this.setDataRange(timeRangeSelectionEvent.getStartTime(), timeRangeSelectionEvent.getEndTime());
            this.lastProcessedEvent = timeRangeSelectionEvent;
            this.fireTimeRangeSelectionListenerTimeRangeSelected(timeRangeSelectionEvent);
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        if (this.timeRangeListenerList == null) {
            this.timeRangeListenerList = new EventListenerList();
        }
        this.timeRangeListenerList.add(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = DasAxis.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, timeRangeSelectionListener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        this.timeRangeListenerList.remove(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = DasAxis.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, timeRangeSelectionListener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (this.timeRangeListenerList == null) {
            return;
        }
        Object[] objectArray = this.timeRangeListenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? DasAxis.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener)) {
                DasDie.println("fire event: " + this.getClass().getName() + "-->" + objectArray[n + 1].getClass().getName() + " " + timeRangeSelectionEvent);
                ((TimeRangeSelectionListener)objectArray[n + 1]).TimeRangeSelected(timeRangeSelectionEvent);
            }
            n -= 2;
        }
    }

    static DasAxis processTimeaxisElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        Object object2;
        String string = element.getAttribute("name");
        Datum datum = TimeUtil.create(element.getAttribute("timeMinimum"));
        Datum datum2 = TimeUtil.create(element.getAttribute("timeMaximum"));
        int n = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        DasAxis dasAxis = new DasAxis(datum, datum2, n);
        String string2 = element.getAttribute("row");
        if (!string2.equals("")) {
            object2 = (DasRow)formBase.checkValue(string2, class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
            dasAxis.setRow((DasRow)object2);
        }
        if (!((String)(object2 = element.getAttribute("column"))).equals("")) {
            object = (DasColumn)formBase.checkValue((String)object2, class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasAxis.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
            dasAxis.setColumn((DasColumn)object);
        }
        dasAxis.setDataPath(element.getAttribute("dataPath"));
        dasAxis.setDrawTca(element.getAttribute("showTca").equals("true"));
        dasAxis.setLabel(element.getAttribute("label"));
        dasAxis.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        dasAxis.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        dasAxis.setDasName(string);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string, dasAxis);
        return dasAxis;
    }

    /*
     * Unable to fully structure code
     */
    private static String format(double var0, String var2_1) {
        var3_2 = DasAxis.pattern.matcher(var2_1);
        if (!var3_2.matches()) {
            throw new IllegalArgumentException("\"" + var2_1 + "\" is not a valid format specifier");
        }
        var4_3 = Integer.parseInt(var2_1.substring(2, var2_1.indexOf(46)));
        var5_4 = Integer.parseInt(var2_1.substring(var2_1.indexOf(46) + 1, var2_1.indexOf(41)));
        var6_5 = new char[var4_3];
        if (var2_1.charAt(1) == 'f' || var2_1.charAt(1) == 'F') {
            var8_6 = 0;
            while (var8_6 < var4_3 - var5_4 - 2) {
                var6_5[var8_6] = 35;
                ++var8_6;
            }
            var6_5[var8_6] = 48;
            var6_5[++var8_6] = 46;
            ++var8_6;
            while (var8_6 < var4_3) {
                var6_5[var8_6] = 48;
                ++var8_6;
            }
            var9_7 = new DecimalFormat(new String(var6_5));
            var7_8 = var9_7.format(var0);
        } else {
            var8_6 = 0;
            while (var8_6 < var4_3 - var5_4 - 6) {
                var6_5[var8_6] = 35;
                ++var8_6;
            }
            var6_5[var8_6] = 48;
            var6_5[++var8_6] = 46;
            ++var8_6;
            while (var8_6 < var4_3 - 5) {
                var6_5[var8_6] = 48;
                ++var8_6;
            }
            var6_5[var8_6] = 69;
            var6_5[var8_6 + 1] = var0 > -1.0 && var0 < 1.0 ? 45 : 43;
            var6_5[var8_6 + 2] = 48;
            var6_5[var8_6 + 3] = 48;
            var9_7 = new DecimalFormat(new String(var6_5));
            var7_8 = var9_7.format(var0);
        }
        if (var7_8.length() <= var4_3) ** GOTO lbl45
        Arrays.fill(var6_5, '*');
        return new String(var6_5);
lbl-1000:
        // 1 sources

        {
            var7_8 = " " + var7_8;
lbl45:
            // 2 sources

            ** while (var7_8.length() < var4_3)
        }
lbl46:
        // 1 sources

        return var7_8;
    }

    static /* synthetic */ VectorDataSet[] access$302(DasAxis dasAxis, VectorDataSet[] vectorDataSetArray) {
        dasAxis.tcaData = vectorDataSetArray;
        return vectorDataSetArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ScanButton
    extends JButton {
        private boolean hover;
        private boolean pressed;

        public ScanButton(String string) {
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.setText(string);
            this.setFocusable(false);
            this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(2, 2, 2, 2)));
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ScanButton this$0;
                {
                    this.this$0 = scanButton;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        this.this$0.setForeground(Color.LIGHT_GRAY);
                        ScanButton.access$1002(this.this$0, true);
                        this.this$0.repaint();
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        this.this$0.setForeground(Color.BLACK);
                        ScanButton.access$1002(this.this$0, false);
                        this.this$0.repaint();
                    }
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    ScanButton.access$1102(this.this$0, true);
                    this.this$0.repaint();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    ScanButton.access$1102(this.this$0, false);
                    this.this$0.repaint();
                }
            });
        }

        protected void paintComponent(Graphics graphics) {
            if (this.hover || this.pressed) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Object object2 = RenderingHints.VALUE_ANTIALIAS_ON;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
                super.paintComponent(graphics2D);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }

        protected void paintBorder(Graphics graphics) {
            if (this.hover || this.pressed) {
                super.paintBorder(graphics);
            }
        }

        static /* synthetic */ boolean access$1002(ScanButton scanButton, boolean bl) {
            scanButton.pressed = bl;
            return scanButton.pressed;
        }

        static /* synthetic */ boolean access$1102(ScanButton scanButton, boolean bl) {
            scanButton.hover = bl;
            return scanButton.hover;
        }
    }

    protected class AxisLayoutManager
    implements LayoutManager {
        protected AxisLayoutManager() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (DasAxis.this != container) {
                throw new IllegalArgumentException();
            }
            if (DasAxis.this.isHorizontal()) {
                this.horizontalLayout();
            } else {
                this.verticalLayout();
            }
            if (DasAxis.this.drawTca && DasAxis.this.getOrientation() == 2 && DasAxis.this.tcaData != null) {
                Rectangle rectangle = DasAxis.this.primaryInputPanel.getBounds();
                int n = (DasAxis.this.getTickLabelFont().getSize() + DasAxis.this.getLineSpacing()) * DasAxis.this.tcaData.length;
                rectangle.height += n;
                DasAxis.this.primaryInputPanel.setBounds(rectangle);
            }
        }

        protected void horizontalLayout() {
            int n = DasAxis.this.getRow().getDMinimum() - 1;
            int n2 = DasAxis.this.getRow().getDMaximum();
            int n3 = DasAxis.this.getColumn().getDMaximum();
            int n4 = DasAxis.this.getColumn().getDMinimum();
            boolean bl = DasAxis.this.orientation == 2 || DasAxis.this.oppositeAxisVisible;
            boolean bl2 = DasAxis.this.orientation == 2 && DasAxis.this.tickLabelsVisible;
            boolean bl3 = DasAxis.this.orientation == 1 || DasAxis.this.oppositeAxisVisible;
            boolean bl4 = DasAxis.this.orientation == 1 && DasAxis.this.tickLabelsVisible;
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            Font font = DasAxis.this.getTickLabelFont();
            int n5 = font.getSize() * 2 / 3;
            if (bl) {
                rectangle = new Rectangle(n4, n2, n3 - n4 + 1, 1);
            }
            if (bl3) {
                rectangle2 = new Rectangle(n4, n, n3 - n4 + 1, 1);
            }
            if (bl) {
                rectangle.height += n5;
            }
            if (bl3) {
                rectangle2.height += n5;
                rectangle2.y -= n5;
            }
            int n6 = DasAxis.this.getFontMetrics(font).stringWidth(" ");
            if (bl2) {
                rectangle.height += font.getSize() * 3 / 2 + n6;
            }
            if (bl4) {
                rectangle2.y -= font.getSize() * 3 / 2 + n6;
                rectangle2.height += font.getSize() * 3 / 2 + n6;
            }
            Rectangle rectangle3 = DasAxis.this.orientation == 2 ? rectangle : rectangle2;
            Rectangle rectangle4 = DasAxis.this.orientation == 2 ? rectangle2 : rectangle;
            rectangle3.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                rectangle4.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(rectangle3);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(rectangle4);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
            if (DasAxis.this.scanPrevious != null && DasAxis.this.scanNext != null) {
                Dimension dimension = DasAxis.this.scanPrevious.getPreferredSize();
                int n7 = n4 - dimension.width - DasAxis.this.getX();
                int n8 = (DasAxis.this.orientation == 2 ? n2 : n - dimension.height) - DasAxis.this.getY();
                DasAxis.this.scanPrevious.setBounds(n7, n8, dimension.width, dimension.height);
                dimension = DasAxis.this.scanNext.getPreferredSize();
                n7 = n3 - DasAxis.this.getX();
                DasAxis.this.scanNext.setBounds(n7, n8, dimension.width, dimension.height);
            }
        }

        protected void verticalLayout() {
            boolean bl = DasAxis.this.orientation == 3 || DasAxis.this.oppositeAxisVisible;
            boolean bl2 = DasAxis.this.orientation == 3 && DasAxis.this.tickLabelsVisible;
            boolean bl3 = DasAxis.this.orientation == 4 || DasAxis.this.oppositeAxisVisible;
            boolean bl4 = DasAxis.this.orientation == 4 && DasAxis.this.tickLabelsVisible;
            int n = DasAxis.this.getColumn().getDMinimum() - 1;
            int n2 = DasAxis.this.getColumn().getDMaximum();
            int n3 = DasAxis.this.getRow().getDMaximum();
            int n4 = DasAxis.this.getRow().getDMinimum();
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            Font font = DasAxis.this.getTickLabelFont();
            int n5 = font.getSize() * 2 / 3;
            if (bl) {
                rectangle = new Rectangle(n, n4, 1, n3 - n4 + 1);
            }
            if (bl3) {
                rectangle2 = new Rectangle(n2, n4, 1, n3 - n4 + 1);
            }
            if (bl) {
                rectangle.width += n5;
                rectangle.x -= n5;
            }
            if (bl3) {
                rectangle2.width += n5;
            }
            int n6 = DasAxis.this.getMaxLabelWidth(DasAxis.this.getFontMetrics(font));
            int n7 = DasAxis.this.getFontMetrics(font).stringWidth(" ");
            if (bl2) {
                rectangle.x -= n6 + n7;
                rectangle.width += n6 + n7;
            }
            if (bl4) {
                rectangle2.width += n6 + n7;
            }
            Rectangle rectangle3 = DasAxis.this.orientation == 3 ? rectangle : rectangle2;
            Rectangle rectangle4 = DasAxis.this.orientation == 3 ? rectangle2 : rectangle;
            rectangle3.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                rectangle4.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(rectangle3);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(rectangle4);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension();
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension();
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

