/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyEditor;
import edu.uiowa.physics.pw.das.event.DasMouseInputAdapter;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.JComponent;

public abstract class DasCanvasComponent
extends JComponent
implements Editable {
    private DasRow row;
    private DasColumn column;
    private ResizeListener rl;
    protected DasMouseInputAdapter mouseAdapter;
    private String dasName;
    private edu.uiowa.physics.pw.das.event.DasUpdateEvent devt;
    boolean dirty = true;

    public DasCanvasComponent() {
        this.setOpaque(false);
        this.rl = new ResizeListener();
        this.row = DasRow.NULL;
        this.column = DasColumn.NULL;
        this.mouseAdapter = new DasMouseInputAdapter(this);
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        try {
            this.setDasName("c_" + Integer.toString(this.hashCode()));
        }
        catch (DasNameException dasNameException) {}
    }

    public void addMouseModule(MouseModule mouseModule2) {
        this.mouseAdapter.addMouseModule(mouseModule2);
    }

    public void removeMouseModule(MouseModule mouseModule2) {
        this.mouseAdapter.removeMouseModule(mouseModule2);
    }

    public DasRow getRow() {
        return this.row;
    }

    public DasColumn getColumn() {
        return this.column;
    }

    public void resize() {
        if (this.column == null || this.row == null) {
            Logger logger = DasApplication.getDefaultApplication().getLogger();
            logger.warning("Null row and/or column in resize: row=" + this.row + " column=" + this.column);
        } else {
            this.setBounds(this.column.getDMinimum(), this.row.getDMinimum(), this.column.getDMaximum() - this.column.getDMinimum(), this.row.getDMaximum() - this.row.getDMinimum());
        }
    }

    public void setRow(DasRow dasRow) {
        if (this.row == dasRow) {
            return;
        }
        DasRow dasRow2 = this.row;
        if (this.row != null) {
            this.row.removepwUpdateListener(this.rl);
        }
        this.row = dasRow;
        if (this.row != null) {
            this.row.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("row", dasRow2, dasRow);
    }

    public void setColumn(DasColumn dasColumn) {
        if (this.column == dasColumn) {
            return;
        }
        DasColumn dasColumn2 = this.column;
        if (this.column != null) {
            this.column.removepwUpdateListener(this.rl);
        }
        this.column = dasColumn;
        if (this.column != null) {
            this.column.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("column", dasColumn2, dasColumn);
    }

    public void showProperties() {
        PropertyEditor propertyEditor = new PropertyEditor(this);
        propertyEditor.showDialog(this);
    }

    public String toString() {
        return this.getClass().getName() + "'" + this.getName() + "'";
    }

    protected void updateImmediately() {
    }

    public void update() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (this.devt == null) {
            this.devt = new edu.uiowa.physics.pw.das.event.DasUpdateEvent(this);
        }
        eventQueue.postEvent(this.devt);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        if (aWTEvent instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent) {
            this.processDasUpdateEvent((edu.uiowa.physics.pw.das.event.DasUpdateEvent)aWTEvent);
        }
    }

    protected void processDasUpdateEvent(edu.uiowa.physics.pw.das.event.DasUpdateEvent dasUpdateEvent) {
        if (this.isDisplayable()) {
            if (this.isDirty()) {
                this.markClean();
                this.updateImmediately();
            }
            this.resize();
            this.repaint();
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (aWTEvent instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent && aWTEvent2 instanceof edu.uiowa.physics.pw.das.event.DasUpdateEvent) {
            return aWTEvent;
        }
        return super.coalesceEvents(aWTEvent, aWTEvent2);
    }

    protected void installComponent() {
    }

    protected void uninstallComponent() {
    }

    public Font getFont() {
        return this.getParent() == null ? super.getFont() : this.getParent().getFont();
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markClean() {
        this.dirty = false;
    }

    public DasCanvas getCanvas() {
        return (DasCanvas)this.getParent();
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = null;
        if (this.getCanvas() != null) {
            dasApplication = this.getCanvas().getDasApplication();
        }
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public Shape getActiveRegion() {
        int n = this.getColumn().getDMinimum();
        int n2 = this.getRow().getDMinimum();
        int n3 = this.getColumn().getDMaximum() - n;
        int n4 = this.getRow().getDMaximum() - n2;
        return new Rectangle(n, n2, n3, n4);
    }

    public DasMouseInputAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    private class ResizeListener
    implements DasUpdateListener {
        private ResizeListener() {
        }

        public void update(DasUpdateEvent dasUpdateEvent) {
            DasCanvasComponent.this.markDirty();
            DasCanvasComponent.this.update();
        }
    }
}

