/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.graph.AttachedColumn;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasColumn
extends DasDevicePosition {
    public static final DasColumn NULL = new NullDasColumn();

    public DasColumn(DasCanvas dasCanvas, double d, double d2) {
        super(dasCanvas, d, d2);
    }

    public DasColumn createSubColumn(double d, double d2) {
        double d3 = this.getMinimum();
        double d4 = this.getMaximum();
        double d5 = d4 - d3;
        return new DasColumn(this.parent, d3 + d * d5, d3 + d2 * d5);
    }

    protected int getDeviceSize() {
        return this.parent.getWidth();
    }

    public int getWidth() {
        return this.getDMaximum() - this.getDMinimum();
    }

    public static DasColumn create(DasCanvas dasCanvas) {
        return new DasColumn(dasCanvas, 0.1, 0.8);
    }

    public DasColumn createAttachedColumn(double d, double d2) {
        return new AttachedColumn(this, d, d2);
    }

    static DasColumn processColumnElement(Element element, DasCanvas dasCanvas, FormBase formBase) throws DasException {
        String string = element.getAttribute("name");
        double d = Double.parseDouble(element.getAttribute("minimum"));
        double d2 = Double.parseDouble(element.getAttribute("maximum"));
        DasColumn dasColumn = new DasColumn(dasCanvas, d, d2);
        dasColumn.setDasName(string);
        DasApplication dasApplication = formBase.getDasApplication();
        NameContext nameContext = dasApplication.getNameContext();
        nameContext.put(string, dasColumn);
        return dasColumn;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("column");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("minimum", Double.toString(this.getMinimum()));
        element.setAttribute("maximum", Double.toString(this.getMaximum()));
        return element;
    }

    static final class NullDasColumn
    extends DasColumn {
        private NullDasColumn() {
            super(null, 0.0, 0.0);
        }

        public int getDMinimum() {
            throw new RuntimeException("null column, column was not set before layout");
        }

        public int getDMaximum() {
            throw new RuntimeException("null column, column was not set before layout");
        }
    }
}

