/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.EnumerationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import edu.uiowa.physics.pw.das.graph.TickVDescriptor;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.swing.JFrame;

public class DasLabelAxis
extends DasAxis
implements DasUpdateListener {
    DecimalFormat nfy = null;
    Datum[] labels = null;
    double[] labelValues = null;
    Units labelUnits = null;
    int[] labelPositions = null;
    DatumFormatter df = null;
    int indexMinimum;
    int indexMaximum;
    private int outsidePadding = 5;
    private boolean floppyItemSpacing = false;

    private void setLabels(Datum[] datumArray) {
        if (datumArray.length == 0) {
            throw new IllegalArgumentException("labels can not be a zero-length array!");
        }
        this.labels = datumArray;
        this.labelPositions = new int[datumArray.length];
        this.indexMinimum = 0;
        this.indexMaximum = datumArray.length - 1;
        this.labelValues = new double[datumArray.length];
        this.labelUnits = datumArray[0].getUnits();
        int n = 0;
        while (n < datumArray.length) {
            this.labelValues[n] = datumArray[n].doubleValue(this.labelUnits);
            if (datumArray[n].getUnits() != this.labelUnits) {
                throw new IllegalArgumentException("Datums must all have same units!");
            }
            ++n;
        }
        this.df = DatumUtil.bestFormatter(datumArray[0], datumArray[1], 1);
    }

    protected DasLabelAxis(Datum[] datumArray, DataRange dataRange, int n) {
        super(dataRange, n);
        this.setLabels(datumArray);
        this.getDataRange().addpwUpdateListener(this);
    }

    public DasLabelAxis(Datum[] datumArray, int n) {
        super(datumArray[0], datumArray[datumArray.length - 1], n, false);
        this.setLabels(datumArray);
        this.getDataRange().addpwUpdateListener(this);
    }

    public int[] getLabelPositions() {
        return this.labelPositions;
    }

    private void updateTickPositions() {
        if (this.isDisplayable()) {
            int n;
            double d;
            int n2;
            int n3 = this.indexMaximum - this.indexMinimum + 1;
            if (this.getOrientation() == 2) {
                n2 = this.getColumn().getWidth() - this.outsidePadding * 2;
                d = (float)n2 / (float)n3;
                if (!this.floppyItemSpacing) {
                    d = (int)d;
                }
                n = this.getColumn().getDMinimum() + this.outsidePadding + (int)(d / 2.0);
            } else {
                n2 = this.getRow().getHeight() - this.outsidePadding * 2;
                d = -1.0f * (float)n2 / (float)n3;
                if (!this.floppyItemSpacing) {
                    d = (int)d;
                }
                n = this.getRow().getDMaximum() - this.outsidePadding + (int)(d / 2.0);
            }
            int n4 = 0;
            while (n4 < this.labelPositions.length) {
                this.labelPositions[n4] = n + (int)(d * (double)(n4 - this.indexMinimum + 0));
                ++n4;
            }
            this.firePropertyChange("labelPositions", null, this.labelPositions);
        }
    }

    public Datum findTick(Datum datum, double d, boolean bl) {
        return datum;
    }

    public void updateTickV() {
        super.updateTickV();
        this.updateTickPositions();
    }

    public TickVDescriptor getTickV() {
        TickVDescriptor tickVDescriptor = new TickVDescriptor();
        tickVDescriptor.units = this.getUnits();
        int n = this.indexMaximum - this.indexMinimum + 1;
        tickVDescriptor.tickV = new double[n];
        tickVDescriptor.minorTickV = new double[0];
        int n2 = 0;
        while (n2 < n) {
            tickVDescriptor.tickV[n2] = this.labels[n2 + this.indexMinimum].doubleValue(tickVDescriptor.units);
            ++n2;
        }
        return tickVDescriptor;
    }

    public int transform(double d, Units units) {
        if (units != this.labelUnits) {
            throw new IllegalArgumentException("units don't match");
        }
        int n = this.findClosestIndex(this.labelValues, d);
        return this.labelPositions[n];
    }

    private int findClosestIndex(int[] nArray, int n) {
        int n2 = 0;
        double d = Math.abs(nArray[n2] - n);
        int n3 = 0;
        while (n3 < this.labelPositions.length) {
            double d2 = Math.abs(nArray[n3] - n);
            if (d2 < d) {
                n2 = n3;
                d = d2;
            }
            ++n3;
        }
        return n2;
    }

    private int findClosestIndex(double[] dArray, double d) {
        int n = 0;
        double d2 = Math.abs(dArray[n] - d);
        int n2 = 0;
        while (n2 < this.labelPositions.length) {
            double d3 = Math.abs(dArray[n2] - d);
            if (d3 < d2) {
                n = n2;
                d2 = d3;
            }
            ++n2;
        }
        return n;
    }

    public Datum invTransform(int n) {
        int n2 = this.findClosestIndex(this.labelPositions, n);
        return this.labels[n2];
    }

    public void setDataRange(Datum datum, Datum datum2) {
        super.setDataRange(datum, datum2);
    }

    protected String tickFormatter(double d) {
        return this.df.format(Datum.create(d, this.labels[0].getUnits()));
    }

    public String getLabel(double d) {
        return this.tickFormatter(d);
    }

    public int getInterItemSpace() {
        return Math.abs(this.transform(this.labels[1]) - this.transform(this.labels[0]));
    }

    public int getItemMin(Datum datum) {
        Units units = datum.getUnits();
        double d = datum.doubleValue(units);
        int n = this.findClosestIndex(this.labelValues, units.convertDoubleTo(this.getUnits(), d));
        int n2 = this.labelPositions[n];
        int n3 = this.getInterItemSpace();
        return n2 - n3 / 2;
    }

    public int getItemMax(Datum datum) {
        int n = this.getInterItemSpace();
        return this.getItemMin(datum) + n;
    }

    public DasAxis createAttachedAxis(DasRow dasRow, DasColumn dasColumn) {
        DasLabelAxis dasLabelAxis = new DasLabelAxis(this.labels, this.getDataRange(), this.getOrientation());
        return dasLabelAxis;
    }

    public DasAxis createAttachedAxis(int n) {
        return new DasLabelAxis(this.labels, this.getDataRange(), n);
    }

    public static void main(String[] stringArray) throws Exception {
        EnumerationUnits enumerationUnits = EnumerationUnits.create("");
        Datum datum = enumerationUnits.createDatum(new Object());
        Datum[] datumArray = new Datum[]{enumerationUnits.createDatum("cat"), enumerationUnits.createDatum("dog"), enumerationUnits.createDatum("fish")};
        DasCanvas dasCanvas = new DasCanvas(400, 400);
        DasRow dasRow = DasRow.create(dasCanvas);
        DasColumn dasColumn = DasColumn.create(dasCanvas);
        Datum[] datumArray2 = enumerationUnits.createDatum(new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
        DasPlot dasPlot = new DasPlot(new DasLabelAxis(datumArray, 2), new DasLabelAxis(datumArray2, 3));
        dasCanvas.add(dasPlot, dasRow, dasColumn);
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(dasCanvas);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
    }

    public void update(DasUpdateEvent dasUpdateEvent) {
        double d = this.getDataRange().getMinimum();
        double d2 = this.getDataRange().getMaximum();
        if (this.getDataRange().getUnits() != this.labelUnits) {
            throw new IllegalArgumentException("units don't match");
        }
        this.indexMinimum = this.findClosestIndex(this.labelValues, d);
        this.indexMaximum = this.findClosestIndex(this.labelValues, d2);
        if (this.indexMinimum > this.indexMaximum) {
            int n = this.indexMinimum;
            this.indexMaximum = this.indexMinimum;
            this.indexMinimum = n;
        }
    }

    protected void paintHorizontalAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        Object object;
        boolean bl = this.getOrientation() == 2 || this.isOppositeAxisVisible();
        boolean bl2 = this.getOrientation() == 2 && this.areTickLabelsVisible();
        boolean bl3 = this.getOrientation() == 2 && !this.axisLabel.equals("");
        boolean bl4 = this.getOrientation() == 1 || this.isOppositeAxisVisible();
        boolean bl5 = this.getOrientation() == 1 && this.areTickLabelsVisible();
        boolean bl6 = this.getOrientation() == 1 && !this.axisLabel.equals("");
        int n3 = this.getRow().getDMinimum() - 1;
        int n4 = this.getRow().getDMaximum();
        int n5 = this.getColumn().getDMaximum();
        int n6 = this.getColumn().getDMinimum();
        Font font = this.getTickLabelFont();
        double d = this.dataRange.getMaximum();
        double d2 = this.dataRange.getMinimum();
        TickVDescriptor tickVDescriptor = this.getTickV();
        double[] dArray = tickVDescriptor.tickV;
        if (bl) {
            graphics2D.drawLine(n6, n4, n5, n4);
        }
        if (bl4) {
            graphics2D.drawLine(n6, n3, n5, n3);
        }
        int n7 = font.getSize() * 2 / 3;
        int n8 = n7 / 2;
        int n9 = 0;
        while (n9 < tickVDescriptor.tickV.length) {
            double d3 = tickVDescriptor.tickV[n9];
            object = tickVDescriptor.units.createDatum(d3);
            n2 = this.getInterItemSpace();
            n = (int)Math.floor((double)this.transform(d3, tickVDescriptor.units) + 0.5) - n2 / 2;
            int n10 = n7;
            if (bl) {
                graphics2D.drawLine(this.getItemMin((Datum)object), n4, this.getItemMin((Datum)object), n4 + n10);
                if (n9 == tickVDescriptor.tickV.length - 1) {
                    graphics2D.drawLine(this.getItemMax((Datum)object), n4, this.getItemMax((Datum)object), n4 + n10);
                }
                if (bl2) {
                    this.drawLabel(graphics2D, d3, n9, n + n2 / 2, n4 + n10);
                }
            }
            if (bl4) {
                graphics2D.drawLine(this.getItemMin((Datum)object), n3, this.getItemMin((Datum)object), n3 - n10);
                if (n9 == tickVDescriptor.tickV.length - 1) {
                    graphics2D.drawLine(this.getItemMax((Datum)object), n3, this.getItemMax((Datum)object), n3 - n10);
                }
                if (bl5) {
                    this.drawLabel(graphics2D, d3, n9, n + n2 / 2, n3 - n10);
                }
            }
            ++n9;
        }
        if (!this.axisLabel.equals("")) {
            int n11;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n12 = this.getTitlePositionOffset();
            object = new GrannyTextRenderer();
            ((GrannyTextRenderer)object).setString(this, this.axisLabel);
            n2 = (int)((GrannyTextRenderer)object).getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl3) {
                n11 = n6 + (n5 - n6 - n2) / 2;
                n = n4 + n12;
                ((GrannyTextRenderer)object).draw(graphics2D2, n11, n);
            }
            if (bl6) {
                n11 = n6 + (n5 - n6 - n2) / 2;
                n = n3 - n12;
                ((GrannyTextRenderer)object).draw(graphics2D2, n11, n);
            }
            graphics2D2.dispose();
        }
    }

    protected void paintVerticalAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        Object object;
        boolean bl = this.getOrientation() == 3 || this.isOppositeAxisVisible();
        boolean bl2 = this.getOrientation() == 3 && this.areTickLabelsVisible();
        boolean bl3 = this.getOrientation() == 3 && !this.axisLabel.equals("");
        boolean bl4 = this.getOrientation() == 4 || this.isOppositeAxisVisible();
        boolean bl5 = this.getOrientation() == 4 && this.areTickLabelsVisible();
        boolean bl6 = this.getOrientation() == 4 && !this.axisLabel.equals("");
        int n3 = this.getColumn().getDMinimum() - 1;
        int n4 = this.getColumn().getDMaximum();
        int n5 = this.getRow().getDMaximum();
        int n6 = this.getRow().getDMinimum();
        Font font = this.getTickLabelFont();
        double d = this.dataRange.getMaximum();
        double d2 = this.dataRange.getMinimum();
        TickVDescriptor tickVDescriptor = this.getTickV();
        double[] dArray = tickVDescriptor.tickV;
        if (bl) {
            graphics2D.drawLine(n3, n6, n3, n5);
        }
        if (bl4) {
            graphics2D.drawLine(n4, n6, n4, n5);
        }
        int n7 = font.getSize() * 2 / 3;
        int n8 = n7 / 2;
        int n9 = 0;
        while (n9 < tickVDescriptor.tickV.length) {
            double d3 = tickVDescriptor.tickV[n9];
            object = tickVDescriptor.units.createDatum(d3);
            if (d3 >= d2 * 0.999 && d3 <= d * 1.001) {
                n2 = this.getInterItemSpace();
                n = (this.getItemMax((Datum)object) + this.getItemMin((Datum)object)) / 2 - graphics2D.getFontMetrics().getAscent() / 5;
                int n10 = n7;
                if (bl) {
                    if (n9 == tickVDescriptor.tickV.length - 1) {
                        graphics2D.drawLine(n3, this.getItemMin((Datum)object), n3 - n10, this.getItemMin((Datum)object));
                    }
                    graphics2D.drawLine(n3, this.getItemMax((Datum)object), n3 - n10, this.getItemMax((Datum)object));
                    if (bl2) {
                        this.drawLabel(graphics2D, d3, n9, n3 - n10, n);
                    }
                }
                if (bl4) {
                    if (n9 == tickVDescriptor.tickV.length - 1) {
                        graphics2D.drawLine(n4, this.getItemMin((Datum)object), n4 + n10, this.getItemMin((Datum)object));
                    }
                    graphics2D.drawLine(n4, this.getItemMax((Datum)object), n4 + n10, this.getItemMax((Datum)object));
                    if (bl5) {
                        this.drawLabel(graphics2D, d3, n9, n4 + n10, n);
                    }
                }
            }
            ++n9;
        }
        if (!this.axisLabel.equals("")) {
            int n11;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n12 = this.getTitlePositionOffset();
            object = new GrannyTextRenderer();
            ((GrannyTextRenderer)object).setString(this, this.axisLabel);
            n2 = (int)((GrannyTextRenderer)object).getWidth();
            graphics2D2.setFont(this.getLabelFont());
            if (bl3) {
                graphics2D2.rotate(-1.5707963267948966);
                n11 = -n5 + (n5 - n6 - n2) / 2;
                n = n3 - n12;
                ((GrannyTextRenderer)object).draw(graphics2D2, n11, n);
            }
            if (bl6) {
                graphics2D2.rotate(1.5707963267948966);
                n11 = n6 + (n5 - n6 - n2) / 2;
                n = -n4 - n12;
                ((GrannyTextRenderer)object).draw(graphics2D2, n11, n);
            }
            graphics2D2.dispose();
        }
    }

    public int getOutsidePadding() {
        return this.outsidePadding;
    }

    public void setOutsidePadding(int n) {
        int n2 = n;
        this.outsidePadding = n;
        this.firePropertyChange("setOutsidePadding", n2, n);
        this.updateTickPositions();
        this.update();
    }

    public boolean isFloppyItemSpacing() {
        return this.floppyItemSpacing;
    }

    public void setFloppyItemSpacing(boolean bl) {
        boolean bl2 = this.floppyItemSpacing;
        this.floppyItemSpacing = bl;
        this.firePropertyChange("floppyItemSpacing", bl2, bl);
        this.updateTickPositions();
        this.update();
    }
}

