/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.DasProgressPanel;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dataset.DataRequestThread;
import edu.uiowa.physics.pw.das.dataset.DataRequestor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.CrossHairMouseModule;
import edu.uiowa.physics.pw.das.event.HorizontalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.event.VerticalRangeSelectorMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRendererUpdateEvent;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableRenderer;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import edu.uiowa.physics.pw.das.util.GrannyTextRenderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasPlot
extends DasCanvasComponent
implements DataSetConsumer {
    protected DataSetDescriptor dataSetDescriptor;
    protected DataSet Data;
    private DasAxis xAxis;
    private DasAxis yAxis;
    protected String offsetTime = "";
    protected String plotTitle = "";
    protected double[] psym_x;
    protected double[] psym_y;
    protected Image plotImage;
    protected RebinListener rebinListener = new RebinListener();
    DnDSupport dndSupport;
    DataRequestThread drt;
    DasProgressPanel progressPanel;
    private List renderers = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasRow;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColumn;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasAxis;

    public DasPlot(DasAxis dasAxis, DasAxis dasAxis2) {
        this.setOpaque(false);
        this.renderers = new ArrayList();
        this.xAxis = dasAxis;
        if (dasAxis != null) {
            if (!dasAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            dasAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            dasAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            dasAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        this.yAxis = dasAxis2;
        if (dasAxis2 != null) {
            if (dasAxis2.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            dasAxis2.addPropertyChangeListener("dataMinimum", this.rebinListener);
            dasAxis2.addPropertyChangeListener("dataMaximum", this.rebinListener);
            dasAxis2.addPropertyChangeListener("log", this.rebinListener);
        }
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            HorizontalRangeSelectorMouseModule horizontalRangeSelectorMouseModule = new HorizontalRangeSelectorMouseModule(this, dasAxis);
            this.mouseAdapter.addMouseModule(horizontalRangeSelectorMouseModule);
            this.mouseAdapter.setPrimaryModule(horizontalRangeSelectorMouseModule);
            horizontalRangeSelectorMouseModule.addDataRangeSelectionListener(dasAxis);
            VerticalRangeSelectorMouseModule verticalRangeSelectorMouseModule = new VerticalRangeSelectorMouseModule(this, dasAxis2);
            this.mouseAdapter.addMouseModule(verticalRangeSelectorMouseModule);
            verticalRangeSelectorMouseModule.addDataRangeSelectionListener(dasAxis2);
            CrossHairMouseModule crossHairMouseModule = new CrossHairMouseModule(this, dasAxis, dasAxis2);
            this.mouseAdapter.addMouseModule(crossHairMouseModule);
            this.mouseAdapter.setSecondaryModule(crossHairMouseModule);
            JMenuItem jMenuItem = new JMenuItem("Dump Data Set To File");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    block6: {
                        if (DasPlot.this.renderers.isEmpty()) {
                            return;
                        }
                        Renderer renderer = (Renderer)DasPlot.this.renderers.get(0);
                        JFileChooser jFileChooser = new JFileChooser();
                        int n = jFileChooser.showSaveDialog(DasPlot.this);
                        if (n != 0) break block6;
                        File file = jFileChooser.getSelectedFile();
                        try {
                            FileChannel fileChannel = new FileOutputStream(file).getChannel();
                            DataSet dataSet = renderer.getDataSet();
                            if (dataSet instanceof TableDataSet) {
                                TableUtil.dumpToAsciiStream((TableDataSet)dataSet, fileChannel);
                            } else if (dataSet instanceof VectorDataSet) {
                                VectorUtil.dumpToAsciiStream((VectorDataSet)dataSet, fileChannel);
                            }
                        }
                        catch (IOException iOException) {
                            DasExceptionHandler.handle(iOException);
                        }
                    }
                }
            });
            this.mouseAdapter.addMenuItem(jMenuItem);
        }
    }

    public DataSet getDataSet() {
        return this.Data;
    }

    public DataSet getData() {
        return this.Data;
    }

    public void setXAxis(DasAxis dasAxis) {
        DasAxis dasAxis2 = this.xAxis;
        Container container = this.getParent();
        if (this.xAxis != null) {
            DasProperties.getLogger().fine("setXAxis upsets the dmia");
            if (container != null) {
                container.remove(this.xAxis);
            }
            dasAxis.removePropertyChangeListener("minimum", this.rebinListener);
            dasAxis.removePropertyChangeListener("maximum", this.rebinListener);
            dasAxis.removePropertyChangeListener("log", this.rebinListener);
        }
        this.xAxis = dasAxis;
        if (dasAxis != null) {
            if (!dasAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            if (container != null) {
                container.add(this.xAxis);
            }
            dasAxis.addPropertyChangeListener("minimum", this.rebinListener);
            dasAxis.addPropertyChangeListener("maximum", this.rebinListener);
            dasAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        if (dasAxis != dasAxis2) {
            this.firePropertyChange("xAxis", dasAxis2, dasAxis);
        }
    }

    public void setYAxis(DasAxis dasAxis) {
        DasAxis dasAxis2 = this.yAxis;
        Container container = this.getParent();
        if (this.yAxis != null) {
            DasProperties.getLogger().fine("setYAxis upsets the dmia");
            if (container != null) {
                container.remove(this.yAxis);
            }
            dasAxis.removePropertyChangeListener("minimum", this.rebinListener);
            dasAxis.removePropertyChangeListener("maximum", this.rebinListener);
            dasAxis.removePropertyChangeListener("log", this.rebinListener);
        }
        this.yAxis = dasAxis;
        if (dasAxis != null) {
            if (dasAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            if (container != null) {
                container.add(this.yAxis);
            }
            dasAxis.addPropertyChangeListener("minimum", this.rebinListener);
            dasAxis.addPropertyChangeListener("maximum", this.rebinListener);
            dasAxis.addPropertyChangeListener("log", this.rebinListener);
        }
        if (dasAxis != dasAxis2) {
            this.firePropertyChange("yAxis", dasAxis2, dasAxis);
        }
    }

    protected void drawInvalid() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return;
        }
        graphics2D.translate(-this.getX(), -this.getY());
        Rectangle rectangle = DasRow.toRectangle(this.getRow(), this.getColumn());
        --rectangle.width;
        --rectangle.height;
        ++rectangle.y;
        graphics2D.setColor(new Color(245, 245, 245, 220));
        graphics2D.fill(rectangle);
        graphics2D.dispose();
    }

    protected void updateImmediately() {
        if (this.dataSetDescriptor != null) {
            this.loadDataSet();
        }
        int n = 0;
        while (n < this.renderers.size()) {
            Renderer renderer = (Renderer)this.renderers.get(n);
            renderer.update();
            ++n;
        }
    }

    protected void loadDataSet() {
        final Container container = this.getParent();
        final Cursor cursor = null;
        if (container != null) {
            container.getCursor();
            container.setCursor(new Cursor(3));
        }
        if (container != null) {
            ((DasCanvas)container).lockDisplay(this);
        }
        Datum datum = this.getXAxis().getDataMaximum().subtract(this.getXAxis().getDataMinimum());
        double d = datum.doubleValue(Units.seconds);
        double d2 = Math.floor((double)this.getColumn().getDMaximum() + 0.5) - Math.floor((double)this.getColumn().getDMinimum() + 0.5);
        double d3 = d / d2;
        if (this.progressPanel == null) {
            this.progressPanel = DasProgressPanel.createComponentPanel(this, "loading data set");
        }
        DataRequestor dataRequestor = new DataRequestor(){

            public void exception(Exception exception) {
                if (!(exception instanceof InterruptedIOException)) {
                    DasExceptionHandler.handle(exception);
                    this.finished(null);
                }
            }

            public void finished(DataSet dataSet) {
                DasPlot.this.progressPanel.setVisible(false);
                if (container != null) {
                    container.setCursor(cursor);
                }
                DasPlot.this.Data = dataSet;
                try {
                    DasPlot.this.updatePlotImage();
                }
                catch (DasException dasException) {
                    DasExceptionHandler.handle(dasException);
                }
                if (container != null) {
                    ((DasCanvas)container).freeDisplay(this);
                }
            }
        };
        if (this.drt == null) {
            this.drt = new DataRequestThread();
        }
        try {
            this.drt.request(this.dataSetDescriptor, this.xAxis.getDataMinimum(), this.xAxis.getDataMaximum(), Datum.create(d3, Units.seconds), dataRequestor, this.progressPanel);
            try {
                this.updatePlotImage();
            }
            catch (DasException dasException) {
                DasExceptionHandler.handle(dasException);
            }
        }
        catch (InterruptedException interruptedException) {
            DasExceptionHandler.handle(interruptedException);
        }
    }

    protected void updatePlotImage() throws DasException {
    }

    protected void paintComponent(Graphics graphics) {
        Object object;
        int n = this.getColumn().getDMinimum();
        int n2 = this.getRow().getDMinimum();
        int n3 = this.getColumn().getDMaximum() - n;
        int n4 = this.getRow().getDMaximum() - n2;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.y + this.getY() >= n2 + n4) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        graphics2D.translate(-this.getX(), -this.getY());
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n - 1, n2 - 1, n3 + 2, n4 + 2);
        graphics2D2.translate(-n + 1, -n2 + 1);
        this.drawContent(graphics2D2);
        int n5 = 0;
        while (n5 < this.renderers.size()) {
            object = (Renderer)this.renderers.get(n5);
            ((Renderer)object).render(graphics2D2, this.xAxis, this.yAxis);
            ++n5;
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n - 1, n2 - 1, n3 + 1, n4 + 1);
        if (this.plotTitle != null && this.plotTitle.length() != 0) {
            object = new GrannyTextRenderer();
            ((GrannyTextRenderer)object).setAlignment(1);
            ((GrannyTextRenderer)object).setString(this, this.plotTitle);
            int n6 = (int)((GrannyTextRenderer)object).getWidth();
            int n7 = n + (n3 - n6) / 2;
            int n8 = n2 - (int)((GrannyTextRenderer)object).getDescent() - (int)((GrannyTextRenderer)object).getAscent() / 2;
            ((GrannyTextRenderer)object).draw(graphics2D, n7, n8);
        }
    }

    protected void drawContent(Graphics2D graphics2D) {
        if (this.plotImage != null) {
            int n = this.getColumn().getDMinimum();
            int n2 = this.getRow().getDMinimum();
            graphics2D.drawImage(this.plotImage, n, n2 + 1, this);
        }
    }

    public void resize() {
        if (this.isDisplayable()) {
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.getTitle());
            int n = (int)grannyTextRenderer.getHeight() + (int)grannyTextRenderer.getAscent() / 2;
            Rectangle rectangle = new Rectangle();
            rectangle.x = this.getColumn().getDMinimum() - 1;
            rectangle.y = this.getRow().getDMinimum() - 1;
            rectangle.width = this.getColumn().getDMaximum() - rectangle.x + 1;
            rectangle.height = this.getRow().getDMaximum() - rectangle.y + 1;
            if (!this.getTitle().equals("")) {
                rectangle.y -= n;
                rectangle.height += n;
            }
            this.setBounds(rectangle);
        }
    }

    public void setTitle(String string) {
        String string2 = this.plotTitle;
        this.plotTitle = string;
        if (this.getCanvas() != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getCanvas().getFont());
            int n = fontMetrics.getHeight() + fontMetrics.getHeight() / 2;
            this.resize();
            this.repaint(0, 0, this.getWidth(), n);
        }
        if (string != string2) {
            this.firePropertyChange("title", string2, string);
        }
    }

    public String getTitle() {
        return this.plotTitle;
    }

    public DasAxis getXAxis() {
        return this.xAxis;
    }

    public DasAxis getYAxis() {
        return this.yAxis;
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dataSetDescriptor;
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.dataSetDescriptor = dataSetDescriptor;
        this.markDirty();
    }

    public void setData(DataSet dataSet) {
        this.Data = dataSet;
        this.markDirty();
    }

    protected void installComponent() {
        super.installComponent();
        if (this.xAxis != null) {
            this.getCanvas().add(this.xAxis, this.getRow(), this.getColumn());
        }
        if (this.yAxis != null) {
            this.getCanvas().add(this.yAxis, this.getRow(), this.getColumn());
        }
        Renderer[] rendererArray = this.getRenderers();
        int n = 0;
        while (n < rendererArray.length) {
            rendererArray[n].installRenderer();
            ++n;
        }
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            this.dndSupport = new PlotDnDSupport(this.getCanvas().dndSupport);
        }
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
        if (this.xAxis != null) {
            this.xAxis.getCanvas().remove(this.xAxis);
        }
        if (this.yAxis != null) {
            this.yAxis.getCanvas().remove(this.yAxis);
        }
        Renderer[] rendererArray = this.getRenderers();
        int n = 0;
        while (n < rendererArray.length) {
            rendererArray[n].uninstallRenderer();
            ++n;
        }
    }

    public void addRenderer(Renderer renderer) {
        if (renderer.parent != null) {
            renderer.parent.removeRenderer(renderer);
        }
        this.renderers.add(renderer);
        renderer.parent = this;
        if (this.getCanvas() != null) {
            renderer.installRenderer();
        }
        this.markDirty();
        this.repaint();
    }

    public void removeRenderer(Renderer renderer) {
        if (this.getCanvas() != null) {
            renderer.uninstallRenderer();
        }
        this.renderers.remove(renderer);
        renderer.parent = null;
    }

    public static DasPlot createDummyPlot() {
        DasAxis dasAxis = new DasAxis(Datum.create(-10), Datum.create(10), 2);
        DasAxis dasAxis2 = new DasAxis(Datum.create(-10), Datum.create(10), 3);
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        return dasPlot;
    }

    public Renderer getRenderer(int n) {
        return (Renderer)this.renderers.get(n);
    }

    public Renderer[] getRenderers() {
        return this.renderers.toArray(new Renderer[0]);
    }

    public static DasPlot processPlotElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        String string = element.getAttribute("name");
        DasRow dasRow = (DasRow)formBase.checkValue(element.getAttribute("row"), class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasPlot.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
        DasColumn dasColumn = (DasColumn)formBase.checkValue(element.getAttribute("column"), class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasPlot.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
        DasAxis dasAxis = null;
        DasAxis dasAxis2 = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object instanceof Element) {
                if (object.getNodeName().equals("xAxis")) {
                    dasAxis = DasPlot.processXAxisElement((Element)object, dasRow, dasColumn, formBase);
                } else if (object.getNodeName().equals("yAxis")) {
                    dasAxis2 = DasPlot.processYAxisElement((Element)object, dasRow, dasColumn, formBase);
                }
            }
            ++n;
        }
        if (dasAxis == null) {
            dasAxis = (DasAxis)formBase.checkValue(element.getAttribute("xAxis"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasPlot.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<axis> or <timeaxis>");
        }
        if (dasAxis2 == null) {
            dasAxis2 = (DasAxis)formBase.checkValue(element.getAttribute("yAxis"), class$edu$uiowa$physics$pw$das$graph$DasAxis == null ? (class$edu$uiowa$physics$pw$das$graph$DasAxis = DasPlot.class$("edu.uiowa.physics.pw.das.graph.DasAxis")) : class$edu$uiowa$physics$pw$das$graph$DasAxis, "<axis> or <timeaxis>");
        }
        object = new DasPlot(dasAxis, dasAxis2);
        ((DasPlot)object).setTitle(element.getAttribute("title"));
        ((DasCanvasComponent)object).setDasName(string);
        ((DasCanvasComponent)object).setRow(dasRow);
        ((DasCanvasComponent)object).setColumn(dasColumn);
        DasApplication dasApplication = formBase.getDasApplication();
        NameContext nameContext = dasApplication.getNameContext();
        nameContext.put(string, object);
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node = nodeList.item(n2);
            if (node instanceof Element && node.getNodeName().equals("renderers")) {
                DasPlot.processRenderersElement((Element)node, (DasPlot)object, formBase);
            }
            ++n2;
        }
        return object;
    }

    private static DasAxis processXAxisElement(Element element, DasRow dasRow, DasColumn dasColumn, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (node.getNodeName().equals("axis")) {
                    DasAxis dasAxis = DasAxis.processAxisElement(element2, formBase);
                    if (!dasAxis.isHorizontal()) {
                        dasAxis.setOrientation(2);
                    }
                    return dasAxis;
                }
                if (node.getNodeName().equals("timeaxis")) {
                    DasAxis dasAxis = DasAxis.processTimeaxisElement(element2, formBase);
                    if (!dasAxis.isHorizontal()) {
                        dasAxis.setOrientation(2);
                    }
                    return dasAxis;
                }
                if (node.getNodeName().equals("attachedaxis")) {
                    DasAxis dasAxis = DasAxis.processAttachedaxisElement(element2, formBase);
                    if (!dasAxis.isHorizontal()) {
                        dasAxis.setOrientation(2);
                    }
                    return dasAxis;
                }
            }
            ++n;
        }
        return null;
    }

    private static DasAxis processYAxisElement(Element element, DasRow dasRow, DasColumn dasColumn, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (node.getNodeName().equals("axis")) {
                    DasAxis dasAxis = DasAxis.processAxisElement(element2, formBase);
                    if (dasAxis.isHorizontal()) {
                        dasAxis.setOrientation(3);
                    }
                    return dasAxis;
                }
                if (node.getNodeName().equals("timeaxis")) {
                    DasAxis dasAxis = DasAxis.processTimeaxisElement(element2, formBase);
                    if (dasAxis.isHorizontal()) {
                        dasAxis.setOrientation(3);
                    }
                    return dasAxis;
                }
                if (node.getNodeName().equals("attachedaxis")) {
                    DasAxis dasAxis = DasAxis.processAttachedaxisElement(element2, formBase);
                    if (dasAxis.isHorizontal()) {
                        dasAxis.setOrientation(3);
                    }
                    return dasAxis;
                }
            }
            ++n;
        }
        return null;
    }

    private static void processRenderersElement(Element element, DasPlot dasPlot, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                if (node.getNodeName().equals("spectrogram")) {
                    dasPlot.addRenderer(SpectrogramRenderer.processSpectrogramElement((Element)node, dasPlot, formBase));
                } else if (node.getNodeName().equals("lineplot")) {
                    dasPlot.addRenderer(SymbolLineRenderer.processLinePlotElement((Element)node, dasPlot, formBase));
                }
            }
            ++n;
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("plot");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("title", this.getTitle());
        Element element2 = document.createElement("xAxis");
        Element element3 = this.getXAxis().getDOMElement(document);
        element3.removeAttribute("orientation");
        if (element3.getAttribute("row").equals(this.getRow().getDasName())) {
            element3.removeAttribute("row");
        }
        if (element3.getAttribute("column").equals(this.getColumn().getDasName())) {
            element3.removeAttribute("column");
        }
        element2.appendChild(element3);
        element.appendChild(element2);
        Element element4 = document.createElement("yAxis");
        Element element5 = this.getYAxis().getDOMElement(document);
        element5.removeAttribute("orientation");
        if (element5.getAttribute("row").equals(this.getRow().getDasName())) {
            element5.removeAttribute("row");
        }
        if (element5.getAttribute("column").equals(this.getColumn().getDasName())) {
            element5.removeAttribute("column");
        }
        element4.appendChild(element5);
        element.appendChild(element4);
        Renderer[] rendererArray = this.getRenderers();
        if (rendererArray.length > 0) {
            Element element6 = document.createElement("renderers");
            int n = 0;
            while (n < rendererArray.length) {
                if (rendererArray[n] instanceof SpectrogramRenderer) {
                    element6.appendChild(((SpectrogramRenderer)rendererArray[n]).getDOMElement(document));
                } else if (rendererArray[n] instanceof SymbolLineRenderer) {
                    element6.appendChild(((SymbolLineRenderer)rendererArray[n]).getDOMElement(document));
                }
                ++n;
            }
            element.appendChild(element6);
        }
        return element;
    }

    public static DasPlot createNamedPlot(String string) {
        DasAxis dasAxis = DasAxis.createNamedAxis(null);
        dasAxis.setOrientation(2);
        DasAxis dasAxis2 = DasAxis.createNamedAxis(null);
        dasAxis2.setOrientation(3);
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        if (string == null) {
            string = "plot_" + Integer.toHexString(System.identityHashCode(dasPlot));
        }
        try {
            dasPlot.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return dasPlot;
    }

    public DasProgressMonitor getDasProgressMonitor() {
        return this.progressPanel;
    }

    public Shape getActiveRegion() {
        return this.getBounds();
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (aWTEvent instanceof DasRendererUpdateEvent && aWTEvent2 instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent dasRendererUpdateEvent = (DasRendererUpdateEvent)aWTEvent;
            DasRendererUpdateEvent dasRendererUpdateEvent2 = (DasRendererUpdateEvent)aWTEvent2;
            if (dasRendererUpdateEvent.getRenderer() == dasRendererUpdateEvent2.getRenderer()) {
                return aWTEvent;
            }
            return null;
        }
        return super.coalesceEvents(aWTEvent, aWTEvent2);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent dasRendererUpdateEvent = (DasRendererUpdateEvent)aWTEvent;
            dasRendererUpdateEvent.getRenderer().updateImmediately();
            this.repaint();
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public void repaint() {
        super.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PlotDnDSupport
    extends DnDSupport {
        PlotDnDSupport(DnDSupport dnDSupport) {
            super(DasPlot.this, 3, dnDSupport);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }

        protected int canAccept(DataFlavor[] dataFlavorArray, int n, int n2, int n3) {
            int n4 = 0;
            while (n4 < dataFlavorArray.length) {
                if (dataFlavorArray[n4].equals(TransferableRenderer.RENDERER_FLAVOR)) {
                    return n3;
                }
                ++n4;
            }
            return -1;
        }

        protected void done() {
        }

        protected boolean importData(Transferable transferable, int n, int n2, int n3) {
            boolean bl = false;
            try {
                Renderer renderer = (Renderer)transferable.getTransferData(TransferableRenderer.RENDERER_FLAVOR);
                DasPlot.this.addRenderer(renderer);
                DasPlot.this.revalidate();
                bl = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {}
            return bl;
        }

        protected Transferable getTransferable(int n, int n2, int n3) {
            return null;
        }

        protected void exportDone(Transferable transferable, int n) {
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DasPlot.this.markDirty();
            DasPlot.this.update();
        }
    }
}

