/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasRow
extends DasDevicePosition {
    public static final DasRow NULL = new NullDasRow();

    public DasRow(DasCanvas dasCanvas, double d, double d2) {
        super(dasCanvas, d, d2);
    }

    protected int getDeviceSize() {
        return this.parent.getHeight();
    }

    public DasRow createSubRow(double d, double d2) {
        double d3 = this.getMinimum();
        double d4 = this.getMaximum();
        double d5 = d3 - d4;
        return new DasRow(this.parent, d4 + d * d5, d4 + d2 * d5);
    }

    public int getHeight() {
        return this.getDMaximum() - this.getDMinimum();
    }

    public static DasRow create(DasCanvas dasCanvas) {
        return new DasRow(dasCanvas, 0.1, 0.9);
    }

    static DasRow processRowElement(Element element, DasCanvas dasCanvas, FormBase formBase) throws DasException {
        String string = element.getAttribute("name");
        double d = Double.parseDouble(element.getAttribute("minimum"));
        double d2 = Double.parseDouble(element.getAttribute("maximum"));
        DasRow dasRow = new DasRow(dasCanvas, d, d2);
        dasRow.setDasName(string);
        DasApplication dasApplication = formBase.getDasApplication();
        NameContext nameContext = dasApplication.getNameContext();
        nameContext.put(string, dasRow);
        return dasRow;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("row");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("minimum", Double.toString(this.getMinimum()));
        element.setAttribute("maximum", Double.toString(this.getMaximum()));
        return element;
    }

    static class NullDasRow
    extends DasRow {
        public NullDasRow() {
            super(null, 0.0, 0.0);
        }

        public int getDMinimum() {
            throw new RuntimeException("null row, row was not set before layout");
        }

        public int getDMaximum() {
            throw new RuntimeException("null row, row was not set before layout");
        }
    }
}

